/******************************************************************
 *FILE: mcp_fsmMCPUpdActions.h
 *SW-COMPONENT: SWUPDATE
 *DESCRIPTION: FSM for MCP-Updater
 *COPYRIGHT: © 2017 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
 ******************************************************************/
#ifndef  _SWUPD_FSMMCP_ACTIONS_H
#define  _SWUPD_FSMMCP_ACTIONS_H

//----------------------------------------------------------------------------------------
// includes
//----------------------------------------------------------------------------------------
#ifndef ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
#include "trace_if.h"
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ai_sw_update/common/base/imp/swu_macros.h"
#include "swupd_fsmMCPUpd.h"
#include "mcp_CsmProxy.h"
#include <fstream>
#include "util/swu_util.hpp"
#include "mcp_FileHandler.h"
#include "mcp_ClientHandler.h"
#include "mcp_UpdaterProxy.h"
#include "mcp_Defines.h"

extern const char *strenMcpCtrlState[30];

class mcp_FileHandler;
class mcp_ClientHandler;
class mcp_UpdaterProxy;
class mcp_fsmMCPUpdActions : public swupd_fsmMCPUpd::FsmBehaviour
{
	
 SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(mcp_fsmMCPUpdActions);
public:
  // virtual void actConditionalSetWaitForBusy ( void* pArg );
   virtual void actDecNRC27Count ( void* pArg );
   virtual void actEvalPreDistributeStatus ( void* pArg );
   virtual void actEvaluateRequestResponse ( void* pArg );
   virtual void actEvaluateTimeout ( void* pArg );
   virtual void actExit ( void* pArg );
   virtual void actFillBufferForDefaultSessionRequest ( void* pArg );
   virtual void actFillBufferForExtendedSessionRequest ( void* pArg );
   virtual void actFillBufferForPreDistribute ( void* pArg );
   virtual void actFillBufferForProgrammingSessionRequest ( void* pArg );
   virtual void actFillBufferForRequestEraseMemoryRequest ( void* pArg );
   virtual void actFillBufferForRequestKeyRequest ( void* pArg );
   virtual void actFillBufferForRequestDownloadStartRequest ( void* pArg );
   virtual void actFillBufferForRequestSeedRequest ( void* pArg );
   virtual void actFillBufferForSendNewVersion ( void* pArg );
   virtual void actHandlePreDistributeError ( void* pArg );
   virtual void actOnCriticalError ( void* pArg );
   virtual void actPreparePreDistribute ( void* pArg );
   virtual void actPrintCurrentState ( void* pArg );
   virtual void actRestartTimerLong ( void* pArg );
   virtual void actSendRequest ( void* pArg );
   virtual void actStartTimer ( void* pArg );
   virtual void actStopDistributeAndReturnError ( void* pArg );
   virtual void actStopTimer ( void* pArg );
   virtual void actStoreDistribute ( void* pArg );
   virtual void actUDSRequestFailed ( void* pArg );
   virtual void actWaitForJumpToBoot ( void* pArg );
   virtual void actFillBufferForReadMCPSWVersion ( void* pArg );
   virtual void actCompleteReadMCPSWVersion ( void* pArg );
   virtual void actResetRetrycounter ( void* pArg );
   virtual bool ifRetryCountNotExceeded ( void* pArg );
   virtual void actStopUpdate(void*);
   
   // FSM guards
   virtual bool IfError ( void* pArg );
   virtual bool ifExistNextPreDistribute ( void* pArg );
   virtual bool ifLastPreDistributeSuccess ( void* pArg );
   virtual bool ifLessThanMaxNoOfTimeout ( void* pArg );
   virtual bool ifLessThanMaxNoOfTrials ( void* pArg );
   virtual bool ifNotNRC27Received ( void* pArg );
   virtual bool ifNRC27CountNotZero ( void* pArg );
   virtual bool ifNRC27Received ( void* pArg );
   virtual bool ifPreDistributeSuccess ( void* pArg );
   virtual bool ifResponseWasForLastRequest ( void* pArg );
   virtual bool ifRetryRequired ( void* pArg );
   virtual void actStoreSeed ( void* pArg );
   virtual void actNRC27Received ( void* pArg );
   virtual bool ifFlashFileNotExists ( void* pArg );
   virtual bool IfUDSRequestFailed ( void* pArg );
   
public:
swupd_fsmMCPUpd::Fsm* pFsm; // pointer to the FSM object
protected:
   // copy constructor. Intentionally definition is not implemented.
   mcp_fsmMCPUpdActions ( const mcp_fsmMCPUpdActions& obj );
   // copy assignment operator. Intentionally definition is not implemented.
   mcp_fsmMCPUpdActions& operator = ( const mcp_fsmMCPUpdActions& obj );
   
   
private:

   // Buffers for UDS Request and Response
   std::vector<unsigned char> bufUDSResponse;
   std::vector<unsigned char> bufUDSRequest;
   // Buffer for the 1st request to compare it with 2nd response
   std::vector<unsigned char> bufUDSRequestCopy;
   // Buffer for the resultcode from a Response
   std::vector<unsigned char> bufResultBuffer;
   
   // Buffer for the resultcode if it is negative response
   std::vector<unsigned char> bufResultBuffer_Negative;
   
   unsigned char iopKeyArray[MAX_KEY_BYTES];
   tU32 u32Length;
      
   mcp_CsmProxy *pmcpCsmProxy;
   mcp_FileHandler *pmcp_FileHandler;
   mcp_UpdaterProxy *pmcpUpdaterProxy;
   std::string updateFilePath;
   
   bool	isNRC27Received;
   int  NRC27Count;
   int_least32_t iErrorCode;
   bool lastPreDistributeSuccess;
   int  iNoOfTimeout;
   int	iNoOfTrials;
   bool updateFailed;
   
   tPCU8 pRequestSendReq;
   tU16 u16LengthSendReq; 
   bool bUDSRequestFailed;
   unsigned int sendrequestRetries;

   void setUpdateCompleted(bool updateCompleted);
   void setupdateFailed(bool updateStatus);
   void setNRC27Status(bool NRC27Status);
	
public:

   void vPrintVector (std::vector<unsigned char> buffer, int printOnLevel);
   bool bRequestEqualToResponse(std::vector<unsigned char> request, std::vector<unsigned char> response, tU32 u32Length );
   mcp_fsmMCPUpdActions();
   virtual ~mcp_fsmMCPUpdActions(void);
   void vUdsMessageReceived(tPCU8 bufUDSMessage, tU32 u32Length);
   void vAcceptEvent(swupd_fsmMCPUpd::FsmEvent event, void* pArg );
   void vAcceptEventInternal(swupd_fsmMCPUpd::FsmEvent event, void* pArg );
   const char* vGetStateName(void);
   void setUpdateFilePath(std::string path);
   std::string getUpdateFilePath(void);
   int_least32_t getMCPErrorCode(void);
   void setMCPErrorCode(int_least32_t);
   bool m_updatecompleted;
   bool getMCPUpdateStatus();
   std::string binaryVersionInfo;
   std::string mcpSWVersion;

};   
	
SWU_DECL_GET_AND_RELEASE_INSTANCE(mcp_fsmMCPUpdActions);	
#endif 
