/************************************************************************
* File: mcp_UpdaterProxy.h
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_UPDATERPROXY_H_
#define _MCP_UPDATERPROXY_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <istream>
#include <iterator>
#include <algorithm>
#include <errno.h>
#include <dirent.h>
#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <iomanip>
#include <vector>
#include <future>
#include <thread>
#include <atomic>
#include "mcp_Defines.h"

#include <chrono>
#include <ctime>
#include <exception>
#include <stdexcept>

#include "util/swu_singleton.hpp"

#include "ai_sw_update/common/base/imp/swu_macros.h"

#include "UpdateLog.h"
#include "mcp_Timer.h"

using namespace ::ai_sw_update::common;

class mcp_UpdaterProxy:public swu::Singleton<mcp_UpdaterProxy>
{
SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(mcp_UpdaterProxy);
public:
    mcp_UpdaterProxy();
   virtual ~mcp_UpdaterProxy();
   friend class swu::Singleton<mcp_UpdaterProxy>;
   void  startTimer();
   void  stopTimer();
   void  waitTimerForJumpToBoot(uint_least32_t millisecondsToDelay);
   
private:
    mcp_Timer pmcpTimer;

};
SWU_DECL_GET_AND_RELEASE_INSTANCE(mcp_UpdaterProxy);
#endif //_MCP_UPDATERPROXY_H_
