/************************************************************************
 * File: mcp_UpdaterProxy.cpp
 * SW-Component:
 *
 * Description:
 *	Calls APIs of MCP library and handles the responses
 *
 * Author:
 *   RamaGopalReddy.Bommireddy@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
 * 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
 ***********************************************************************/

using namespace std;

#include "mcp_UpdaterProxy.h"


#include "ai_sw_update/common/base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_MCP
#define ETG_I_FILE_PREFIX 				mcp_UpdaterProxy::
#include "trcGenProj/Header/mcp_UpdaterProxy.cpp.trc.h"
#endif

#ifndef __SW_UPDATE_UNIT_TESTING__
// Implementation of the methods getInstanceOfmcp_UpdaterProxy and releaseInstanceOfmcp_UpdaterProxy
// In case of __SW_UPDATE_UNIT_TESTING__ they are implemented in mock!
SWU_IMPL_GET_AND_RELEASE_INSTANCE(mcp_UpdaterProxy);
#endif

// Implementation of the singleton methods
SWU_IMPL_SINGLETON(mcp_UpdaterProxy);

/************************************************************************
 * FUNCTION: mcp_UpdaterProxy()
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
mcp_UpdaterProxy::mcp_UpdaterProxy()                             
{
	ETG_TRACE_USR4(("mcp_UpdaterProxy::mcp_UpdaterProxy constructor called"));
	pmcpTimer.setDelay(TIMER_TO_GET_RESPONSE);
}

/************************************************************************
 * FUNCTION: ~mcp_UpdaterProxy
 * DESCRIPTION: Destruction
 * PARAMETER: None
 * RETURNVALUE: None
 *************************************************************************/
mcp_UpdaterProxy::~mcp_UpdaterProxy()
{ 
	ETG_TRACE_USR4(("mcp_UpdaterProxy::mcp_UpdaterProxy destructor called"));
}

/************************************************************************
 * FUNCTION: mcp_UpdaterProxy()
 *
 * DESCRIPTION: startTimer
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/

void mcp_UpdaterProxy::startTimer()
{ 
	ETG_TRACE_USR4(("mcp_UpdaterProxy::startTimer called"));
	pmcpTimer.startTimer();
}

/************************************************************************
 * FUNCTION: mcp_UpdaterProxy()
 *
 * DESCRIPTION: stopTimer
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/

void mcp_UpdaterProxy::stopTimer()
{ 
	ETG_TRACE_USR4(("mcp_UpdaterProxy::stopTimer called"));
	pmcpTimer.stopTimer();
}


/************************************************************************
 * FUNCTION: mcp_UpdaterProxy()
 *
 * DESCRIPTION: waitTimerForJumpToBoot
 *
 * PARAMETER: secondsToDelay
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_UpdaterProxy::waitTimerForJumpToBoot(uint_least32_t millisecondsToDelay)
{

	clock_t time_ticks;
	UpdateLog::vUpdateLogTrace ("%s mcp_UpdaterProxy waitTimerForJumpToBoot", DL_LOG_INFO);
	ETG_TRACE_USR4(("mcp_UpdaterProxy:: waitTimerForJumpToBoot"));
	ETG_TRACE_USR4(("mcp_UpdaterProxy:: milli seconds to delay = %u ms",millisecondsToDelay ));
	
	uint_least32_t clockTicksToDelay = (CLOCKS_PER_SEC * millisecondsToDelay)/MILLISEC_PER_SEC;
	ETG_TRACE_USR4(("mcp_UpdaterProxy:: clockTicksToDelay= %u",clockTicksToDelay ));
	UpdateLog::vUpdateLogTrace ("%s mcp_UpdaterProxy clockTicksToDelay %u", DL_LOG_INFO,clockTicksToDelay);

    	// Storing start time 
    	clock_t start_time = clock(); 
	ETG_TRACE_USR4(("mcp_UpdaterProxy:: Start time= %f seconds",(static_cast<float>(start_time)/CLOCKS_PER_SEC) ));
	UpdateLog::vUpdateLogTrace ("%s mcp_UpdaterProxy Start time %f", DL_LOG_INFO,(static_cast<float>(start_time)/CLOCKS_PER_SEC));    

	//Delaying for 200ms to jump MCP to programming session.
	while (clock() < (static_cast<clock_t>(start_time + clockTicksToDelay)))
	{
		time_ticks = clock();
	}
	ETG_TRACE_USR4(("mcp_UpdaterProxy:: End time= %f seconds",(static_cast<float>(time_ticks)/CLOCKS_PER_SEC) ));
	UpdateLog::vUpdateLogTrace ("%s mcp_UpdaterProxy End time %f", DL_LOG_INFO,(static_cast<float>(time_ticks)/CLOCKS_PER_SEC));
	
}
