/************************************************************************
* File: mcp_Timer.h
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef  _MCP__TIMER_H_
#define  _MCP__TIMER_H_

#include <unistd.h>
#include <stdlib.h>
#include <exception>
#include <stdexcept>
#include <iostream>
#include <chrono>

#include <thread>
#include <atomic>
#include "swupd_fsmMCPUpd.h"

class mcp_Timer
{
public:
	mcp_Timer():m_milliseconds(0){
	}
	~mcp_Timer();

	// Fuction to initiate the timer
	auto init()->bool;

	// Fuction to start the timer when we make a call to driver.
	auto startTimer() -> bool;

	// Fuction to stop the timer
	void stopTimer();

	// Fuction to set the milliseconds
	void setDelay(unsigned int milliseconds);

	// Fuction to raise the EventTimeout
	void raiseEventTimeout();
	void startThread();
	void joinThread();
	
private:

	// Fuction to handle the execution of the timer
	void threadFunc(std::future<void> fu);

	// ID for the duration time of receiving response 
	uint_least32_t m_milliseconds;

	//ID for start the new thread 
	std::thread m_thread;
	std::promise<void> m_promise;
};

#endif	
