/************************************************************************
* File: mcp_QueueHandler.h
* SW-Component: 
* Description: Manages the queue for handling CSM Proxy events
* Author:
*	Surparaju.Pavankumar@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 28.04.2020 - Initial version - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_QUEUEHANDLER_H_
#define _MCP_QUEUEHANDLER_H_


#include <queue>
#include <thread>
#include <mutex>
#include <condition_variable>
#include <pthread.h>
#include "mcp_Request.h"

using namespace std;

class mcp_QueueHandler
{
public:
    mcp_QueueHandler();
    virtual ~mcp_QueueHandler();

      const mcp_Request vPopQueue();
      void bPushQueue(const mcp_Request& pReq);
   private:
      queue<mcp_Request> m_qRequestQueue;
      std::mutex mq_mutex;
      std::condition_variable mq_count;
};

#endif 
