/************************************************************************
 * File: mcp_QueueHandler.cpp
 * SW-Component: 
 * Description: Manages the queue for handling CSM Proxy events
 * Author:
 *	Surparaju.Pavankumar@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 28.04.2020 - Initial version - Surparaju.Pavankumar@in.bosch.com
 ***********************************************************************/
#include <stdlib.h>
#include "mcp_QueueHandler.h"


/************************************************************************
* FUNCTION: mcp_QueueHandler::mcp_QueueHandler()
*
* DESCRIPTION: Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
mcp_QueueHandler::mcp_QueueHandler()
{	
}

/************************************************************************
* FUNCTION: mcp_QueueHandler::~mcp_QueueHandler()
*
* DESCRIPTION: Destructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
mcp_QueueHandler::~mcp_QueueHandler()
{
}


/************************************************************************
 * FUNCTION: mcp_QueueHandler::vPopQueue()
 *
 * DESCRIPTION: Pop and discard elements
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
const mcp_Request mcp_QueueHandler::vPopQueue()
{
   std::unique_lock<std::mutex> mlock(mq_mutex);
   while (m_qRequestQueue.empty())
   {
      mq_count.wait(mlock);
   }
   mcp_Request pReq = m_qRequestQueue.front();
   m_qRequestQueue.pop();
   return pReq;
}

/************************************************************************
 * FUNCTION: mcp_QueueHandler::bPushQueue(mcp_Request* pReq)
 *
 * DESCRIPTION: Push object to the queue
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *************************************************************************/
void mcp_QueueHandler::bPushQueue(const mcp_Request& pReq)
{
   std::unique_lock<std::mutex> mlock(mq_mutex);
   m_qRequestQueue.push(pReq);
   mlock.unlock();     // unlock before notificiation to minimize mutex contention
   mq_count.notify_one(); // notify one waiting thread
}
