/************************************************************************
* File: mcp_FileHandler.h
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_FILEHANDLER_H_
#define _MCP_FILEHANDLER_H_

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <istream>
#include <iterator>
#include <algorithm>
#include <errno.h>
#include <dirent.h>
#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <iomanip>
#include <vector>
#include <sys/sendfile.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "util/swu_singleton.hpp"
#include "mcp_Defines.h"

#include "ai_sw_update/common/base/imp/swu_macros.h"
#include "util/swu_util.hpp"

class mcp_FileHandler:public swu::Singleton<mcp_FileHandler>
{
SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(mcp_FileHandler);
public:
    mcp_FileHandler();
   ~mcp_FileHandler();
   
   unsigned int getcurrentIteration();
   unsigned int getMaxIteration();
   bool ReadBuffer(std::vector<unsigned char>& data, unsigned long int seek, unsigned int &bytesread);
   bool CalculateMaxIterations();
   void setFilePath(std::string path);
   void IncrcurrentIteration();
   bool isLastIteration();
   friend class swu::Singleton<mcp_FileHandler>;
   bool ifFileExists();
   unsigned int calculateFileSize();
   
private:
   unsigned int maxIterations;
   unsigned int currentIteration;
   std::string filepath;

};
SWU_DECL_GET_AND_RELEASE_INSTANCE(mcp_FileHandler);
#endif //_MCP_FILEHANDLE_H_
