/************************************************************************
* File: mcp_Defines.h
* SW-Component:
*
* Description:
*	All autosar updater related common declarations and definitions
*
* Author:
*  
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/
#ifndef _MCP_DEFINES_H_
#define _MCP_DEFINES_H_

using namespace std;
#include <string>

#include "ai_osal_linux/components/system/system_types.h"

#define MAX_BUFFER_SIZE			256
#define BYTES_TO_READ			256
#define MAX_NUMBER_OF_TRIALS		3	

#define PRINT_VECTOR_ON_DEBUG_LEVEL_2           2
#define PRINT_VECTOR_ON_DEBUG_LEVEL_4           4

#define MCP_CAN_KEY_NEGATIVE_RESPONSE		0x7F
#define MCP_REQUEST_LENGTH_ERROR		0x13
#define MCP_10SEC_TIMER_ERROR			0x37

#define MCP_CAN_NRC_27                         	0x27

#define MCP_SESSION                       	0x10
#define MCP_SESSION_POSITIVE_RESPONSE     	0x50

#define MCP_DEFAULT_SESSION			0x01
#define MCP_EXTENDED_SESSION        		0x03
#define MCP_PROGRAMMING_SESSION     		0x02

#define MCP_SEED_KEY_REQUEST                    0x27
#define MCP_SEED_KEY_REQUEST_POSITIVE_RESPONSE  0x67

#define MCP_KEY_NEGATIVE_RESPONSE_1             0x7F
#define MCP_KEY_NEGATIVE_RESPONSE_2             0x27

#define MCP_SEED_REQUEST                       	0x03
#define MCP_KEY_REQUEST                       	0x04

#define MCP_ERASE_MEMORY_REQUEST                0x31
#define MCP_ERASE_MEMORY_POSITIVE_RESPONSE      0x71

#define MCP_DOWNLOAD_START_REQUEST              0x34
#define MCP_DOWNLOAD_START_POSITIVE_RESPONSE    0x74

#define MCP_TRANSMIT_IMAGE_DATA_REQUEST          0x36
#define MCPTRANSMIT_IMAGE_DATA_POSITIVE_RESPONSE 0x76

#define   BLOCK_INDEX_1                         0x01
#define   BLOCK_INDEX_2                         0x02
#define   BLOCK_INDEX_3                         0x03

#define DID_BYTE_01				0x01
#define DID_BYTE_02				0xFF
#define DID_BYTE_03				0x00

#define LOGICAL_ADDRESS_01			0x00
#define LOGICAL_ADDRESS_02			0x00
#define LOGICAL_ADDRESS_03			0x00
#define LOGICAL_ADDRESS_04			0x00

#define FORMATE_IDENTIFIER_1			0x00

#define LOGICAL_ADDRESS_LENGTH	   		0x04
#define FILE_SIZE_LENGTH			0x04

#define MAX_NUMBER_OF_TIMEOUT       		0

#define MAX_BYTES 				256

#define ONE_BYTE_TO_VERIFY			1
#define TWO_BYTES_TO_VERIFY			2
#define THREE_BYTES_TO_VERIFY			3
#define FOUR_BYTES_TO_VERIFY			4
#define MCP_SEND_NEW_SW_VERSION			0x2E
#define MCP_SEND_NEW_SW_VER_BYTE1		0x02
#define MCP_SEND_NEW_SW_VER_BYTE2		0x00

#define MCP_SEND_NEW_SW_VERSION_POSITIVE	0x6E

#define MCP_NEW_SW_VERSION_LEN			15
#define MCP_NEW_SW_ADD_VER_READ			0x4000

#define MAX_KEY_BYTES			32
#define MAX_SEED_BYTES			16

#define SECURITY_ACCESS_LEVEL		0x03

#define MAX_KEY_RETRIES_REACHED		0x36
#define KEY_RETRY_REQUIRED		0x35
#define DID_NOT_MATCHED			0x31
#define NO_SECURITY_ACCESS		0x33
#define MCP_SUB_FUNCTION_ERROR		0x12
#define MCP_VERSION_ERROR		0x22

#define FORMATE_IDENTIFIER		0x20
#define MAX_NO_BLOCK_LEN_BYTE1		0x01
#define MAX_NO_BLOCK_LEN_BYTE2		0x00

#define DELAY_MILLISEC_TO_JUMP_BOOT	200
#define TIMER_TO_GET_RESPONSE		30000
#define MILLISEC_PER_SEC		1000

#define MCP_READ_SW_VERSION		0X22
#define MCP_READ_SW_VERSION_BYTE1	0XC0
#define MCP_READ_SW_VERSION_BYTE2	0X04

#define MCP_READ_SW_VERSION_POSITIVE_RESPONSE	0X62
#define MAX_RESEND_RETRIES 			2

#define KEY_SIZE 				32
#define SEED_SIZE 				16

enum eTraceLevels {
  TRACE_LEVEL_1=1,
  TRACE_LEVEL_2
};

//please don't enabled this, only enable for developer testing.
//this will full stdout buffer which leads serious issue.
//#define DBG_TRACE_ENABLED TRACE_LEVEL_2

#ifdef DBG_TRACE_ENABLED
#include <stdio.h>
#define DEBUG_TRACE(level,fmtstr, args...) \
	(level <= DBG_TRACE_ENABLED) ? printf("" fmtstr "\n", ##args) : 0;
#else
#define DEBUG_TRACE(fmtstr, args...)
#endif
#define ENMCPCTRLSTATE      (int_least32_t)enMcpCtrlState

//Exit codes for MCP client APP
 enum class enMcpCtrlState{
	MCP_APPCTRL_EXIT_SUCCESS=0,
	MCP_APPCTRL_UPDATE_SUCCESS,
	MCP_APPCTRL_VERSION_OK,
	MCP_APPCTRL_VERSION_ERROR,
	MCP_APPCTRL_SWUPDATE_PARSE_CMDARGS_FAILED,
	MCP_APPCTRL_NULL_POINTER_ERROR,
	MCP_APPCTRL_CLIENT_THREAD_CREATION_FAILED,
	MCP_DEFAULT_SESSION_FAILED,
	MCP_EXTENDED_SESSION_FAILED,
	MCP_PROGRAMMING_SESSION_FAILED,
	MCP_REQUEST_SEED_FAILED,
	MCP_REQUEST_KEY_FAILED,
	MCP_SENT_NEW_VERSION_FAILED,
	MCP_REQUEST_ERASE_MEMORY_FAILED,
	MCP_REQUEST_DOWNLOAD_FAILED,
	MCP_TRANSMIT_DATA_FAILED,
	MCP_TIMEOUT_FAILED,
	MCP_RQUEST_LENGTH_ERROR,
	MCP_10SEC_TIMER_IS_ZERO,
	MCP_NOT_IN_PROG_SESSION,
	MCP_KEY_IS_NOT_MATCHED,
	MCP_DID_NOT_MATCHED,
	MCP_NO_SECUTIRY_ACCESS,
	MCP_SUB_FUNC_ERROR,
	MCP_INSTALLED_VERSION_HIGHER,
	MCP_UPDATE_ACTS_NULL,
	MCP_MAX_RETRIES_REACHED,
	MCP_APPCTRL_NONE
};

enum class enMcpAction{
	MCP_ACTION_NONE,
	MCP_ACTION_VERSION,
	MCP_ACTION_UPDATE
} ;


#endif
