/************************************************************************
* File: mcp_ClientHandler.h
* SW-Component:
*
* Description:
*	Calls APIs of MCP library
*
* Author:
*   RamaGopalReddy.Bommireddy@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 31.12.2019 - Initial version - RamaGopalReddy.Bommireddy@in.bosch.com
* 28.02.2020 - Revision 1.0    - Surparaju.Pavankumar@in.bosch.com
***********************************************************************/

#ifndef _MCP_CLIENTHANDLER_H_
#define _MCP_CLIENTHANDLER_H_

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <istream>
#include <iterator>
#include <algorithm>
#include <thread>
#include <atomic>
#include "swupd_fsmMCPUpd.h"
#include "util/swu_singleton.hpp"
#include "mcp_Defines.h"
#include "UpdateLog.h"
#include "util/swu_util.hpp"
#include "mcp_CsmProxy.h"
#include "mcp_fsmMCPUpdActions.h"
#include "mcp_FileHandler.h"
#include "mcp_QueueHandler.h"

using namespace ::ai_sw_update::common;
class mcp_fsmMCPUpdActions;

class mcp_ClientHandler
{
  
public:
	mcp_ClientHandler();
	~mcp_ClientHandler();
	
	auto update() -> void;
	auto ReadVersion()->void;
	auto createMCPClientHandlerThread() -> void;
	auto mcpJoinThreads () -> void;
	auto vLibInterfaceWorkerThread() -> void;
	auto getLastError() -> int_least32_t;
	void setFilePath(std::string path);
	void sendEventToFSM(swupd_fsmMCPUpd::FsmEvent event);
	static mcp_QueueHandler* pclGetQueueHandle();

private:
     
	int_least32_t mcpLastError;
	mcp_fsmMCPUpdActions* pmcp_fsmMCPUpdActions;
     	std::string filePath;
	std::thread m_clientthread;
	int_least32_t iErrorCode;
	void setLastError(int_least32_t error_code);
	static mcp_QueueHandler* m_pQueueHandle;
	void vProcessCSMEvent(mcp_Request& pReq);

};

#endif //_MCP_CLIENTHANDLER_H_
