
// KDS entries
#define KDS_KEY_SWUPD_VARIANT_INFO (0xa070)
#define KDS_KEY_CMVARIANTCODING (0x0df4)
#define KDS_KEY_CUSTOMER_VARIANTCODING (0x0da2)
#define KDS_KEY_HARDWARE_VERSION (0x010e)
#define KDS_KEY_ECU_PARTNUMBER (0x0105)

// KDS entry fields for KDS_KEY_CMVARIANTCODING
#define KDS_CMVC_DISPLAYTYPE (2)
#define KDS_CMVC_OEM_TYPE (3)
#define KDS_CMVC_HW_ASSEMBLY (4)
#define KDS_CMVC_ADR3_VARIANT (5)
#define KDS_CMVC_USB_INFO (8)
#define KDS_CMVC_DTBID (13)

// KDS entry masks for KDS_CMVC_HW_ASSEMBLY
#define KDS_MASK_DAB_TUNER (0x10)
#define KDS_MASK_CD (0x08)
#define KDS_MASK_AMP (0x40)

// KDS entry values for KDS_CMVC_HW_ASSEMBLY
#define KDS_DISPLAYTYPE_COLOR (0x0A)
#define KDS_DISPLAYTYPE_GREY (0x0B)

// KDS entry fields for KDS_KEY_MIB2VARIANTCODING
#define KDS_MIB2_PLATFORM (0)
#define KDS_MIB2_REGION (1)

// KDS entry values for KDS_KEY_MIB2VARIANTCODING
#define KDS_MIB2_PLATFORM_MQB (0x01)
#define KDS_MIB2_PLATFORM_PQ (0x02)
#define KDS_MIB2_REGION_ROW (0x02)
#define KDS_MIB2_REGION_USA (0x03)


// KDS entry values for KDS_CMVC_OEM_TYPE
const char *oem_names[] = {
  "VW",
  "Seat",
  "Skoda",
  "Audi",
  "BMW",
  "TATA",
  "Nissan",
  "Toyota",
  "Renault",
  "FIAT",
  "GM",
  "Opel",
  "Suzuki",
  "Mazda",
  "Peugeot",
  "Scania",
  "Daimler",
  "JACC"
};

typedef enum te_oem {
  VW,
  Seat,
  Skoda,
  Audi,
  BMW,
  TATA,
  Nissan,
  Toyota,
  Renault,
  FIAT,
  GM,
  Opel,
  Suzuki,
  Mazda,
  Peugeot,
  Scania,
  Daimler,
  JACC
} e_oem;
