
/************************************************************************
*FILE					: swuhmi_window.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Base Window Class.
*DESCRIPTION			: It provides the base for all project specific windows.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_WINDOW_H_
#define SWUHMI_WINDOW_H_

#include "../config/swuhmi_includes.h"
#include "../widgets/swuhmi_graphicsinterface.h"

#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "../main/swuhmi_component_inc.h"
#include "util/swu_msg.hpp"
#include "util/swu_memberList.hpp"
#include "util/swu_types.h"
#include "util/swu_asfUtil.hpp"
#include "util/swu_timer.h"
#include "util/swu_filesystem.h"

#define REMAINING_TIME_FOR_UPDATE_IN_MS		   1000			//1 M

using namespace swu;

namespace swuhmi {

struct Msg_UpdateStateUpdate;
struct Msg_UpdateProgressUpdate;
struct Msg_UpdateBgImageInfoUpdate;


struct Msg_RemainingTimeTimer: public swu::Msg< Msg_RemainingTimeTimer, FcSwUHMIRoot > {
	virtual tVoid vTrace() {};
};

class window : public swu::Member<FcSwUHMIRoot>
{
public:
	window();
	virtual ~window();

private:
	tU8					m_u8Opacity;

protected:
	tU32								m_u32ActualWndHeight;
	tU32								m_u32ActualWndWidth;


public:
	virtual tVoid vInit() = 0;
	virtual tVoid vDeInit() = 0;
	virtual void traceState() = 0;
	virtual tVoid InitalizeWnd() = 0;
	virtual tVoid DeInitalizeWnd() = 0;
	virtual tVoid OnRemainingTimeExpiry() = 0;

	virtual tVoid vProcess(Msg_RemainingTimeTimer *pMsg);

	tVoid GetScreenResolution();

	tVoid SetBackGroundImage(string strImagePath,float xPos=0.0,float yPos=0.0);

	tVoid StartRemainingTimeTimer();
	tVoid StopRemainingTimeTimer();
	tBool IsRemainingTimeTimerRunning();

	tVoid ShowProgressBar();
	tVoid ShowWindow();
	tVoid CloseWindow();

	tVoid SetOpacity(tU8 u8Opacity) { m_u8Opacity = u8Opacity; }
	tU8 GetOpacity() { return m_u8Opacity; }

	swu::SwUpdTimer< window, Msg_RemainingTimeTimer> m_RemainingTimeTimer;



};

}

#endif /* WINDOWS_H_ */
