
/************************************************************************
*FILE					: swuhmi_widget.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Base Widget class.
*DESCRIPTION			: All Common Funtionality is implemented in Widget.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_WIDGET_H_
#define SWUHMI_WIDGET_H_

#include "../config/swuhmi_includes.h"
#include "swuhmi_graphicsinterface.h"

class widget
{
public:
	widget();
	virtual ~widget();

protected:
	tU16 				m_u16Xpos;
	tU16 				m_u16Ypos;
	tU16 				m_u16Width;
	tU16 				m_u16Height;
	tBool 				m_bVisibilityStatus;
	tU32				m_u32FGColor;
	tU32				m_u32BGColor;
	tU32				m_u32BorderColor;

public:
	//Functions
	virtual tVoid SetXPos(tU16 xPos) { m_u16Xpos = xPos; }
	virtual tU16 GetXPos() { return m_u16Xpos; }

	virtual tVoid SetYPos(tU16  yPos) { m_u16Ypos = yPos; }
	virtual tU16 GetYPos() { return m_u16Ypos; }

	virtual tVoid SetWidth(tU16 width) { m_u16Width = width; }
	virtual tU16 GetWidth() { return m_u16Width; }

	virtual tVoid SetHeight(tU16 height) {m_u16Height = height; }
	virtual tU16 GetHeight() { return m_u16Height; }



	tVoid SetVisibility(tBool _bVisible) { m_bVisibilityStatus = _bVisible; }
	tBool GetVisibility() { return m_bVisibilityStatus; }

	tVoid SetFGColor(tU32 u32FGcolor) { m_u32FGColor = u32FGcolor; }
	tU8 GetFGColor() { return (static_cast<tU8> (m_u32FGColor) ); }

	tVoid SetBGcolor(tU32 u32BGcolor) { m_u32BGColor = u32BGcolor; }
	tU8 GetBGColor() { return (static_cast<tU8> (m_u32BGColor) ); }

	tVoid SetBorderColor(tU32 u32BorColor) { m_u32BorderColor = u32BorColor; }
	tU8 GetBorderColor() { return (static_cast<tU8> (m_u32BorderColor) ); }

};

#endif /* WIDGET_H_ */
