
/************************************************************************
*FILE					: swuhmi_label.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Label Class which derived from Widget Base class.
*DESCRIPTION			: Which Implements Text Drawing.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_LABEL_H_
#define SWUHMI_LABEL_H_

#include "swuhmi_widget.h"


class label : public widget
{
public:
	label();
	virtual ~label();

private:

	::std::string		m_strTextToDisplay;
	E_LABEL_ALIGNMENT	m_eLabelAlign;
	string				m_strPrevText;
	tBool				m_bTranslationStatus;
	tU16				m_u16FontHeight;

public:

	tVoid SetLabelAlignment(E_LABEL_ALIGNMENT eLabelAlign) { m_eLabelAlign = eLabelAlign; }
	E_LABEL_ALIGNMENT GetLabelAlignment() { return m_eLabelAlign; }


	tVoid SetFontHeight(tU16 _u16FontHeight) { m_u16FontHeight = _u16FontHeight; }

	::std::string GetCurrentText() { return m_strTextToDisplay; }

	tVoid SetPreviousText(string strText) { m_strPrevText = strText; }

	tVoid SetTranslationStatus(tBool bStatus) { m_bTranslationStatus = bStatus; }

	tVoid DrawText(string strText);
	tVoid UpdateText(string strText);

	tVoid InitializeLabel();
	tVoid DeInitializeLabel();





};

#endif /* LABEL_H_ */
