
/************************************************************************
*FILE					: swuhmi_graphicsinterface.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Graphics Interface to 3rd Party Rendering Library.
*DESCRIPTION			: All Static Functions, Only Interface to Graphics.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/

#ifndef SWUHMI_GRAPHICSINTERFACE_H_
#define SWUHMI_GRAPHICSINTERFACE_H_

#include "../config/swuhmi_includes.h"
#include "../adapters/swuhmi_cairoadapter.h"

class graphicsinterface
{
public:
	graphicsinterface();
	virtual ~graphicsinterface();

	//static tVoid InitializeGraphics();
	static tVoid SwitchSurface();
	static tVoid CreateSurface();

	static tVoid SetBackGndImage(string strPath,float xPos=0.0,float yPos=0.0);

	static tVoid ShowWindow();
	static tVoid CloseWindow();
	static tVoid TakeScreenShot(string strFileName);


	static tVoid CreateFont(string strFontFilePath,bool useSynthFlags=true, int synthFlags= CAIRO_FT_SYNTHESIZE_BOLD);
	static tVoid CreateChineseFont(string strFontFilePath,bool useSynthFlags=true, int synthFlags= CAIRO_FT_SYNTHESIZE_BOLD);

	static tU32 GetActualHeight();
	static tU32 GetActualWidth();

	static tVoid UpdateImage(ImageInfo stImageInfo);
	static tVoid UpdateText(LabelInfo stLabelInfo);
	static tVoid DrawText(LabelInfo stLabelInfo);
	static tVoid DrawTranslatedText(LabelInfo stLabelInfo);
	static tVoid ShowOutLine(LineInfo stLineInfo);
	static tVoid ShowProgressBar(ProgressBarInfo stProgressInfo);
	static tVoid ShowProgressBar1(ProgressBarInfo stProgressInfo);

	static tVoid SetDelimiter(string strDelimiter);
	
protected:
	static cairoadapter*   m_pCairoAdapterInst;
};

#endif /* WIDGETINTERFACE_H_ */
