
/************************************************************************
*FILE					: swuhmi_graphicsinterface.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Graphics Interface to 3rd Party Rendering Library.
*DESCRIPTION			: All Static Functions, Only Interface to Graphics.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/

#include "swuhmi_graphicsinterface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_GRAPHICSINTERFACE_"
#define ETG_I_FILE_PREFIX 				SWUHMI::graphicsinterface::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_graphicsinterface.cpp.trc.h"
#endif

cairoadapter* graphicsinterface::m_pCairoAdapterInst = NULL;

graphicsinterface::graphicsinterface()
{

}

graphicsinterface::~graphicsinterface()
{
	// TODO Auto-generated destructor stub
}

//tVoid graphicsinterface::InitializeGraphics()
//{
//	ETG_TRACE_USR2(("InitializeGraphics"));
//
//	m_pCairoAdapterInst = new cairoadapter();
//	if(m_pCairoAdapterInst != NULL)
//		m_pCairoAdapterInst->InitializeCairoAdapter();
//}

/************************************************************************
*FUNCTION			: SwitchSurface
*DESCRIPTION		: Changing the Buffer of DRM.
*PARAMETER			: None
*RETURNVALUE		: tVoid
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
11-05-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::SwitchSurface() {

	ETG_TRACE_USR2(("SwitchSurface"));

	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->ReSurface();

}

/************************************************************************
*FUNCTION			: CreateSurface
*DESCRIPTION		: Interface for Creating Surface
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::CreateSurface()
{
	ETG_TRACE_USR2(("CreateSurface"));

	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->CreateSurface();
}

/************************************************************************
*FUNCTION			: SetBackGndImage
*DESCRIPTION		: Interface for setting the Background Image.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::SetBackGndImage(string strPath,float xPos,float yPos)
{
	ETG_TRACE_USR2(("SetBackGndImage"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->SetBackGndImage(strPath,xPos,yPos);
}

/************************************************************************
*FUNCTION			: GetActualHeight
*DESCRIPTION		: Interface to get the Height of the Screen.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tU32 graphicsinterface::GetActualHeight()
{
	tU32 u32Height = 0;
	ETG_TRACE_USR2(("GetActualHeight"));

	if(m_pCairoAdapterInst != NULL)
		u32Height = m_pCairoAdapterInst->GetWindowHeight();

	return u32Height;
}

/************************************************************************
*FUNCTION			: GetActualWidth
*DESCRIPTION		: Interface to get the Width of the Screen.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tU32 graphicsinterface::GetActualWidth()
{
	tU32 u32Width = 0;
	ETG_TRACE_USR2(("GetActualWidth"));

	if(m_pCairoAdapterInst != NULL)
		u32Width = m_pCairoAdapterInst->GetWindowWidth();

	return u32Width;
}

/************************************************************************
*FUNCTION			: ShowWindow
*DESCRIPTION		: Interface to Draw Entire Window
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::ShowWindow()
{
	ETG_TRACE_USR2(("FlipThePage"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->FlipThePage();
}

/************************************************************************
*FUNCTION			: ShowOutLine
*DESCRIPTION		: Interface to Draw Outline
*PARAMETER			: struct (I)
*PARAMETER				Line Infomation
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::ShowOutLine(LineInfo stLineInfo)
{
	ETG_TRACE_USR2(("ShowOutLine"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->DrawOutLine(stLineInfo);
}

/************************************************************************
*FUNCTION			: ShowProgressBar
*DESCRIPTION		: Interface to Draw Progress Bar
*PARAMETER			: struct (I)
*PARAMETER				Progress Bar Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::ShowProgressBar(ProgressBarInfo stProgressInfo)
{
	ETG_TRACE_USR2(("ShowProgressBar"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->DrawProgressBar(stProgressInfo);
}

/************************************************************************
*FUNCTION			: ShowProgressBar
*DESCRIPTION		: Interface to Draw Progress Bar 1
*PARAMETER			: strut (I)
*PARAMETER				Progress Bar Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::ShowProgressBar1(ProgressBarInfo stProgressInfo)
{
	ETG_TRACE_USR2(("ShowProgressBar1"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->DrawProgressBar1(stProgressInfo);
}

/************************************************************************
*FUNCTION			: CreateFont
*DESCRIPTION		: Interface to Create Font
*PARAMETER			: string (I)
*PARAMETER				File Name with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/
tVoid graphicsinterface::CreateFont(string strFontFilePath,bool useSynthFlags,int synthFlags)
{
	ETG_TRACE_USR2(("CreateFont"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->CreateFont(strFontFilePath,useSynthFlags,synthFlags);
}

/************************************************************************
*FUNCTION			: CreateChineseFont
*DESCRIPTION		: Interface to Create Chinese Font
*PARAMETER			: string (I)
*PARAMETER				File Name with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::CreateChineseFont(string strFontFilePath,bool useSynthFlags,int synthFlags)
{
	ETG_TRACE_USR2(("CreateChineseFont"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->CreateChineseFont(strFontFilePath,useSynthFlags,synthFlags);
}

/************************************************************************
*FUNCTION			: CreateChineseFont
*DESCRIPTION		: Interface to Draw Text
*PARAMETER			: struct (I)
*PARAMETER				Label Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::DrawText(LabelInfo stLabelInfo)
{
	ETG_TRACE_USR2(("DrawText"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->DrawText(stLabelInfo);
}

/************************************************************************
*FUNCTION			: DrawTranslatedText
*DESCRIPTION		: Interface to Draw Translated Text
*PARAMETER			: struct (I)
*PARAMETER				Label Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::DrawTranslatedText(LabelInfo stLabelInfo)
{
	ETG_TRACE_USR2(("DrawTranslatedText"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->DrawTranslatedText(stLabelInfo);
}

/************************************************************************
*FUNCTION			: UpdateText
*DESCRIPTION		: Interface to Update  Text
*PARAMETER			: struct (I)
*PARAMETER				Label Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::UpdateText(LabelInfo stLabelInfo)
{
	ETG_TRACE_USR2(("UpdateText"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->UpdateText(stLabelInfo);
}
/************************************************************************
*FUNCTION			: UpdateImage
*DESCRIPTION		: Interface to Update  Image
*PARAMETER			: struct (I)
*PARAMETER				Image Information
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::UpdateImage(ImageInfo stImageInfo)
{
	ETG_TRACE_USR2(("UpdateImage"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->UpdateImage(stImageInfo);
}

/************************************************************************
*FUNCTION			: TakeScreenShot
*DESCRIPTION		: To take Screen Shot
*PARAMETER			: string (I)
*PARAMETER				FileName with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::TakeScreenShot(string strFileName)
{
	ETG_TRACE_USR2(("TakeScreenShot"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->TakeScreenShot(strFileName);
}

/************************************************************************
*FUNCTION			: SetDelimiter
*DESCRIPTION		: To set the delimiter to split the text to be displayed
*PARAMETER			: string (I)
*PARAMETER				Delimiter
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
13-07-2016	| 0.1		| AGL5KOR			| Initial
************************************************************************/
tVoid graphicsinterface::SetDelimiter(string strDelimiter)
{
	ETG_TRACE_USR2(("SetDelimiter"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->SetDelimiter(strDelimiter);
}

/************************************************************************
*FUNCTION			: CloseWindow
*DESCRIPTION		: Interface to Close Window
*PARAMETER			: string (I)
*PARAMETER				FileName with Path
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
tVoid graphicsinterface::CloseWindow()
{
	ETG_TRACE_USR2(("CloseWindow"));
	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->ClearSurface();
}



