/************************************************************************
*FILE					: swuhmi_systemsettings.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: It configure the maintain the settings of HMI
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_SYSTEMSETTINGS_H_
#define SWUHMI_SYSTEMSETTINGS_H_

#include "config/swuhmi_includes.h"
#include "util/swu_singleton.hpp"
#include "tinyxml/tinyxml.h"
#include "util/swu_filesystem.h"
#include "util/swu_util.hpp"

namespace swuhmi
{

static const std::string _persistentBase = SWUHMI_SWUPDCORE_PERSISTENT_ROOT;
static const std::string _DefaultBase    = SWUHMI_INITRAMFS_ROOT;
static const std::string _settingFileLoc = _persistentBase + "hmisettings.xml";



class swuhmi_systemsettings
{
public:
	swuhmi_systemsettings();
	virtual ~swuhmi_systemsettings();

	virtual tVoid DoSystemSettings() = 0;

protected:
	TiXmlDocument		m_hmiXmlDoc;
	TiXmlElement* 		m_phmiSettingsroot;

public:
	std::string _transLanName;
	std::string _translationLanPath;
	std::string _fontfilepath;
	std::string _oemtype;
	std::string _displayType;
	std::string _backgndImageLoc;
	std::string _pbarImageLoc;
	E_SOURCE_TYPE _eSourceType;

private:
	swuhmi_systemsettings ( const swuhmi_systemsettings & );  //Coverity fix for 48167
	swuhmi_systemsettings & operator = ( const swuhmi_systemsettings & ); //Coverity fix for 47842
};

}

#endif /* SWUHMI_SYSTEMSETTINGS_H_ */
