/************************************************************************
*FILE					: swuhmi_configurator.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: It is a base configurator of SWUHMI.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/

#ifndef SWUHMI_CONFIGURATOR_H_
#define SWUHMI_CONFIGURATOR_H_

#include "../config/swuhmi_includes.h"
#include "swuhmi_component_inc.h"
#include "../widgets/swuhmi_graphicsinterface.h"

#include "util/swu_memberList.hpp"



using namespace swu;

namespace swuhmi {

class swuhmi_configurator: public swu::Member<FcSwUHMIRoot>
{
public:
	swuhmi_configurator();
	virtual ~swuhmi_configurator();

	virtual tVoid vInit()  = 0;
	virtual tVoid vDeInit()  = 0;
	virtual void traceState() = 0;

	virtual tVoid Initializeconfigurator() = 0;
	// must be set in the project specific configurator
	virtual tVoid SetDelimiter(string strDelimiter) = 0;
	virtual tVoid SetUpdateState(E_HMI_STATE _eState) { m_eUpdateState = _eState; }
	virtual E_HMI_STATE GetUpdateState() { return m_eUpdateState; }
	virtual tVoid SetUpdateResult(bool success) { m_updateResultOk = success; }
   virtual bool GetUpdateResult() {return m_updateResultOk;};
	virtual tVoid CreateFonts(string strFontName,bool useSynthFlags=true, int synthFlags= CAIRO_FT_SYNTHESIZE_BOLD);

	string GetMediaSWVersion() { return m_strMediaSWVersion; }

private:
	tBool						m_bIsFontInit;
	E_HMI_STATE					m_eUpdateState;
   bool m_updateResultOk;

protected:
	//string						m_strRenderingFontFile;
	string						m_strMediaSWVersion;







};

extern swuhmi_configurator *poGetProjectSpecific();

}

#endif
