/************************************************************************
*FILE					: swuhmi_configurator.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: It is a base configurator of SWUHMI.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/

#include "swuhmi_configurator.h"
#include "util/swu_filesystem.h"
#include "../widgets/swuhmi_graphicsinterface.h"
#include "swuhmi_systemsettings.h"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "SWUHMI_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_SWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_configurator.cpp.trc.h"
#endif


namespace swuhmi {

/************************************************************************
*FUNCTION			: swuhmi_configurator
*DESCRIPTION		: Constructor of swuhmi_configurator
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
swuhmi_configurator::swuhmi_configurator()
{
	// TODO Auto-generated constructor stub
	m_strMediaSWVersion.clear();

	m_eUpdateState = E_HMI_INVALID_STATE;
	m_bIsFontInit = false;
        m_updateResultOk = false;

}

/************************************************************************
*FUNCTION			: swuhmi_configurator
*DESCRIPTION		: Destructor of swuhmi_configurator
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/
swuhmi_configurator::~swuhmi_configurator()
{
	// TODO Auto-generated destructor stub
}

/************************************************************************
*FUNCTION			: CreateFonts
*DESCRIPTION		: To Create the Fonts
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
28-02-2016	| 0.2		| SCK7COB			| CMG3G-12559 - Font faces option in cario adapter 
************************************************************************/
tVoid swuhmi_configurator::CreateFonts(string strFontName,bool useSynthFlags, int synthFlags)
{
	ETG_TRACE_USR2(("CreateFonts"));
	if(!m_bIsFontInit)
	{
		ETG_TRACE_USR4(("FontFileName:%s", strFontName.c_str()));
		graphicsinterface::CreateFont(strFontName,useSynthFlags,synthFlags);
		ETG_TRACE_USR2(("Fonts Created Successfully"));
		m_bIsFontInit = true;
	}
}

}



