#include "config/swuhmi_config.hpp"

#define ETG_I_FILE_PREFIX swuhmi::Config::instance()->

using namespace std;

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "SWUHMI_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_SWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_config.cpp.trc.h"
#endif


namespace swuhmi {

Config::Config() :

   cfg_FontPath(this, "FontPath", ""),
   cfg_FontHeight(this, "FontHeight", (tU32) 0),
   cfg_FontAligment(this, "FontAligment",(tU32)  0),
   
   cfg_HeaderTextXPos(this, "HeaderTextXPos",(tU32) 0),
   cfg_HeaderTextYPos(this, "HeaderTextYPos",(tU32) 0),
   cfg_HeaderLargeFontHeight(this, "HeaderLargeFontHeight",(tU32) 0),
   cfg_HeaderTextWhiteColor(this, "HeaderTextWhiteColor",(tU32) 0),
   
   cfg_BackGndImageXPos(this, "BackGndImageXPos", (tU32) 0) ,
   cfg_BackGndImageYPos(this, "BackGndImageYPos", (tU32) 0) ,  
   
   cfg_BorderXPos(this, "BorderXPos", (tU32)0) ,
   cfg_BorderYPos(this, "BorderYPos", (tU32)0) ,
   cfg_BorderWidth(this, "BorderWidth", (tU32)0) ,
   cfg_BorderWhiteColor(this, "BorderWhiteColor", (tU32)0) ,
   
   cfg_InfoLabelXPos(this, "InfoLabelXPos", (tU32)0) ,
   cfg_InfoLabelYPosFromBottom(this, "InfoLabelYPosFromBottom", (tU32)0) ,
   cfg_DeviceIdLabelYPosFromBottom(this, "DeviceIdLabelYPosFromBottom", (tU32)0) ,
   cfg_StatusMediumFontHeight(this, "StatusMediumFontHeight", (tU32)0) ,
   cfg_StatusWhiteColor(this, "StatusWhiteColor", (tU32)0) ,
   
   cfg_RemaningTimeTextFromRight(this, "RemaningTimeTextFromRight", (tU32)0) ,
   cfg_RemaningTimeTextFromBottom(this, "RemaningTimeTextFromBottom", (tU32)0) ,
   cfg_RemaingTimeTextMediumFontHeight(this, "RemaingTimeTextMediumFontHeight", (tU32)0) ,
   cfg_RemaingTimeTextWhiteColor(this, "RemaingTimeTextWhiteColor", (tU32)0) ,
   
   cfg_RemaningTimeFromRight(this, "RemaningTimeFromRight", (tU32)0) ,
   cfg_RemaningTimeFromBottom(this, "RemaningTimeFromBottom", (tU32)0) ,
   cfg_RemaingTimeMediumFontHeight(this, "RemaingTimeMediumFontHeight", (tU32)0) ,
   cfg_RemaingTimeWhiteColor(this, "RemaingTimeWhiteColor", (tU32)0) ,
   
   cfg_InfoTextXPosFromLeft(this, "InfoTextXPosFromLeft", (tU32)0) ,
   cfg_InfoTextYPosFromBottom(this, "InfoTextYPosFromBottom", (tU32)0) ,
   cfg_InfoLabelMediumFontHeight(this, "InfoLabelMediumFontHeight", (tU32)0) ,
   cfg_InfoLabelWhiteColor(this, "InfoLabelWhiteColor", (tU32)0) ,
   
   cfg_ProgressbarXPosFromLeft(this, "ProgressbarXPosFromLeft", (tU32) 0) ,
   cfg_ProgressbarYPosFromBottom(this, "ProgressbarYPosFromBottom", (tU32) 0) ,
   cfg_ProgressbarWidth(this, "ProgressbarWidth", (tU32) 0) ,
   cfg_ProgressbarHeight(this, "ProgressbarHeight", (tU32) 0),

   cfg_DefaultBasePath(this, "DefaultBasePath", ""),
   cfg_BackGndImagePath(this, "BackGndImagePath", ""),
   cfg_ProgressbarBackGndImage(this, "ProgressbarBackGndImage", ""),
   cfg_ProgressbarForeGndImage(this, "ProgressbarForeGndImage", ""),
   cfg_ProgressbarMeasurementImage(this, "ProgressbarMeasurementImage", ""),
   cfg_ProgressbarProgressPointerImage(this, "ProgressbarProgressPointerImage", ""),

   cfg_lightGrayColor(this, "lightGrayColor", (tU32)0xA79BA0)

{
   ETG_I_REGISTER_FILE();
}

Config::~Config(){
   ETG_I_UNREGISTER_FILE();
}






void Config::traceState() {
   printf("Config::traceState START\n");
   swu::ConfigBase::traceState();
   printf("Config::traceState END\n");

}

ETG_I_CMD_DEFINE((setCfgStr, "setCfgStr %50s %50s", ETG_I_STRING, ETG_I_STRING))
ETG_I_CMD_DEFINE((setCfgStr, "setCfgStr %50s", ETG_I_STRING, ETG_I_CONST_ARG("")))

ETG_I_CMD_DEFINE((setCfgU32, "setCfgU32 %50s %u", ETG_I_STRING, tU32))
ETG_I_CMD_DEFINE((setCfgVectorU8, "setCfgVectorU8 %50s %50s", ETG_I_STRING, ETG_I_STRING))

ETG_I_CMD_DEFINE((traceCfgStr,      "traceCfgStr %50s", ETG_I_STRING))
ETG_I_CMD_DEFINE((traceCfgU32,      "traceCfgU32 %50s", ETG_I_STRING))
ETG_I_CMD_DEFINE((traceCfgVectorU8, "traceCfgVectorU8 %50s", ETG_I_STRING))



}
