/************************************************************************
*FILE					: swuhmi_drmrender.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: DRM (Direct Render Manager).
*DESCRIPTION			: It Creates FrameBuffer from which widgets are drawn on it.
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_DRMRENDER_H_
#define SWUHMI_DRMRENDER_H_

#include <errno.h>
#include <fcntl.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <time.h>
#include <unistd.h>
#include <xf86drm.h>
#include <xf86drmMode.h>
#include <libudev.h>

#include "../config/swuhmi_includes.h"

struct modeset_buf {
	uint32_t width;
	uint32_t height;
	uint32_t stride;
	uint32_t size;
	uint32_t handle;
	uint8_t *map;
	uint32_t fb;
};

struct modeset_dev
{
	struct modeset_dev *next;

	unsigned int front_buf;
	struct modeset_buf bufs[2];

	drmModeModeInfo mode;
	uint32_t conn;
	uint32_t crtc;
	drmModeCrtc *saved_crtc;

	bool pflip_pending;
	bool cleanup;

	uint8_t r, g, b;
	bool r_up, g_up, b_up;
};

class drmrender
{
public:
	drmrender();
	virtual ~drmrender();

	int InitializeDRMRender();
	void DeInitializeDRMRender();
	void FlipThePage();
	void MarkDirtyRegion(tU16 u16XPos, tU16 u16YPos, tU16 u16Width, tU16 u16Height);
	void modeset_draw(void);
	void modeset_drawdoubleBuffer();

	static void modeset_page_flip_event(int fd, unsigned int frame,
					    unsigned int sec, unsigned int usec,
					    void *data);

	bool SetDrawEnv();
	tU8* GetFrameBuffer() 	{ return m_pDRMBuff->map; }
	tU32 GetWidth() 		{ return m_pDRMBuff->width; }
	tU32 GetHeight() 		{ return m_pDRMBuff->height; }
	tU32 GetStride()		{ return m_pDRMBuff->stride; }


private:
	int OpenDRM(int *out, const char *node);
	int PrepareDRM(int fd);
	int SetUpDRM(int fd, drmModeRes *res, drmModeConnector *conn,struct modeset_dev *dev);
	int FindCRTC(int fd, drmModeRes *res, drmModeConnector *conn,struct modeset_dev *dev);
	int CreateFrameBuff(int fd, struct modeset_buf *buf);
	void DestroyFrameBuff(int fd, struct modeset_buf *buf);
	uint8_t next_color(bool *up, uint8_t cur, unsigned int mod);
    void getDRMDevice(const char **drmDevice);
	drmrender ( const drmrender & );  //Coverity fix for 48157
	drmrender & operator = ( const drmrender & );  //Coverity fix for 47845

private:
	int 						m_FrameBufferfd;
	struct modeset_dev*			m_pDRMDevice;
	struct modeset_buf*			m_pDRMBuff;


};

#endif /* DRMRENDER_H_ */
