/*******************************************************************************
*
* FILE:          SWUpdateControl.h
*
* SW-COMPONENT:  SW Update Core Control
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _SWUPDATECONTROL_H_
#define _SWUPDATECONTROL_H_

#include <string>

// Return code for success
#define SWU_RETURN_SUCCESS				0
// Return code for failure
#define SWU_RETURN_FAILURE 				1
// Return code for failed reset counter comparison
#define SWU_RETURN_FAILURE_RSTCNTR_CMP 	2

#define FUSE_FILE_NAME          "/sys/kernel/debug/regmap/21bc000.ocotp/registers"
#define FUSE_FILE_LINE_LENGTH   15
#define FUSE_FILE_ID_LENGTH     4
#define FUSE_FILE_VALUE_OFFSET  6
#define FUSE_FILE_VALUE_LENGTH  8

#define SECURE_BOOT_MODE_ENABLED_BIT    0x02
#define SECURE_BOOT_REVOCATION_BITS     0x07
#define SECURE_BOOT_MODE_ENABLED_FUSE   0x0460
#define SECURE_BOOT_REVOCATION_FUSE     0x06f0

namespace ai_sw_update {
namespace common {



class SWUpdateControl
{
  static const int  EVENT_MASK_STOP=0x01000000;

  volatile bool         AckThreadRunning;
  volatile bool         EventNameValid;
  volatile const char   *EventName;

  static const int  PRAM_COUNTER_INDEX=1;
  static const int  PRAM_CHECK_INDEX  =2;

  public:
    typedef enum
    {
      V850_MODE_UNDEFINED,
      V850_MODE_BOOTLOADER,
      V850_MODE_APPLICATION,
    } V850_MODE;

    SWUpdateControl();
    ~SWUpdateControl();

  	bool activateRecoveryBootChain();
  	bool activateApplicationBootChain();
  	bool switchApplicationBootChainOne();
  	bool switchApplicationBootChainTwo();
    bool WriteNORMagic(size_t Addr, unsigned int Value);
  	const bool resetProcessorSystem();
  	const bool resetProcessorApp();
  	const bool resetProcessorSCC();
  	void dumpBootChainConfig();
    bool switchBacklight(bool state);
    bool acknowledgeWUPReasons();
    static void *acknowledgeWUPReasonsThread(void *Arg);
    bool indicateStartupFinished();
  	bool shutdownSystem();

  	V850_MODE getV850Mode();
    V850_MODE setV850Mode(V850_MODE Mode);
    void dumpV850Version(V850_MODE Mode);
    void checkV850Update();

    bool GetFcId(unsigned int *FcId);
    bool setFcId(std::string value);
    bool GetPjId(unsigned int *PjId);
    bool ReadKDSValue(unsigned int Key, unsigned int Off, unsigned int Len);
    bool WriteKDSValue(unsigned int Key, unsigned int Off, const char *Val);

    // the standard network interface use Port of type uint16_t so it is changed from int to uint16_t
    bool  IncSendValue(uint16_t Port, const std::string Host, const char *Val);
    bool  IncSendRecvValue(uint16_t Port, const std::string Host, const char *Val);

    int  getPRAMCounter(const char *Name);
    bool setPRAMCounter(const char *Name, unsigned char Count);
    int  getResetCounter(void);
    bool setResetCounter(unsigned char Count);
    int  getForceDnlMagic(void);
    bool setForceDnlMagic(unsigned char Count);

    unsigned char checkRstCtrAndSetRecvFlag(unsigned char u8ResetCntrVal);

    typedef std::map<unsigned int, unsigned int>  OTPDataMap;
    OTPDataMap  DataMap;

    bool    ParseHexChar(unsigned int *Value, const unsigned char Char);
    bool    AddToOTPMap(const unsigned char *Buff, const int BuffLen);
    bool    ReadOTPArea(void);
    bool    GetOTPData(unsigned int *Value, unsigned int FuseID);
    int     GetSecureBootModeEnabled(void);
    int     GetSRKRevocation(void);

    typedef struct PerfChannelInfo
    {
      char            *Name;
      double          StartTime;
      double          EndTime;
      double          DeltaTime;
      PerfChannelInfo *Parent, *Child, *Next;
    } PerfChannelInfo;

    static PerfChannelInfo *PerfChannelInfoBase, *PerfChannelInfoCurrent;

    void StartPerfChn(const char *Name);
    void StopPerfChn(const char *Name);
    void StopPerfChn(PerfChannelInfo *Info);
    void DumpPerf(PerfChannelInfo *Info, int Depth);
    void StartPerfServer(void);
    void SendPerfMsg(const char *Msg);
    void WriteToRegistry(std::string key, char* value);
   void dumpEmmcInfo();

    void getCpldVersion(unsigned char *msg);
    int cpldFlag;
};


} // namespace ai_sw_update {
} // namespace common {


#endif //_SWUPDATECONTROL_H_

