#ifndef FCSWUPD_TYPES_HPP
#define FCSWUPD_TYPES_HPP

#include "util/swu_types.h"
#include "util/swu_msg.hpp"
#include "util/swu_singleton.hpp"

namespace fcswupdate {

   // root-class for all message for FcSwUpdateComponent
   // this prevents, that all classes using message-dispatching have to include fcswupd_component.h
   class FcSwUpdRoot: public swu::Singleton<FcSwUpdRoot>
   {
      friend class swu::Singleton<FcSwUpdRoot>;
      public:
      static bool bSendLoobBackMsg(swu::MsgCompBase<FcSwUpdRoot> *msg);
      static const tU32 _id=10;
   };


   typedef enum  {
      tenSwUpdateState_Initial,
      tenSwUpdateState_Idle,
      tenSwUpdateState_Config,
      tenSwUpdateState_Running,
      tenSwUpdateState_PreResult
   } tenSwUpdateState;

   typedef enum {
      tenSwUpdateMode_Invalid = 0,
      tenSwUpdateMode_Hmi = 1,
      tenSwUpdateMode_Emergency = 3,
      tenSwUpdateMode_Engineering = 6,
      tenSwUpdateMode_Scomo = 7,
   } tenSwUpdateMode;

   typedef enum {
      _enReqMode_invalid = 0,
      _enReqMode_add = 1,
      _enReqMode_reserve = 2,
      _enReqMode_lock = 3,
      _enReqMode_forcelock = 4,
      _enReqMode_remove = 5,
      _enReqMode_clearAll = 6,
      _enReqMode_spmSWUMode = 7,
   } tenReqMode;

   typedef enum {
      enSystemMode_Normal,
      enSystemMode_Update,
      enSystemMode_CustomerUpdate,
      enSystemMode_Lock,
      enSystemMode_UnLock,
   } tenSystemMode;

   typedef enum {
      tenSourceType_USB,
      tenSourceType_SD,
      tenSourceType_OTA,
      tenSourceType_SCOMO,
      tenSourceType_SCOMO_INDEX,
      tenSourceType_other
   } tenSourceType;

  typedef enum {
    tenScomoPhase_Idle,
    tenScomoPhase_PreInstall,
    tenScomoPhase_Install,
    tenScomoPhase_PostInstall,
    tenScomoPhase_Installed 
  } tenScomoPhase;

  typedef enum {
    tenScomoPhaseHandlingMode_None,
    tenScomoPhaseHandlingMode_Default,
    tenScomoPhaseHandlingMode_1None2Neutral3All,
    tenScomoPhaseHandlingMode_Invalid
  } tenScomoPhaseHandlingMode;

   const char *sourceTypeToString(tenSourceType enSourceType);
tenSourceType enSourceTypeFromString(std::string const &sourceType);

   struct trSourceInfo {
      trSourceInfo() :
         enSourceType(tenSourceType_other),
         bMounted(false), 
         bHasCustomerUpdate(false),
         bHasSupportedFormatType(true),
         bDeleted(false),
         bNew(true),
         compId("FIRMWARE")
      {
      }
      tenSourceType enSourceType;
      std::string name;
      std::string path;
      std::string infoFile; // optional to select dedicated cms or xml file
      bool bMounted;
      bool bHasCustomerUpdate;
      bool bHasSupportedFormatType;
      bool bDeleted; // for cleanup: to check if source is still contained in property
      bool bNew;
      std::string owner;
      std::string compId;

      std::string getInfoFilePathAndName() const {
         return path + "/" + infoFile;
      }
   };

   template <class E, int I>
      struct EnumUtil {
         E _enVal;
         EnumUtil():
            _enVal((E)I) 
         {}
         operator E() {
            return _enVal;
         }
      };

   typedef enum {
      tenSwUpdateError_OK = 0,
      tenSwUpdateError_ECU_TO_BE_UPDATED = 1,
      tenSwUpdateError_ERROR_DOWNLOAD_MRG_BUSY = 2,
      tenSwUpdateError_ERROR_ERG_WRITE = 3,
      tenSwUpdateError_ERROR_ERG_READ = 4,
      tenSwUpdateError_ERROR_NOT_ENOUGH_MEMORY = 5,
      tenSwUpdateError_ERROR_SUMMARY_SCREENS = 6,
      tenSwUpdateError_ERROR_INVALID_SOURCE_SET = 7,
      tenSwUpdateError_ERROR_UNKNOWN = 8,
      tenSwUpdateError_ERROR_METAINFO_NOT_FOUND = 9,
      tenSwUpdateError_ERROR_METAINFO_READ = 10,
      tenSwUpdateError_ERROR_METAINFO_CHECKSUM = 11,
      tenSwUpdateError_ERROR_METAINFO_PARSE = 12,
      tenSwUpdateError_ERROR_METAINFO_SECTION_COMMON_NOT_FOUND = 13,
      tenSwUpdateError_ERROR_METAINFO_SECTION_SIGNATURE_NOT_FOUND = 14,
      tenSwUpdateError_ERROR_METAINFO_MANDATORY_TAG_NOT_FOUND = 15,
      tenSwUpdateError_ERROR_METAINFO_DUPLICATE_SECTION = 16,
      tenSwUpdateError_ERROR_METAINFO_SECTION_NOT_FOUND = 17,
      tenSwUpdateError_ERROR_METAINFO_UNEXPECTED_SUBSECTION = 18,
      tenSwUpdateError_ERROR_METAINFO_INVALID_SUBSECTION_PATH = 19,
      tenSwUpdateError_ERROR_METAINFO_REGION_CONFLICT = 20,
      tenSwUpdateError_ERROR_METAINFO_VARIANT_CONFLICT = 21,
      tenSwUpdateError_ERROR_METAINFO_INVALID_TRAIN_NAME = 22,
      tenSwUpdateError_ERROR_IMAGE_SIZE = 23,
      tenSwUpdateError_ERROR_IMAGE_CHECKSUM = 24,
      tenSwUpdateError_ERROR_IMAGE_INVALID_SECTORHEADER = 25,
      tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_VERSION = 26,
      tenSwUpdateError_ERROR_IMAGE_READ = 27,
      tenSwUpdateError_ERROR_IMAGE_FLASHING = 28,
      tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_SUPPORTED = 29,
      tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_READY = 30,
      tenSwUpdateError_ERROR_IMAGE_DEVICE_NOT_SELECTED = 31,
      tenSwUpdateError_ERROR_IMAGE_DEVICE_INCOMPATIBLE_DM_VERSION = 32,
      tenSwUpdateError_ERROR_SIGNATURE_CHECK_FAILED = 33,
      tenSwUpdateError_ERROR_CHANGE_BOOTMODE_NOT_POSSIBLE = 34,
      tenSwUpdateError_ERROR_NO_RELEASE_FOUND = 35,
      tenSwUpdateError_ERROR_MEDIA_UNAVAILABLE = 36,
      tenSwUpdateError_ERROR_MEDIUM_REMOVED = 37,
      tenSwUpdateError_ERROR_OTP_READ_FAILED = 38,
      tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_DOWNGRADE = 39,
      tenSwUpdateError_ERROR_IMAGE_INCOMPATIBLE_SAME_VERSION = 40,
      tenSwUpdateError_ERROR_IMAGE_SECURE_BOOT_VERIFICATION_FAILED = 41,
      tenSwUpdateError_ERROR_V850_INCOMPATIBLE_VERSION = 42,
      tenSwUpdateError_ERROR_INCOMPATIBLE_USB_FORMAT = 43,

      } tenSwUpdateError;

   const char *enSwUpdateErrorTypeToString(tenSwUpdateError enErrorType);

   typedef enum  {
      tenPrjState_Idle,
      tenPrjState_NotReady,
      tenPrjState_SelectSource,
      tenPrjState_SelectRelease,
      tenPrjState_Config,
      tenPrjState_Running,
      tenPrjState_Error,
      tenPrjState_Skipping,
      tenPrjState_Aborting,
      tenPrjState_Result,
      tenPrjState_Reboot,
      tenPrjState_WaitAllowRecoveryMode,
      tenPrjState_MediumRemoved,
      tenPrjState_PreResult,
      tenPrjState_Ready
   } tenPrjState;

   // --------------------------  Translation of Types from fcotasrv/FcOtaSrv.h
   enum tenOtaState {
      tenOtaState__Disabled,
      tenOtaState__Idle,
      tenOtaState__PackageAvail,
      tenOtaState__WaitDownloadConsent,
      tenOtaState__Downloading,
      tenOtaState__Paused,
      tenOtaState__Resuming,
      tenOtaState__Downloaded,
      tenOtaState__WaitUpdateConsent,
      tenOtaState__ReadyToInstall,
      tenOtaState__Installing,
      tenOtaState__Installed,
      tenOtaState__Error
   };

         
    const tU8 CampaignPhase__Idle = 0;
    const tU8 CampaignPhase__Running = 5;
    const tU8 CampaignPhase__End = 6;
   
   
   enum tenUpdaterState {
      tenUpdaterState__Idle,
      tenUpdaterState__Installing,
      tenUpdaterState__UpdateCanceled,
      tenUpdaterState__UpdateFailed,
      tenUpdaterState__UpdateSuccess
   };

   struct trDate {
      trDate(
            const tU8& day_,
            const tU8& month_,
            const tU8& year_) :
         day(day_),
         month(month_),
         year(year_)
      {}
      
      tU8 day;
      tU8 month;
      tU8 year;
   };

   struct trOtaState {
      trOtaState(
            const tenOtaState& enState_,
            const tU32&        packageId_,
            const bool&        bDeclineAllowed_) :
         enState(enState_),
         packageId(packageId_),
         bDeclineAllowed(bDeclineAllowed_)
      {}

      tenOtaState enState;
      tU32        packageId;
      bool        bDeclineAllowed;
   };

   struct trOtaPackageInfo {
      trOtaPackageInfo(
            const tU32&          packageId_,
            const ::std::string& dataPath_,
            const ::std::string& name_,
            const ::std::string& version_,
            const trDate&        date_,
            const tU32&          size_,
            const tU32&          estimatedInstallTime_) :
         packageId(packageId_),
         dataPath(dataPath_),
         name(name_),
         version(version_),
         date(date_),
         size(size_),
         estimatedInstallTime(estimatedInstallTime_)
      {}

      tU32          packageId;
      ::std::string dataPath;
      ::std::string name;
      ::std::string version;
      trDate        date;
      tU32          size;
      tU32          estimatedInstallTime;
   };

   struct trActivePackage {
      trActivePackage(
            const bool&             valid_,
            const trOtaPackageInfo& info_) :
         valid(valid_),
         info(info_)
      {}

      bool             valid;
      trOtaPackageInfo info;
   };
   // ------------------------- / Translation of Types from fcotasrv/FcOtaSrv.h

}

#endif
