#ifndef FCSWUPD_GLOBAL_LOG_H
#define FCSWUPD_GLOBAL_LOG_H
// print given output to all output-media 

#include "util/fcswupd_types.hpp"

namespace fcswupdate {

class GlobalLog {
public:
   static void marker();
   static void print(std::string text, tU8 options=0);
   static void logSwuErrorOnce(tenSwUpdateError errorCode);

   static void startLoggingFile();
   static void stopLoggingFile();
   static void exportLoggingFile(std::string mediaPath);

   static void logResourcesInfo(std::string text);

   static const tU8 logErrmem=1;
   static const tU8 logMarker=2;
   static const tU8 logstdOut=4;

private:
   static void printInternal(std::string const &text);
};

}

#endif
