
#ifndef FCSWUPD_XMLFILTERIF_H_
#define FCSWUPD_XMLFILTERIF_H_

#include <errno.h>
#include <dirent.h>
#include <iostream>
#include <fstream>
#include <fcntl.h>
#include <iterator>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <unistd.h>
#include <sstream>
#include <iomanip>
#include <fstream>
#include <algorithm>
#include <set>

#include "util/swu_types.h"
#include "main/fcswupd_releaseFilterIf.h"

using namespace std;

namespace fcswupdate {

class XmlReader {

public:
   XmlReader();
   bool load(std::string strFileName);
   void close();
   void filterByAttributes(std::string strAttrbName, std::string strValue);
   
private:   
   bool isOpen();
   void getAttributes(std::string& strOpenTag, std::string& strAttName, std::string& strAttValue);
   
   std::ifstream   _inFile;
   bool            _isFileOpen;
};

class XMLFilterIf;

class XMLFilterChain {
public:
   ~XMLFilterChain();
   void add(XMLFilterIf *filter, bool first = false);
   void remove(std::string filterName);
   void activate(std::string filterName, bool doActivate);
   tenSwUpdateError apply(std::string pathToXml, ReleaseFilterContext &context);

private:
   std::map <std::string, bool> _activations;
   std::list < XMLFilterIf * > _filters;

};

class XMLFilterIf {
public:
   virtual ~XMLFilterIf() {};
   virtual std::string getName()=0;
   virtual tenSwUpdateError doFilter(std::string pathToXml, ReleaseFilterContext &context);
   virtual tenSwUpdateError filterElem(std::string pathToXml) { return tenSwUpdateError_OK; };

};


class XMLFilterMatch : public XMLFilterIf {
public:
   virtual std::string getName() {
      return "XMLFilterMatch";
   };

   XMLFilterMatch(std::string key, std::string val) :
      _key(key),
      _val(val)
   {
      _name="XMLFilterMatch_"+_key + "_"+_val;
   }

protected:
   virtual tenSwUpdateError filterElem(std::string pathToXml);

private:
   std::string _key;
   std::string _val;
   std::string _name;
};


}

#endif
