
#include "util/swu_filesystem.h"
#include "util/swu_util.hpp"
#include "util/swu_globallog.h"

#include "main/fcswupd_xmlFilterIf.h"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_xmlFilterIf.cpp.trc.h"
#endif

using namespace std;

namespace fcswupdate {

static const std::string _xmlFilterPath="/tmp/";
static const std::string _xmlFilterFile="xmlFilter.xml";

XmlReader::XmlReader() {
   _isFileOpen = false;
   
}

bool XmlReader::load(std::string strFileName) {
   if (!swu::exists(strFileName)) {
      return false;
   }
   else {
      _inFile.open(strFileName.c_str(), ios_base::in);
   }
   _isFileOpen = isOpen();
   if (!_isFileOpen) {
      return false;
   }

   return true;
}

void XmlReader::close() {
   _inFile.close(); 
}


bool XmlReader::isOpen() {
   if (!_inFile.is_open()) {
      return false;
   }
   return true;
}

void XmlReader::filterByAttributes(std::string strAttrbName, std::string strValue) {

   ETG_TRACE_USR4(("XmlReader::filterByAttributes: attrb:%50s value:%50s", strAttrbName.c_str(), strValue.c_str()));
   
   std::string strInLine;
   std::size_t firstLt = 0, firstGt = 0, lastLt = 0, lastGt = 0;
   std::string strOpenTag;
   std::string strAttributeName;
   std::string strAttributeValue;
   std::string strCloseTag, strRefCloseTag;
   bool startRemove = false;

   std::string outFilePath = _xmlFilterPath + _xmlFilterFile;
   std::ofstream  outFile(outFilePath.c_str());;
   
   while (std::getline(_inFile, strInLine, '\n')) {

      //printf("line:%s\n", strInLine.c_str());
      firstLt = strInLine.find_first_of("<");
      firstGt = strInLine.find_first_of(">");
      strOpenTag = strInLine.substr(firstLt + 1, firstGt - firstLt - 1);
      strCloseTag.clear();

      if (strInLine.find('/') != std::string::npos) {
         lastLt = strInLine.find_last_of("<");
         lastGt = strInLine.find_last_of(">");
         strCloseTag = strInLine.substr(lastLt + 1, lastGt - lastLt - 1);
      }

      if (strCloseTag.size() > 0 && (strCloseTag == strRefCloseTag)) {
         strRefCloseTag.clear();
         startRemove = false;
         continue;
      }

      if (startRemove) {
         //printf("remove tag \n");
         continue;
      }

      if (strOpenTag.size()) {
         strAttributeValue.clear();
         getAttributes(strOpenTag, strAttributeName, strAttributeValue);
         
         if (strAttributeName == strAttrbName && strAttributeValue.size() > 0) {
            //printf("attribute:%s \t value:%s \n", strAttrbName.c_str(), strAttributeValue.c_str());
            std::set<std::string> vals = swu::splitString(strAttributeValue, ',');
            bool res = vals.find(strValue) != vals.end();

            if (!res) {
               strRefCloseTag = "/" + strOpenTag;
               startRemove = true;
               //printf("remove tag \n");
            }
         }
         if (!startRemove) {
            std::string strToWrite = strInLine;
            strToWrite.append("\n");
            outFile.write(strToWrite.c_str(), strToWrite.length());
         }
         if (startRemove && !strCloseTag.empty() && strCloseTag == strRefCloseTag) {
            strRefCloseTag.clear();
            startRemove = false;
         }
      }
   }
   outFile.close();
   ETG_TRACE_USR4(("XmlReader::filterByAttributes: END"));
}


void XmlReader::getAttributes(std::string& strOpenTag, std::string& strAttName, std::string& strAttValue) {
   std::size_t posF = 0;
   std::size_t posL = 0;

   posF = strOpenTag.find_first_of(" ");
   posL = strOpenTag.find_first_of("=");   

   if(posF != std::string::npos && posL != std::string::npos) {
      strAttName = strOpenTag.substr(posF + 1, posL - posF - 1);
      strOpenTag.erase(posF, posL - posF + 1);

      posF = strOpenTag.find_first_of("\"");
      posL = posF;
      posF = strOpenTag.find("\"", posF + 1);
      strAttValue = strOpenTag.substr(posL + 1, posF - posL - 1);
      strOpenTag.erase(posL, posF - posL + 1);
   }
}


XMLFilterChain::~XMLFilterChain() {
   for (std::list < XMLFilterIf * >::iterator iter = _filters.begin();
        iter != _filters.end(); ++iter) {
      XMLFilterIf *filter = *iter;
      delete filter;
   }
   _filters.clear();
}

void XMLFilterChain::activate(std::string filterName, bool doActivate) {
   ETG_TRACE_USR2(("XMLFilterChain():activate(%u) filter:%s", doActivate, filterName.c_str()));
   _activations[filterName]=doActivate;
}


void XMLFilterChain::add(XMLFilterIf *filter, bool first) {
   ETG_TRACE_USR2(("XMLFilterChain():add() filter:%s", filter->getName().c_str())); 

   remove(filter->getName());
   if (first) {
      _filters.push_front(filter);
   } else {
      _filters.push_back(filter);
   }
   _activations[filter->getName()]=true;

}

void XMLFilterChain::remove(std::string filterName) {
   ETG_TRACE_USR2(("XMLFilterChain():remove() filter:%s START", filterName.c_str()));

   for (std::list < XMLFilterIf * >::iterator iter = _filters.begin();
        iter != _filters.end(); ++iter) {
      if ((*iter)->getName() == filterName) {
         ETG_TRACE_USR2(("XMLFilterChain():remove() filter:%s found!", filterName.c_str()));
         _activations[(*iter)->getName()]=true;
         _filters.erase(iter);   
         return;
      }
   }
}


tenSwUpdateError XMLFilterChain::apply(std::string pathToXml, ReleaseFilterContext &context) {
   
   tenSwUpdateError res=tenSwUpdateError_OK; 
   for (std::list < XMLFilterIf * >::iterator iter = _filters.begin();
        iter != _filters.end(); ++iter) {
      XMLFilterIf *filter = *iter;
      ETG_TRACE_USR2(("XMLFilterChain():apply() filter:%s START", filter->getName().c_str()));
      if (!_activations[filter->getName()]) {
         ETG_TRACE_USR2(("XMLFilterChain():apply() skip deactivated filter"));
         continue;
      }

      
      res = filter->doFilter(pathToXml, context);
      if (res != tenSwUpdateError_OK) {
         ETG_TRACE_USR1(("XMLFilterChain():apply() filter(%s) failed", 
                         filter->getName().c_str()));
         swu::LOG_FAILURE("XMLFilterChain():apply() filter(%s) failed with error: (%u)", filter->getName().c_str(), res);
         return res;
      }
   }
   return tenSwUpdateError_OK;

}

tenSwUpdateError XMLFilterIf::doFilter(std::string pathToXml, ReleaseFilterContext &context) {

   ETG_TRACE_USR2(("XMLFilterIf::doFilter:START"));
   tenSwUpdateError enError =tenSwUpdateError_ERROR_UNKNOWN ;
   
   SWU_ASSERT_RETURN_VAL( pathToXml.length(), enError);
   enError=filterElem(pathToXml);

   if(enError == tenSwUpdateError_OK) {
      context.sourceInfo.path = _xmlFilterPath;
      context.sourceInfo.infoFile = _xmlFilterFile;
   }

   ETG_TRACE_USR2(("XMLFilterIf::doFilter:END"));
   return enError;
}

tenSwUpdateError XMLFilterMatch::filterElem(std::string pathToXml) {

   ETG_TRACE_USR1(("XMLFilterMatch::filterElem path:%s", pathToXml.c_str()));

   if(!swu::exists(pathToXml)) {
      ETG_TRACE_USR3(("bosch.xml is not found"));
      return tenSwUpdateError_ERROR_METAINFO_NOT_FOUND;
   }

   std::string outFilePath = _xmlFilterPath + _xmlFilterFile;
   if(swu::exists(outFilePath)) {
      swu::removeFile(outFilePath);
   }

   XmlReader fileReader;
   if(fileReader.load(pathToXml)) {
      fileReader.filterByAttributes(_key, _val);
      fileReader.close();
   }   
   
   return tenSwUpdateError_OK;
}

}
