/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*
 * fcswupd_vehicleDataIf.cpp
 *
 *  Created on: Feb 4, 2016
 *      Author: zaa8hi
 */

#include "fcswupd_vehicleDataIf.h"
#include "util/swu_filesystem.h"
#include "util/swu_plugin.h"
#include "util/swu_globallog.h"

#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_hmisettings.h"

// make class methods available to ETG
#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdateVeDaIf::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_VEDAIF_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_vehicleDataIf.cpp.trc.h"
#endif

static tU32 _simDistTotal=0;

namespace fcswupdate {

SWU_REGISTER_PLUGIN(FcSwUpdRoot, FcSwUpdateVeDaIf, 1, fcswupdate_veda_plugin);

FcSwUpdateVeDaIf::FcSwUpdateVeDaIf()
{
   setInstance(this);
}

FcSwUpdateVeDaIf::~FcSwUpdateVeDaIf()
{
}

void FcSwUpdateVeDaIf::vInit()
{
   ETG_I_REGISTER_FILE();
   swu::Msg_ProxyAvailability< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy, FcSwUpdRoot >::vSubscribe(this);

   _vedaProxy.init("vehicleMainFiPort");
   _vedaProxy.getProxy();

   ETG_TRACE_USR1(("FcSwUpdateVeDaIf::vInit()"));
}

void FcSwUpdateVeDaIf::vDeInit() {
   ETG_TRACE_USR1(("DistTotalizerPrj::vDeInit()"));
}

void FcSwUpdateVeDaIf::traceState()
{
   ETG_TRACE_USR1(("State of Vehicle Data Proxy:"));
   ETG_TRACE_USR1(("  connected to port '%s'", _vedaProxy.getPortName().c_str() ));
   ETG_TRACE_USR1(("  status=%s", _vedaProxy.isAvail() ? "available" : "not available"));
}

void FcSwUpdateVeDaIf::vProcess(swu::Msg_ProxyAvailability< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy, FcSwUpdRoot > *pMsg)
{
   bool avail = pMsg->available;
   ETG_TRACE_USR1(("FcSwUpdateVeDaIf::vProcess: onAvailable called. isAvailable()=%u:%u", avail, _vedaProxy.isAvail()));
   swu::LOG_INTERFACE("Msg_ProxyAvailability: available:%u", avail);
}



void FcSwUpdateVeDaIf::onLanguageStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::LanguageStatus >& payload) {
   ETG_TRACE_USR1(("FcSwUpdateVeDaIf::onLanguageStatus()"));

   vehicle_main_fi_types::T_e8_Language_Code eLangCode;

   if(payload->hasLanguage()) {
      eLangCode = payload->getLanguage();
      std::string strText  = getLanguageName(eLangCode);
      ETG_TRACE_USR4(("Language:%s", strText.c_str()));

      if(Config::instance()->cfg_MultiLanguageSupportStatus.get() &&
         Config::instance()->cfg_EnterFullOperation.get())
         hmisettings::instance()->vUpdateLanguageName(strText);

   }
}

std::string FcSwUpdateVeDaIf::getLanguageName(vehicle_main_fi_types::T_e8_Language_Code eLangName) {
	ETG_TRACE_USR1(("getLanguageName"));

	std::string strLanguageName("");
	switch(eLangName)
	{
	case vehicle_main_fi_types::T_e8_Language_Code__Czech:
		strLanguageName = "Czech";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Danish:
		strLanguageName = "Danish";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Dutch:
		strLanguageName = "Dutch";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__English_UK:
		strLanguageName = "English_UK";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__English_US:
		strLanguageName = "English_US";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__French:
		strLanguageName = "French";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__French_Canadian:
		strLanguageName = "French_Canadian";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__German:
		strLanguageName = "German";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Greek:
		strLanguageName = "Greek";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Hungarian:
		strLanguageName = "Hungarian";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Italian:
		strLanguageName = "Italian";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Norwegian:
		strLanguageName = "Norwegian";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Polish:
		strLanguageName = "Polish";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Portuguese:
		strLanguageName = "Portuguese";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Russian:
		strLanguageName = "Russian";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Spanish:
		strLanguageName = "Spanish";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Spanish_Latin_American:
		strLanguageName = "Spanish_Latin_American";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Swedish:
		strLanguageName = "Swedish";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Turkish:
		strLanguageName = "Turkish";
		break;
	case vehicle_main_fi_types::T_e8_Language_Code__Unknown:
	case vehicle_main_fi_types::T_e8_Language_Code__Unused:
	case vehicle_main_fi_types::T_e8_Language_Code__UnSupported:
	default:
		strLanguageName = "English_UK";
		break;
	}
	return strLanguageName;
}




}



