#include "util/fcswupd_trace.hpp"
#include "tinyxml/tinyxml.h"
#include "main/fcswupd_ttfisCmd.hpp"
#include "main/fcswupd_history.h"
// include for etg support lib
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#define ETG_I_FILE_PREFIX fcswupd_ttfisCmd::
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#include "trcGenProj/Header/fcswupd_ttfisCmd.cpp.trc.h"
#endif

namespace fcswupdate {

Msg_TtfisCmd::Msg_TtfisCmd(const tU8 *data_)
{
   memcpy(data, data_, data_[0]+1);
}

tVoid Msg_TtfisCmd::vTrace() {
   ETG_TRACE_USR4((" Msg_TtfisCmd::vTrace:data=%02x", 
                   ETG_LIST_LEN(data[0]+1),
                   ETG_LIST_PTR_T8(data)));
}
  

TtfiCmd::TtfiCmd():
   _fdTrace(OSAL_ERROR)
{}

TtfiCmd::~TtfiCmd() {
   vUnRegisterChannel();
}

tVoid TtfiCmd::vInit() {
   ETG_TRACE_USR1(("TtfiCmd vInit call vSubscribe START"));
   Msg_TtfisCmd::vSubscribe(this);
   //   ETG_I_REGISTER_CHN(0);
   vRegisterChannel();
    
   ETG_I_REGISTER_FILE();
}

void TtfiCmd::traceState() {
   ETG_TRACE_COMP(("  _fdTrace=%u (%s registered)", _fdTrace,
                  (OSAL_ERROR == _fdTrace) ? "NOT" : ""));
}


tVoid TtfiCmd::vRegisterChannel( )
{
   tS32                        s32Error;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;
   
   if(OSAL_ERROR == _fdTrace) {
      _fdTrace = OSAL_IOOpen( OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE );
   }
   SWU_ASSERT_RETURN(OSAL_ERROR != _fdTrace);
   ETG_TRACE_USR4(("fcswupd_TtfiCmd::vRegisterChannel() OSAL_IOOpen OK"));
   oTraceChannel.enTraceChannel = (TR_tenTraceChan)TR_TTFIS_FCSWUPDATE ;
   oTraceChannel.pCallback = (OSAL_tpfCallback)vChannelMgrCb;
   
   s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t)&oTraceChannel );
   SWU_ASSERT_RETURN(OSAL_OK == s32Error);
}


tVoid TtfiCmd::vUnRegisterChannel()
{
   tS32 s32Error;
   OSAL_trIOCtrlLaunchChannel oTraceChannel;
   
   if (OSAL_ERROR == _fdTrace) {
      return;
   }
   oTraceChannel.enTraceChannel = (TR_tenTraceChan)TR_TTFIS_FCSWUPDATE;
   oTraceChannel.pCallback      = (OSAL_tpfCallback)vChannelMgrCb;
   
   s32Error = OSAL_s32IOControl(_fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t)&oTraceChannel);
   SWU_ASSERT_RETURN(OSAL_OK == s32Error);
   (tVoid)OSAL_s32IOClose(_fdTrace);
   _fdTrace=OSAL_ERROR;
}

tVoid TtfiCmd::vProcess(Msg_TtfisCmd *pMsg) {
   ETG_TRACE_COMP(("TtfiCmd::vProcess(Msg_TtfisCmd) START pMsg=%p data=%02x START\n", pMsg,
                   ETG_LIST_LEN(pMsg->data[0]+1),
                   ETG_LIST_PTR_T8(pMsg->data)));

   ETG_I_bPROCESS(pMsg->data);
   ETG_TRACE_COMP(("TtfiCmd::vProcess(Msg_TtfisCmd) END"));

}

tVoid TtfiCmd::vChannelMgrCb(const tUChar* const puchData) {
   ETG_TRACE_USR4(("vChannelMgrCb: puchData=%02x", 
                   ETG_LIST_LEN(puchData[0]+1),
                   ETG_LIST_PTR_T8(puchData)));
   Msg_TtfisCmd *ttfisCmd=new Msg_TtfisCmd(puchData);
   SWU_ASSERT_RETURN(ttfisCmd);
   ETG_TRACE_USR1(("vChannelMgrCb START pMsg=%p", ttfisCmd));
   ttfisCmd->bNotifyLater();
   ETG_TRACE_USR1(("vChannelMgrCb END"));
   ttfisCmd = 0;
}


}
