#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "util/fcswupd_types.hpp"
#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_tftpIf.h"

#define ETG_I_FILE_PREFIX fcswupdate::TftpIf::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_TFTPIF_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_tftpIf.cpp.trc.h"
#endif 


namespace fcswupdate {

void TftpIf::vInit() {
   _durationMs = 0;
}

void TftpIf::start(tUInt durationMs) {
   ETG_TRACE_USR1(("TftpIf::start fetching"));
   _durationMs=durationMs;;
   _triggerTimer.start(this, _durationMs);
}

void TftpIf::stop() {
   ETG_TRACE_USR1(("TftpIf::stop fetching"));
   _triggerTimer.stop();
   _durationMs = 0;
}

void TftpIf::vProcess(Msg_TriggerTftp *pMsg) {
   ETG_TRACE_USR1(("TftpIf::Msg_TriggerTftp"));
   if(_durationMs != 0) {
      fetchTftp();
      _triggerTimer.start(this, _durationMs);
   }
}

bool TftpIf::fetchTftp() {

   ETG_TRACE_USR1(("TftpIf::fetchTftp - START"));
   static bool _bFirstTftp=false;
   std::string dstDir("/tmp/tftpRelease");
   ;
   if (!swu::makeDirectoryRecursive(dstDir, 0755)) {
      ETG_TRACE_ERR(("FcSwUpdCore::bFetchBoschXmlDocViaTftp: could not create directory: %s", dstDir.c_str()));
      return false;
   }
   // todo: use exec... instead of system
   std::string tftpServerIp;
   if (!Config::instance()->cfg_TftpServerIpAdr.get(tftpServerIp)) {
      ETG_TRACE_ERR(("FcSwUpdCore::bFetchBoschXmlDocViaTftp: missing tftp-ip-addr"));
      return false;
   }

   std::string tftpLocalPath;
   Config::instance()->cfg_TftpLocalPath.get(tftpLocalPath);
   std::string add=" 2>&1 > /dev/null";
   if (_bFirstTftp) {
      ETG_TRACE_USR1(("FcSwUpdCore::bFetchBoschXmlDocViaTftp: using: %s", tftpServerIp.c_str()));
      _bFirstTftp=false;
      add="";
   }
   PropDevMgr *property=PropDevMgr::instance();
   std::map< std::string, trSourceInfo > &mapSources=property->access()._mapSources;

   ETG_TRACE_USR1(("TftpIf::fetchTftp - 1"));

   for (std::map< std::string, trSourceInfo >::iterator iter=mapSources.begin();
        iter!=mapSources.end(); ++iter) {
      trSourceInfo &sourceInfo=iter->second;
      if (sourceInfo.owner==getName()) {
         mapSources.erase(iter++);
      }
   }

   ETG_TRACE_USR1(("TftpIf::fetchTftp - 2"));
   
   std::set<std::string> filesNameSet=swu::splitString(Config::instance()->cfg_ParserTftpFilesDeveloperMode.get());
   bool res=true;
   for (std::set<std::string>::iterator iter =filesNameSet.begin();
        (iter != filesNameSet.end()) && res;
        ++iter) {
      std::string fileName=*iter;
      std::string cmd="tftp -g -r " + fileName + " -l " + tftpLocalPath + "/" + fileName + " " + tftpServerIp + add + " 2>&1 >/dev/null";
      system(cmd.c_str());
      res=swu::exists(tftpLocalPath + "/" + fileName);
      ETG_TRACE_USR1(("FcSwUpdCore::bFetchBoschXmlDocViaTftp: END res=%u", res));
      if (res) {
         trSourceInfo sourceInfo;
         sourceInfo.path=tftpLocalPath;
         sourceInfo.infoFile=fileName;
         sourceInfo.enSourceType=tenSourceType_other;
         sourceInfo.owner=getName();
         mapSources[tftpLocalPath]=sourceInfo;
      }
   }
   property->iNotify(this);
   ETG_TRACE_USR1(("TftpIf::fetchTftp - END"));
   return res;
// todo: also fetch checksum an verify release.xml

    }
}
