#ifndef FCSWUPD_SYSTEM_MODES_H
#define FCSWUPD_SYSTEM_MODES_H

#include <set>
#include <list>
#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"
#include "main/fcswupd_spmIf.h"

namespace fcswupdate {


struct Msg_SystemModeReached: public swu::Msg<Msg_SystemModeReached, FcSwUpdRoot>  {
   Msg_SystemModeReached(tenSystemMode enSystemMode_):enSystemMode(enSystemMode_) {};
   virtual tVoid vTrace(){};
   tenSystemMode enSystemMode;
};

class SystemModeTargetIf {
public:
   typedef enum {
      enEnabled,
      enEnabling,
      enDisabled,
      enDisabling
   } tenState;
   virtual const char *getTargetName()=0;
   virtual void setTargetEnable(bool enable)=0;
   virtual tenState getTargetState()=0;
   
   virtual ~SystemModeTargetIf() {
   }
};

class Msg_SystemModeLbConfirmation;
class Msg_SpmModeReached;
class SystemModes: public swu::Member<FcSwUpdRoot>, public swu::Singleton<SystemModes> {
   // notify clients with Msg_SystemModeReached

   friend class swu::Singleton<SystemModes>;
public:



   virtual void traceState() {};
   
   
   virtual void vInit();

   // loopback message to ourself
   void vProcess(Msg_SystemModeLbConfirmation *pMsg);
   // notification from spmIf that spm has reached requested state
   void vProcess(Msg_SpmModeReached *pMsg);
   
   void onTargetStateReached(SystemModeTargetIf *target, SystemModeTargetIf::tenState enState);
   void registerTarget(SystemModeTargetIf *target) {
      _targets.insert(target);
   }
   void deregisterTarget(SystemModeTargetIf *target) {
      std::set<SystemModeTargetIf *>::iterator iter=_targets.find(target);
      if (iter != _targets.end()) {
         _targets.erase(iter);
      }
   }

   void requestMode(tenSystemMode enSystemMode, std::list<std::string> &devicesToStop);
   void requestMode(tenSystemMode enSystemMode);


   // shortcuts
   void requestModeForUpdate();
   void requestLockForUpdate();
   void releaseLockAfterUpdate();
   void leaveModeForUpdate();


protected:
   SystemModes();

private:
   bool update();
   bool updateSpm();
   bool updateTargets();

   void sendLbConfirmation();

   std::set<SystemModeTargetIf *> _targets;
   tenSystemMode _enRequestedSystemMode;
   tenSystemMode _enConfirmedSystemMode;
   tenSystemMode _enRequestedSpmMode;
   std::list<std::string> _devicesToStop;
};


}

#endif
