#include "util/fcswupd_types.hpp"
#include "main/fcswupd_main.h"
#include "main/fcswupd_systemModes.h"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_systemModes.cpp.trc.h"
#endif


namespace fcswupdate {


struct Msg_SystemModeLbConfirmation: public swu::Msg<Msg_SystemModeLbConfirmation, FcSwUpdRoot> {
   Msg_SystemModeLbConfirmation(tenSystemMode enSystemMode_):
      enSystemMode(enSystemMode_) 
   {}
   virtual tVoid vTrace() {
      ETG_TRACE_USR1((" Msg_SystemModeLbConfirmation:enSystemMode=%u",
                      ETG_CENUM(tenSystemMode, enSystemMode)));
   }
   tenSystemMode enSystemMode;
};


SystemModes::SystemModes():
   _enRequestedSystemMode(enSystemMode_Normal),
   _enConfirmedSystemMode(enSystemMode_Normal),
   _enRequestedSpmMode(enSystemMode_Normal)
{}


void SystemModes::vInit() {
   Msg_SystemModeLbConfirmation::vSubscribe(this);
   Msg_SpmModeReached::vSubscribe(this);
}


void SystemModes::sendLbConfirmation() {
   ETG_TRACE_USR1(("SystemModes::sendLbConfirmation"));
   Msg_SystemModeLbConfirmation *msg= new Msg_SystemModeLbConfirmation(_enConfirmedSystemMode);
   SWU_ASSERT_RETURN(msg);
   msg->bNotifyLater();
   msg = 0;
}

void SystemModes::vProcess(Msg_SystemModeLbConfirmation *pMsg) {
   ETG_TRACE_USR1(("SystemModes::vProcess(Msg_SystemModeLbConfirmation)"));
   (void)pMsg; 
   if (update()) {
      // stable now, notify clients
      Msg_SystemModeReached msg(_enConfirmedSystemMode);
      notify(msg);
   }
}


void SystemModes::vProcess(Msg_SpmModeReached *pMsg) {
   ETG_TRACE_USR1(("SystemModes::vProcess(Msg_SpmModeReached):%u",
                   ETG_CENUM(tenSystemMode, pMsg->enSystemMode)));
   update();
}


void SystemModes::onTargetStateReached(SystemModeTargetIf *target, SystemModeTargetIf::tenState enState) {
   ETG_TRACE_USR1(("SystemModes::onTargetStateReached:state=%d, name=%s",
                   ETG_CENUM(SystemModeTargetIf::tenState, enState),
                   target->getTargetName()));
   update();
   
}

bool SystemModes::update() {
   ETG_TRACE_USR1(("SystemModes::update() _enRequestedSystemMode=%u START",
                   ETG_CENUM(tenSystemMode, _enRequestedSystemMode)));
   bool bStable=false;
   if (_enRequestedSystemMode==enSystemMode_Normal) {
      bStable=updateTargets() && updateSpm();
   }
   else {
      bStable=updateSpm() && updateTargets();
      
   }

   if (bStable) {
      if (_enConfirmedSystemMode != _enRequestedSystemMode) {
         _enConfirmedSystemMode = _enRequestedSystemMode;
         sendLbConfirmation();
      }
   }
   ETG_TRACE_USR1(("SystemModes::update() _enRequestedSystemMode=%u bStable=%u END",
                   ETG_CENUM(tenSystemMode, _enRequestedSystemMode), bStable));
   return bStable;
}





void SystemModes::requestMode(tenSystemMode enSystemMode, std::list<std::string> &devicesToStop) {
   ETG_TRACE_USR1(("SystemModes::requestMode(%u) numdev=%u",
                   ETG_CENUM(tenSystemMode, enSystemMode), devicesToStop.size()));
   _enRequestedSystemMode=enSystemMode;
   _devicesToStop.clear();
   if (_enRequestedSystemMode == enSystemMode_CustomerUpdate) {
      _devicesToStop=devicesToStop;
   }
   if (_enRequestedSystemMode == _enConfirmedSystemMode) {
      sendLbConfirmation();
      return;
   }
   update();
}

void SystemModes::requestMode(tenSystemMode enSystemMode) {
   ETG_TRACE_USR1(("SystemModes::requestMode(%u)",
                   ETG_CENUM(tenSystemMode, enSystemMode)));
   std::list<std::string> devicesToStop;
   requestMode(enSystemMode, devicesToStop);
}

void SystemModes::requestLockForUpdate() {
   ETG_TRACE_USR2(("SystemModes::requestLockForUpdate"));
   requestMode(enSystemMode_Lock);
}

void SystemModes::releaseLockAfterUpdate() {
   ETG_TRACE_USR2(("SystemModes::releaseLockAfterUpdate"));
   requestMode(enSystemMode_UnLock);
}


void SystemModes::requestModeForUpdate() {
   ETG_TRACE_USR1(("SystemModes::requestModeForUpdate"));
   tenSwUpdateMode enUpdateMode=FcSwUpdCore::instance()->enGetUpdateMode();
   switch (enUpdateMode) {
      case tenSwUpdateMode_Hmi:
         requestMode(enSystemMode_Update);
         break;
#if 0
         // reference for implementation of resourceManager
      case tenSwUpdateMode_Customer:
      {
         std::list<std::string> devicesToStop;
         devicesToStop.push_back("UGZZC");
         requestMode(enSystemMode_CustomerUpdate, devicesToStop);
      }
#endif
      break;
      default:
         break;
   }
}
void SystemModes::leaveModeForUpdate() {
   ETG_TRACE_USR1(("SystemModes::leaveModeForUpdate"));

   requestMode(enSystemMode_Normal);
}

bool SystemModes::updateSpm() {
   ETG_TRACE_USR1(("SystemModes::updateSpm() _enRequestedSpmMode=%u _enRequestedSystemMode=%u START",
                   ETG_CENUM(tenSystemMode, _enRequestedSpmMode),
                   ETG_CENUM(tenSystemMode, _enRequestedSystemMode)));
   bool bRes=false;
   if (_enRequestedSpmMode != _enRequestedSystemMode) {
      _enRequestedSpmMode = _enRequestedSystemMode;
      SpmIf::instance()->requestSystemMode(_enRequestedSpmMode);
      bRes = false;
   }
   else {
      bRes = SpmIf::instance()->enGetSystemMode()==_enRequestedSystemMode;
   }
   ETG_TRACE_USR1(("SystemModes::updateSpm() bRes=%u END", bRes));
   return bRes;
}

   
bool SystemModes::updateTargets() {
   ETG_TRACE_USR1(("SystemModes::updateTargets() START"));

   bool bStable=true;
   std::set<SystemModeTargetIf *>::iterator iterTarget=_targets.begin();
   for (;iterTarget != _targets.end();++iterTarget) {
      SystemModeTargetIf *target =*iterTarget;
      SystemModeTargetIf::tenState enState=target->getTargetState();
      bool bEnable=true;
      std::list<std::string>::iterator iterDevice=find(_devicesToStop.begin(), _devicesToStop.end(), target->getTargetName());
      if (iterDevice != _devicesToStop.end()) {
         bEnable=false;
      }

      ETG_TRACE_USR1(("SystemModes::updateTargets() bEnable=%u enState=%u name=%s",
                      bEnable, ETG_CENUM(SystemModeTargetIf::tenState, enState), target->getTargetName()));

      if (bEnable && enState!=SystemModeTargetIf::enEnabled) {
         bStable=false;
         if (enState==SystemModeTargetIf::enDisabled) {
            ETG_TRACE_USR1(("SystemModes::updateTargets(): enable target %s", target->getTargetName()));
            target->setTargetEnable(true);
         }
      }
      if (!bEnable && enState!=SystemModeTargetIf::enDisabled) {
         bStable=false;
         if (enState==SystemModeTargetIf::enEnabled) {
            ETG_TRACE_USR1(("SystemModes::updateTargets(): disable target %s", target->getTargetName()));
            target->setTargetEnable(false);
         }
      }
   }   
   ETG_TRACE_USR1(("SystemModes::updateTargets() bStable=%u END", bStable));
   return bStable;
}

}
