/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

#ifndef FcSwUpdateSrvSystemSettings_h
#define FcSwUpdateSrvSystemSettings_h

#include "fcswupd_component_inc.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#ifndef SWU_STUB_SYTEM_SETTINGS
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"
#else
#include "fcswupd_systemSettingStub.h"
#endif

#include "util/swu_singleton.hpp"
#include "util/swu_msg.hpp"
#include "util/swu_asfUtil.hpp"
#include "main/fcswupd_main.h"
#include "util/fcswupd_types.hpp"

/*fcswupd_systemSettingStub.h should be maintained in project specific*/

namespace fcswupdate {

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

class FcSwUpdDefsetSrv:
      public SystemSettings1Stub,
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<FcSwUpdDefsetSrv>
{
public:
	FcSwUpdDefsetSrv();
	virtual tVoid vInit() {};
	virtual tVoid vDeInit() {};

	virtual ~FcSwUpdDefsetSrv();
	virtual void traceState();
	virtual const char *getName() { return "FcSwUpdDefsetSrv"; }

	virtual void onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
	virtual void onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
	virtual void onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

private:

   DECLARE_CLASS_LOGGER ();
};

}

#endif // FcSwUpdateSrvSystemSettings_h
