#include <fstream>
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "util/swu_asfUtil.hpp"
#include <util/swu_util.hpp>
#include <util/swu_filesystem.h>


#include "fcswupd_srvSystemSettings.h"


#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_srvSystemSettings.cpp.trc.h"
#endif 

namespace fcswupdate {

FcSwUpdDefsetSrv::FcSwUpdDefsetSrv():
   SystemSettings1Stub("fcSwUpdateSystemSettingPort") /* port name as specified in the component manifest */
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_COMP(("FcSwUpdDefsetSrv::FcSwUpdDefsetSrv() CTOR start"));


   ETG_TRACE_COMP(("FcSwUpdDefsetSrv::FcSwUpdDefsetSrv() CTOR end\n"));
}


FcSwUpdDefsetSrv::~FcSwUpdDefsetSrv()
{
   ETG_I_UNREGISTER_FILE();
}

void FcSwUpdDefsetSrv::onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request)
{
	ETG_TRACE_COMP(("FcSwUpdDefsetSrv::onPrepareSystemSettingRequest"));

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	uint32 cookie = request->getCookie();

	::std::vector< PrepareSystemSettingResponseExtendedDataStruct > extendedData;

	sendPrepareSystemSettingResponse(sysSetID, sysSetType, extendedData, 0, cookie);
}

void FcSwUpdDefsetSrv::onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request)
{
	ETG_TRACE_COMP(("FcSwUpdDefsetSrv::onExecuteSystemSettingRequest"));

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	uint32 cookie = request->getCookie();

	::std::vector< ExecuteSystemSettingResponseExtendedDataStruct > extendedData;

	Msg_ResetFactorySettings msg;
	if (!notify(msg))
		sendExecuteSystemSettingError("Notification error", "Msg_ResetFactorySettings failed");
	else
		sendExecuteSystemSettingResponse(sysSetID, sysSetType, extendedData, 0, cookie);
}

void FcSwUpdDefsetSrv::onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request)
{
	ETG_TRACE_COMP(("FcSwUpdDefsetSrv::onFinalizeSystemSettingRequest"));

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	uint32 cookie = request->getCookie();

	::std::vector< FinalizeSystemSettingResponseExtendedDataStruct > extendedData;

	sendFinalizeSystemSettingResponse(sysSetID, sysSetType, extendedData, 0, cookie);
}



void FcSwUpdDefsetSrv::traceState()
{
   ETG_TRACE_COMP(("FcSwUpdDefsetSrv::traceState"));
}


}
