#ifndef FCSWUPD_SPECIAL_RELEASE_H
#define FCSWUPD_SPECIAL_RELEASE_H

#include "main/fcswupd_component.h"
#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"


namespace fcswupdate {


struct Msg_NotifyCtrlResult;


class SpecialRelease: 
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<SpecialRelease>
 {
      
   friend class swu::Singleton<SpecialRelease>;
 private:
    SpecialRelease();

public:
   virtual ~SpecialRelease();
   virtual char const *getName() {
      return "SpecialRelease";
   }

   virtual void traceState();

   virtual void vInit();
   virtual void vDeInit();

    std::string const &get();
    // set the special dir, but not make it persistent
    bool set(std::string const &mnfPathAndName, bool doStore=false);
    // make the set dir persistent
    void store();
    // clear the persitent and the tmp-dir
    void clear();

    // when we get the result, the persitent dir has to be deleted
    tVoid vProcess(Msg_NotifyCtrlResult *pMsg);
   

private:
    // set and notify devMgr property
    bool send();
    bool _initialized;
    // the currently set directory.
    std::string _current;
};

}



#endif
