
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "main/fcswupd_component.h"
#include "main/fcswupd_resourcemanager.h"
#include "main/fcswupd_spmIf.h"
#include "main/fcswupd_srv.h"
#include "main/fcswupd_systemModes.h"
#include "ccaservice.h"

#define ETG_I_FILE_PREFIX fcswupdate::ResourceManager::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_RESMAN_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_resourcemanager.cpp.trc.h"
#endif

namespace fcswupdate {


void spmOwnerInfoStack::traceStack() {
   ETG_TRACE_USR4(("spmOwnerInfoStack - START"));
   std::vector<SPMResourceData>::iterator iter;
   for (iter = _elems.begin(); iter != _elems.end(); iter++) {
      ETG_TRACE_USR1(("state:%d", iter->state));
      ETG_TRACE_USR1(("ownerName:0x%x", iter->ownerName));
      ETG_TRACE_USR1(("lockName:%s", iter->lockName.c_str()));
   }
   ETG_TRACE_USR4(("spmOwnerInfoStack - END"));
}

bool spmOwnerInfoStack::searchElemByLock(std::string resName, SPMResourceData &data) {

   ETG_TRACE_USR4(("spmOwnerInfoStack::searchElemByLock lock:%s", resName.c_str()));
   for(iterator pos = _elems.begin(); pos != _elems.end(); pos++) {
      if(pos->lockName == resName) {
         data = *pos;
         return true;
      }

   }
   return false;
}

bool spmOwnerInfoStack::searchElemByOwner(tU16 resName, SPMResourceData &data) {

   ETG_TRACE_USR4(("spmOwnerInfoStack::searchElemByOwner app:0x%x", resName));
   for(iterator pos = _elems.begin(); pos != _elems.end(); pos++) {
      if(pos->ownerName == resName) {
         data = *pos;
         return true;
      }
   }
   return false;
}



void spmUserInfoStack::traceStack() {		

   ETG_TRACE_USR4(("spmUserInfoStack - START"));
   std::vector<SPMUserResData>::iterator iter;
   for (iter = _elems.begin(); iter != _elems.end(); iter++) {
      ETG_TRACE_USR1(("lockName:%s", iter->lockName.c_str()));
      std::vector<tU16> users = iter->userList;
      for(std::vector<tU16>::iterator pos = users.begin(); pos != users.end(); pos++) {
         ETG_TRACE_USR1(("user:0x%x", *pos));
      }
   }
   ETG_TRACE_USR4(("spmUserInfoStack - END"));
}

bool spmUserInfoStack::searchElemByLock(std::string resName, SPMUserResData &data) {
   ETG_TRACE_USR4(("spmUserInfoStack::searchElemByLock lock:%s", resName.c_str()));
   for(iterator pos = _elems.begin(); pos != _elems.end(); pos++) {
      if(pos->lockName == resName) {
         SPMUserResData temp = *pos;
         return true;
      }            
   }
   return false;
}

bool spmUserInfoStack::searchElemByUser(tU16 appId) {
   ETG_TRACE_USR4(("spmUserInfoStack::searchElem Id:%u", appId));
   for(iterator pos = _elems.begin(); pos != _elems.end(); pos++) {
      SPMUserResData tmp = *pos;
      std::vector<tU16>::iterator Iter = std::find_if(tmp.userList.begin(), tmp.userList.end(), find_User(appId));
      if(Iter != tmp.userList.end()) {
         return true;
      } 
   }
   return false;
}

                             
void reqInfoStack::traceStack() {		
   ETG_TRACE_USR4(("reqInfoStack - START"));
   for (iterator iter = _elems.begin(); iter != _elems.end(); iter++) {
      ETG_TRACE_USR1(("lockName:%80s mode:%u", iter->lockName.c_str(), iter->mode));
   }
   ETG_TRACE_USR4(("resDataStack - END"));
}

bool reqInfoStack::searchElem(std::string resName, ResourceData &data) {
   ETG_TRACE_USR4(("reqInfoStack::searchElem lock:%s", resName.c_str()));
   for(iterator pos = _elems.begin(); pos != _elems.end(); pos++) {
      if(pos->lockName == resName) {
         data = *pos;
         return true;
      }
   }
   return false;
}

void reqInfoStack::updateElem(ResourceData data) {
   ETG_TRACE_USR4(("reqInfoStack::updateElem lock:%s", data.lockName.c_str()));
   iterator pos = std::find_if(_elems.begin(), _elems.end(), find_LockName(data.lockName));
   if(pos != _elems.end()) {
      pos->mode = data.mode;
      pos->lockName = data.lockName;
      return;
   } else {
      push(data);
   }                               
}

void reqInfoStack::removeElem(std::string name) {
   ETG_TRACE_USR4(("reqInfoStack::remove lock:%s", name.c_str()));
   for(iterator Iter = _elems.begin(); Iter != _elems.end(); Iter++) {
      if(Iter->lockName == name) {
         _elems.erase(Iter);
         break;
      }
   }
}



tVoid Msg_ResourceManagerChanged::vTrace() {
   ETG_TRACE_USR1((" Msg_ResourceManagerChanged()"));
}

ResourceManager::ResourceManager() :
   _bIsReady(false) 
{
   ETG_TRACE_USR2(("ResourceManager(%p)::ResourceManager CTOR", this));

   _spmUsersRes.clear();
   _spmOwnersRes.clear();
   _reqUsersRes.clear();

   _hmiReqOwnerRes.clear();
   _hmiReqOwnerRes.fmt = "%s";

   _hmiRegRes.clear();
   _hmiPendingRes.clear();
   
   ETG_I_REGISTER_FILE();
}

ResourceManager::~ResourceManager(){
  ETG_I_UNREGISTER_FILE();
}


tVoid ResourceManager::vInit() {
   Msg_ResourceManagerChanged::vSubscribe(this);
   Msg_RegisterBgLocksRequest::vSubscribe(this);
   Msg_ApplyLockRequest::vSubscribe(this);
   Msg_SystemModeReached::vSubscribe(this);
}

tVoid ResourceManager::vDeInit() {
}

tVoid ResourceManager::traceState() {
   _spmUsersRes.traceStack();
   _spmOwnersRes.traceStack();
   _reqUsersRes.traceStack();
   _hmiReqOwnerRes.traceStack();
}

tVoid ResourceManager::vProcess(Msg_ResourceManagerChanged *pMsg) {
   ETG_TRACE_USR4(("Msg_ResourceManagerChanged"));
}

tVoid ResourceManager::vProcess(Msg_SystemModeReached *pMsg) {
   ETG_TRACE_USR4(("ResourceManager: Msg_SystemModeReached mode:%u", pMsg->enSystemMode));
   if(pMsg->enSystemMode != enSystemMode_Normal) {
      _bIsReady = true;
      applyConfig();
   }
}

tVoid ResourceManager::vProcess(Msg_ApplyLockRequest *pMsg) {
   ETG_TRACE_USR4(("Msg_ApplyLockRequest"));

   while(_hmiRegRes.getSize()) {
      std::string app = _hmiRegRes.top();
      _hmiRegRes.pop();
      configure(_enReqMode_lock, app);
   }

   _hmiRegRes.clear();
   _hmiPendingRes.clear();
}

tVoid ResourceManager::vProcess(Msg_RegisterBgLocksRequest *pMsg) {
   ETG_TRACE_USR4(("Msg_RegisterBgLocksRequest"));

   SWU_ASSERT_RETURN(pMsg);
   FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode regMode = pMsg->payload->getMode();
   std::vector<std::string> hmiRequestApp =  pMsg->payload->getLocks().getLocks();
    
   if(regMode == FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Overwrite) {
      _hmiReqOwnerRes.clear();
   }

  
   for(std::vector<std::string>::iterator hmiIter = hmiRequestApp.begin(); hmiIter != hmiRequestApp.end(); hmiIter++) {
      switch(regMode) {
         case FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Overwrite:                        
         case FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Add:
            _hmiReqOwnerRes.push(*hmiIter);
            break;
         case FCSWUPD_NS_FCSWUPD_T::tenLockRegisterMode__Remove: {
            std::string val = *hmiIter;
            if(_hmiReqOwnerRes.isPresent(val)) {
               _hmiReqOwnerRes.remove(*hmiIter);
            }
         }
            break;
         default:
            break;
      }
   }
   FcSwUpdSrv::instance()->sendRegisterLockResponse(true);
}

tBool ResourceManager::checkHmiWantToHandle(std::string resName) {

   ETG_TRACE_USR4(("ResourceManager::checkHmiWantToHandle app:%s", resName.c_str()));

   tBool bReturn = false;
   std::string searchVal = _hmiReqOwnerRes.searchElem(resName);
   if(searchVal.size() > 0) {
      bReturn = true;
   }
   ETG_TRACE_USR4(("ResourceManager::checkHmiWantToHandle status:%u", bReturn));
   return bReturn;

}

/*
lock has to pass through following state,
- add.
- reserve.
- lock.
otherwise SPM will not accept it.
 */
void ResourceManager::configure(tenReqMode mode, std::set<std::string> resList) {  
  
   ETG_TRACE_USR2(("ResourceManager::configure - START:mode:%u size:%u", ETG_CENUM(tenReqMode, mode), resList.size()));
   if(mode == _enReqMode_invalid) {
      _bIsReady = true;
      return;
   }
   _bIsReady = false;

   if(mode == _enReqMode_spmSWUMode) {
      SystemModes::instance()->requestModeForUpdate();
      return;
   }

   bool isChanged = false;
   for(std::set<std::string>::iterator Iter= resList.begin(); Iter != resList.end(); Iter++) {
      if(mode == _enReqMode_lock || mode == _enReqMode_forcelock) {
         if(checkHmiWantToHandle(*Iter) && !_hmiRegRes.isPresent(*Iter)) {
            isChanged = true;
            _hmiRegRes.push(*Iter);
            ETG_TRACE_USR2(("wait for user consent lockName:%s", *Iter));
            continue;
         } 
      }

      if(!_hmiPendingRes.isPresent(*Iter)) {
         _hmiPendingRes.push(*Iter);
      }
     configure(mode, *Iter);
   }  

   if(isChanged) { 
      vSendBgLockState(); 
      isChanged = false;    
   }

}


void ResourceManager::vSendBgLockState() {

   FCSWUPD_NS_FCSWUPD_T::trBgLocks registerLocks;
   registerLocks.setLocks(_hmiRegRes.getStack());

   FCSWUPD_NS_FCSWUPD_T::trBgLocks pendingLocks;
   pendingLocks.setLocks(_hmiPendingRes.getStack());
 
   FCSWUPD_NS_FCSWUPD_T::trBgLocksState lockState;
   lockState.setRegisteredLocks(registerLocks);
   lockState.setPendingLocks(pendingLocks);

   FCSWUPD_SET_ASF_PROPERTY(FcSwUpdSrv, lockState, BgLocksState);             
}

void ResourceManager::configure(tenReqMode mode, std::string name) {  
   ETG_TRACE_USR1(("ResourceManager::configure mode:%u", ETG_CENUM(tenReqMode, mode)));

   if(mode == _enReqMode_invalid) {
      _bIsReady = true;
      return;
   }
   _bIsReady = false;

  
   //check whether it is in users / owners list, if not spm will not give lock properly, so add it
   tenReqMode actualReqMode = mode;
   if(mode != _enReqMode_add) {

      SPMUserResData spmUserData;
      SPMResourceData spmOwnerData;

      if(_spmUsersRes.searchElemByLock(name, spmUserData) && _spmOwnersRes.searchElemByLock(name, spmOwnerData)) {   
         if(spmOwnerData.state == _enResourceState_locked && actualReqMode <= _enReqMode_forcelock) {
            ETG_TRACE_USR2(("user & owner is present continue with exist mode:%u", ETG_CENUM(ResourceManager::tenReqMode, mode)));
            actualReqMode = _enReqMode_invalid;
         }
      }
      else {         
         actualReqMode = _enReqMode_add;
         ETG_TRACE_USR2(("user is not present mode:%u", ETG_CENUM(ResourceManager::tenReqMode, actualReqMode)));
      }
   }  

   //request for the resource
   if(actualReqMode != _enReqMode_invalid) {
      if(actualReqMode == _enReqMode_remove) {
         _reqUsersRes.removeElem(name);
      } else {
         ResourceData reqData;
         //be careful here - it is mode only not actualReqMode
         //this is required for recursive request.
         reqData.mode = mode;
         reqData.lockName = name;
         _reqUsersRes.updateElem(reqData);
      }
      requestResource(actualReqMode, name);
   }   
}


void ResourceManager::releaseResources() {
   ETG_TRACE_USR4(("ResourceManager::releaseResources - START"));

   //Whereever in state if you want to release, just releases
   _reqUsersRes.clear();

   //release the owned resource.
   SPMResourceData ownerData;
   if(_spmOwnersRes.searchElemByOwner(CCA_C_U16_APP_FC_SW_UPDATE, ownerData)) {
      if(ownerData.state == _enResourceState_reserved) {
         requestResource(_enReqMode_add, ownerData.lockName);
      } else {
      requestResource(_enReqMode_remove, ownerData.lockName);
   }
   }

   if(!isFcSwuInUserList() && isSystemLockAvailableReg()) {
      ETG_TRACE_USR4(("SWU is not present, adding SWU to user's list"));
      configure(_enReqMode_add, CENTRAL_LOCK_TEXT);   
   } else {
      //fcswupdate is already added as users by SPM but not by fcswupdate.
      ResourceData data;
      if(!_reqUsersRes.searchElem(CENTRAL_LOCK_TEXT, data)) {
         ETG_TRACE_USR1(("SWU is present in SPM user list, not in SWU list. Adding"));
         data.mode = _enReqMode_add;
         data.lockName = CENTRAL_LOCK_TEXT;
         _reqUsersRes.push(data);
      }
   }
    
   ETG_TRACE_USR4(("ResourceManager::releaseResources - END"));

}

void ResourceManager::handleSpmResouces(::std::vector<FCSWUPD_NS_SPM_T::T_SPM_UpdateLockState> spmRes){
   ETG_TRACE_USR1(("ResourceManager::handleSpmResouces - START size:%u", spmRes.size()));
   
   _spmUsersRes.clear();
   _spmOwnersRes.clear();
   ::std::vector<FCSWUPD_NS_SPM_T::T_SPM_UpdateLockState>::iterator pos;

   for(pos = spmRes.begin(); pos != spmRes.end(); pos++) {
      FCSWUPD_NS_SPM_T::T_SPM_UpdateLockState spmData = *pos;

      tU16 ownerAppId = spmData.getU16LockOwner();
      std::vector<tU16> userAppIdList = spmData.getLu16LockUsers();

      ETG_TRACE_USR3(("OWNER::lockName:%80s ownerAppId:%x state:%u", spmData.getStrLockName().c_str(),  ownerAppId, 
                      ETG_CENUM(FCSWUPD_NS_SPM_T::T_e8_UpdateLockState, spmData.getELockState())));

      //users info
      SPMUserResData userData;
      userData.lockName = spmData.getStrLockName();
      std::vector<tU16> users;
      for(std::vector<tU16>::iterator Iter = userAppIdList.begin(); Iter != userAppIdList.end(); Iter++) {         
         ETG_TRACE_USR4(("USER::lockName:%80s user:0x%x",spmData.getStrLockName().c_str(), *Iter));
         users.push_back(*Iter);
         
      }
      userData.userList = users;
      _spmUsersRes.push(userData);


      //owner info      
      SPMResourceData resData;
      resData.state = getResourceState(spmData.getELockState());
      resData.ownerName = ownerAppId;
      resData.lockName = spmData.getStrLockName();
      _spmOwnersRes.push(resData);
     
   }       
  
   handleResourceChange();
   verify();

   ETG_TRACE_USR1(("ResourceManager::handleSpmResouces - END"));
}

ETG_I_CMD_DEFINE((lockSWU, "lockSWU"))
tVoid ResourceManager::lockSWU(bool bForce) {

   bool bRequestSWUResStatus = true;
   SPMResourceData ownerData;
   if(_spmOwnersRes.searchElemByOwner(CCA_C_U16_APP_FC_SW_UPDATE, ownerData)) {
      ETG_TRACE_USR2(("ownerName:0x%x ownerState:%u", ownerData.ownerName, ownerData.state));
      if(ownerData.ownerName == CCA_C_U16_APP_FC_SW_UPDATE && ownerData.state ==  _enResourceState_locked) {
         bRequestSWUResStatus = false ;
      }  
   }
   ETG_TRACE_USR1(("requestStatus:%u forceStatus:%u", bRequestSWUResStatus, bForce));

   if( bRequestSWUResStatus || bForce ) {            
      ResourceData reqData;
      reqData.lockName = CENTRAL_LOCK_TEXT;
      reqData.mode = _enReqMode_lock;  //end state
      _reqUsersRes.push(reqData);

      //intermediate state
      if(!isFcSwuInUserList()) {
         configure(_enReqMode_add, CENTRAL_LOCK_TEXT);   
      } else {
         configure(_enReqMode_reserve, CENTRAL_LOCK_TEXT);
      }
           
   } else {
      applyConfig();
   }     

}

ETG_I_CMD_DEFINE((verify, "simverifyResource"))
void ResourceManager::verify() {
   ETG_TRACE_USR2(("ResourceManager::verify - START"));

   bool bVerifyStatus = false;
   tU16 index = 0;
   while(index < _reqUsersRes.getSize()) {

      ResourceData reqData = _reqUsersRes.getElemFromIndex(index);
      SPMResourceData spmData;

      if(_spmOwnersRes.searchElemByLock(reqData.lockName, spmData)) {
         switch(spmData.state) {
            case _enResourceState_use:
               if(reqData.mode == _enReqMode_add) {
                  bVerifyStatus = true;
               }
               break;
            case _enResourceState_reserved:
               if(reqData.mode == _enReqMode_reserve) {
                  bVerifyStatus = true;
               }
               break;
            case _enResourceState_locking:
            case _enResourceState_locked:               
               bVerifyStatus = true;
               break;
            default:
               break;
         }
      }
      if(!bVerifyStatus) {
         break;
      }
      index++;
   }

   ETG_TRACE_USR2(("ResourceManager::verify status:%u hmiRegRes:%u", bVerifyStatus, _hmiRegRes.empty()));
   if(bVerifyStatus && _hmiRegRes.empty()) {
      _bIsReady = true;
      applyConfig();
   }
     
}


tVoid ResourceManager::handleResourceChange() {
   ETG_TRACE_USR1(("ResourceManager::handleResourceChange - START"));

   tU16 index = 0;
   while(index < _reqUsersRes.getSize()) {
      ResourceData reqData = _reqUsersRes.getElemFromIndex(index);

      SPMResourceData spmData;
      std::string processLockName = reqData.lockName;

      ETG_TRACE_USR2(("process lockname:%s", processLockName.c_str()));

      if(_spmOwnersRes.searchElemByLock(processLockName, spmData)) {

         ETG_TRACE_USR2(("(before)SPM:%u REQ:%u", ETG_CENUM(tenResourceState, spmData.state),
                         ETG_CENUM(tenReqMode, reqData.mode)));

         //if request mode is not reached, recursive till it reach the request mode.
         tenReqMode enReqMode = getNextReqMode(reqData.mode, spmData.state);
         ETG_TRACE_USR2(("(after)SPM:%u REQ:%u", ETG_CENUM(tenResourceState, spmData.state),
                         ETG_CENUM(tenReqMode, enReqMode)));

         if(enReqMode != _enReqMode_invalid) {
            requestResource(enReqMode, processLockName);
         }
         

         //if some other App is reserve app where FcSwUpdate is also the users of the app.
         //release that app from user list
         if(spmData.ownerName != CCA_C_U16_APP_FC_SW_UPDATE && spmData.state >= _enResourceState_locking) {
            if(isFcSwuInUserList()) {
               //release the resource from user list
               requestResource(_enReqMode_remove, CENTRAL_LOCK_TEXT);
            }
         }
      }
      index++;
   }
 
   ETG_TRACE_USR1(("ResourceManager::handleResourceChange - END"));

}

bool ResourceManager::isFcSwuInUserList() {
   return _spmUsersRes.searchElemByUser(CCA_C_U16_APP_FC_SW_UPDATE);
}

bool ResourceManager::isSystemLockAvailableReg() {
   bool bReturn = true;
   SPMResourceData spmOwnerData;
   if(_spmOwnersRes.searchElemByLock(CENTRAL_LOCK_TEXT, spmOwnerData)) {
      (spmOwnerData.state <= _enResourceState_reserved) ? bReturn = true : bReturn = false;
   } 
   ETG_TRACE_USR1(("ResourceManager::isSystemLockAvailableReg:status:%u", bReturn));
   return bReturn;
}

tenReqMode ResourceManager::getNextReqMode (tenReqMode actualReqMode, tenResourceState enstate) {
   ETG_TRACE_USR2(("getNextReqMode::actualReqMode:%u", ETG_CENUM(tenReqMode, actualReqMode)));
   ETG_TRACE_USR2(("SPMstate:%u", ETG_CENUM(tenResourceState, enstate)));

   tenReqMode enMode = _enReqMode_invalid;
   switch(enstate) {
      case _enResourceState_free:
         if(actualReqMode >= _enReqMode_add) {
            enMode = _enReqMode_add;
         }
         break;
      case _enResourceState_use:
         if(actualReqMode >= _enReqMode_reserve) {
            enMode = _enReqMode_reserve;
         }
         break;
      case _enResourceState_reserved:
         if(actualReqMode >= _enReqMode_lock) {
            enMode = _enReqMode_lock;
         }
         break;
      case _enResourceState_locking:
         break;
      case _enResourceState_locked:
         if(actualReqMode == _enReqMode_remove) {
            enMode = _enReqMode_remove;
         }
         break;
      default:
         break;
   }
   ETG_TRACE_USR4(("ResourceManager::getNextReqMode(END)mode:%u", ETG_CENUM(tenReqMode, enMode)));
   return enMode;
}


tVoid ResourceManager::requestResource(tenReqMode enState, std::string resName) {
   ETG_TRACE_USR4(("ResourceManager::requestResource name:%80s state:%u", resName.c_str(), ETG_CENUM(tenReqMode, enState)));

   FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand spmLockCmd;
   switch(enState) {
      case _enReqMode_remove:
         spmLockCmd = FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand__SPM_e8_Release;
         break;
      case _enReqMode_add:
         spmLockCmd = FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand__SPM_e8_Use;
         break;
      case _enReqMode_reserve:
         spmLockCmd = FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand__SPM_e8_Reserve;
         break;
      case _enReqMode_lock:
         spmLockCmd = FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand__SPM_e8_Lock;
         break;
      case _enReqMode_forcelock:
         spmLockCmd = FCSWUPD_NS_SPM_T::T_e8_UpdateLockCommand__SPM_e8_MasterLock;
         break;
      case _enReqMode_invalid:
      default:
         return;
   }
   SpmIf::instance()->requestLockResource(spmLockCmd, resName);
}


tenResourceState ResourceManager::getResourceState(FCSWUPD_NS_SPM_T::T_e8_UpdateLockState spmState) {
   tenResourceState enState = _enResourceState_invalid;
   switch(spmState) {
      case FCSWUPD_NS_SPM_T::T_e8_UpdateLockState__SPM_e8_Used:
         enState = _enResourceState_use;
         break;
      case FCSWUPD_NS_SPM_T::T_e8_UpdateLockState__SPM_e8_Reserved:
         enState = _enResourceState_reserved;
         break;
      case FCSWUPD_NS_SPM_T::T_e8_UpdateLockState__SPM_e8_Locking:
         enState = _enResourceState_locking;
         break;
      case FCSWUPD_NS_SPM_T::T_e8_UpdateLockState__SPM_e8_Locked:
         enState = _enResourceState_locked;
         break;
   }
   return enState;
}

ETG_I_CMD_DEFINE((printSPMUsersInfo, "printSPMUsersInfo"))
void ResourceManager::printSPMUsersInfo() {
   _spmUsersRes.traceStack();
}

ETG_I_CMD_DEFINE((printSPMOwnersInfo, "printSPMOwnersInfo"))
void ResourceManager::printSPMOwnersInfo() {
   _spmOwnersRes.traceStack();
}

ETG_I_CMD_DEFINE((printReqUsersInfo, "printReqUsersInfo"))
void ResourceManager::printReqUsersInfo() {
   _reqUsersRes.traceStack();
}


ETG_I_CMD_DEFINE((printHMIReqRes, "printHMIReqRes"))
void ResourceManager::printHMIReqRes() {
   _hmiReqOwnerRes.traceStack();
}

ETG_I_CMD_DEFINE((simClearReqUser, "simClearReqUser"))
void ResourceManager::simClearReqUser() {
   _reqUsersRes.clear();
}


ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_add %80s", ETG_I_STRING, ETG_I_CONST_ARG(1)))
ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_reserve %80s", ETG_I_STRING, ETG_I_CONST_ARG(2)))
ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_lock %80s", ETG_I_STRING, ETG_I_CONST_ARG(3)))
ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_forceLock %80s", ETG_I_STRING, ETG_I_CONST_ARG(4)))
ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_remove %80s", ETG_I_STRING, ETG_I_CONST_ARG(5)))
ETG_I_CMD_DEFINE((simRequestResource, "simRequestResource_clearall %80s", ETG_I_STRING, ETG_I_CONST_ARG(6)))
void ResourceManager::simRequestResource(const char *name, tU16 mode) {

   ETG_TRACE_USR4(("ResourceManager::simRequestResource - START mode:%u APP:%50s",mode, name));

   if((tenReqMode)mode == _enReqMode_clearAll) {
      releaseResources();
   } else {
      configure((tenReqMode)mode, name);
   }

   ETG_TRACE_USR4(("ResourceManager::simRequestResource - END"));
}



}
