#ifndef FCSWUPD_MAIN_MESSAGES_H
#define FCSWUPD_MAIN_MESSAGES_H

#include "util/fcswupd_types.hpp"
#include "util/swu_msg.hpp"
#include "util/fcswupd_trace.hpp"
//#include "main/fcswupd_component.h"

#define SWU_COMP_RET(M) if (M != rhs.M) { return true; }

namespace fcswupdate {
   class CtrlProgressSection;

   struct Msg_NotifySwUpdateState: public swu::Msg<Msg_NotifySwUpdateState, FcSwUpdRoot>  {
      Msg_NotifySwUpdateState(tenSwUpdateState enState_):enState(enState_) {};
      virtual tVoid vTrace();

      tenSwUpdateState enState;
   };


   struct Msg_NotifyDevManagerChanged: public swu::Msg<Msg_NotifyDevManagerChanged, FcSwUpdRoot>  {
      Msg_NotifyDevManagerChanged():
         _bHasCustomerUpdate(false),
         _bHasFormatsupported(true)
      {}

      virtual tVoid vTrace();

      std::map< std::string, trSourceInfo > _mapSources;
      bool _bHasCustomerUpdate;
      bool _bHasFormatsupported;
   };

   struct Msg_NotifySystemDataChanged: public swu::Msg<Msg_NotifySystemDataChanged, FcSwUpdRoot>  {
      virtual tVoid vTrace();
   };

   struct Msg_CopyProgressBarElements: public swu::Msg<Msg_CopyProgressBarElements, FcSwUpdRoot>  {
	   Msg_CopyProgressBarElements(std::string path): _path(path) {};
       virtual tVoid vTrace();

	   std::string _path;
    };

   struct Msg_NotifyVerBackDocChanged: public swu::Msg<Msg_NotifyVerBackDocChanged, FcSwUpdRoot>  {
      Msg_NotifyVerBackDocChanged(tU16 key_, tU16 ack_, tU16 ackOk_):
         key(key_),
         ack(ack_),
         ackOk(ackOk_)
      {};
      virtual tVoid vTrace();
      tU16 key;
      tU16 ack;
      bool ackOk;
   };


   struct Msg_NotifyCtrlError: public swu::Msg<Msg_NotifyCtrlError, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyCtrlError(std::list< uint32_t > const &errors):
         _errors(errors)
      {};

      std::list< uint32_t > _errors;
   };


   struct Msg_NotifyConfiguratorError: public swu::Msg<Msg_NotifyConfiguratorError, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyConfiguratorError(std::list< uint32_t > const &errors):
         _errors(errors)
      {};

      std::list< uint32_t > _errors;
   };


   struct Msg_NotifyCtrlResult: public swu::Msg<Msg_NotifyCtrlResult, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyCtrlResult(CtrlProgressSection const *progressSection, bool result):
         _progressSection(progressSection), _result(result)
      {};

      CtrlProgressSection const *_progressSection;
      bool _result;
   };

   struct Msg_NotifyPrjState: public swu::Msg<Msg_NotifyPrjState, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyPrjState(tenPrjState enState):
         _enState(enState)
      {};

      tenPrjState _enState;
   };



   /*
      Flashing is done, but we have not reached state result
      */
   struct Msg_NotifyFlashingDone: public swu::Msg<Msg_NotifyFlashingDone, FcSwUpdRoot>  {
      virtual tVoid vTrace();
      Msg_NotifyFlashingDone(bool success, std::string trainName):
         _success(success),
         _trainName(trainName)
      {};

      bool   _success;
      std::string _trainName;
   };

   struct Msg_ConfigChanged: public swu::Msg<Msg_ConfigChanged, FcSwUpdRoot>  {
      virtual tVoid vTrace() {};
   };

   struct Msg_NextRequest: swu::Msg<Msg_NextRequest,FcSwUpdRoot > {
      virtual tVoid vTrace();
   };

   struct ProgressInformation {
      ProgressInformation() :
         train(),
         deviceName(),
         moduleName(),
         subModuleName(),
         source(),
         line1(),
         line2(),
         luaCmd(),
         retries(0),
         curRetries(0),
         numAll(0),
         numComplete(0),
         numRunning(0),
         numNotApplicable(0),
         numFailed(0),
         numRemaining(0),
         percent(0),
         percentRelease(0),
         percentReleaseForPhase(0),
         estimatedUpdateTime(0),
         estimatedUpdateTimeForPhase(0),
         estimatedCurrentModuleUpdateTime(0){
         
        }

      bool operator!=(ProgressInformation const &rhs) {
         SWU_COMP_RET(train);
         SWU_COMP_RET(deviceName);
         SWU_COMP_RET(moduleName);
         SWU_COMP_RET(subModuleName);
         SWU_COMP_RET(source);
         SWU_COMP_RET(line1);
         SWU_COMP_RET(line2);
         SWU_COMP_RET(luaCmd);
         SWU_COMP_RET(retries);
         SWU_COMP_RET(curRetries);
         SWU_COMP_RET(numAll);
         SWU_COMP_RET(numComplete);
         SWU_COMP_RET(numRunning);
         SWU_COMP_RET(numNotApplicable);
         SWU_COMP_RET(numFailed);
         SWU_COMP_RET(numRemaining);
         SWU_COMP_RET(percent);
         SWU_COMP_RET(percentRelease);
         SWU_COMP_RET(percentReleaseForPhase);
         SWU_COMP_RET(estimatedUpdateTime);
         SWU_COMP_RET(estimatedUpdateTimeForPhase);
         SWU_COMP_RET(estimatedCurrentModuleUpdateTime);
         return false;
      }
      ::std::string train;

      ::std::string deviceName;

      ::std::string moduleName;

      ::std::string subModuleName;

      ::std::string refKey;

      ::std::string source;

      ::std::string line1;

      ::std::string line2;

      ::std::string luaCmd;

      uint32_t retries;

      uint32_t curRetries;

      uint32_t numAll;

      uint32_t numComplete;

      uint32_t numRunning;

      uint32_t numNotApplicable;

      uint32_t numFailed;

      uint32_t numRemaining;

      uint8_t percent;

      uint8_t percentRelease;

      uint8_t percentReleaseForPhase;

      uint32_t estimatedUpdateTime;

      uint32_t estimatedUpdateTimeForPhase;
	  
	  uint32_t estimatedCurrentModuleUpdateTime;

      void traceState();
   };


   struct Msg_ProgressInformation: swu::Msg< Msg_ProgressInformation, FcSwUpdRoot > {
      Msg_ProgressInformation(ProgressInformation const &progress_):
         progress(progress_) {
         } 
      Msg_ProgressInformation() {
      }
      bool operator!=(Msg_ProgressInformation const &rhs) {
         return progress!=rhs.progress;
      }

      virtual tVoid vTrace(){ 
         progress.traceState();
      }
      ProgressInformation progress;
   };

   struct Msg_ActivePackageChanged : swu::Msg< Msg_ActivePackageChanged, FcSwUpdRoot > {
      Msg_ActivePackageChanged(trActivePackage activePackage_) :
         activePackage(activePackage_)
      {}

      virtual tVoid vTrace();

      trActivePackage activePackage;
   };

   struct Msg_OtaStateChanged : swu::Msg< Msg_OtaStateChanged, FcSwUpdRoot > {
      Msg_OtaStateChanged(trOtaState otaState_) :
         otaState(otaState_)
      {}

      virtual tVoid vTrace();

      trOtaState otaState;
   };

   struct Msg_UpdateSelectReleaseByFileResult : swu::Msg< Msg_UpdateSelectReleaseByFileResult, FcSwUpdRoot > {
      Msg_UpdateSelectReleaseByFileResult(bool success_=true) :
         success(success_)
      {}

      virtual tVoid vTrace() {};

      bool success;
   };

   struct Msg_AbortInstallRequest : swu::Msg<Msg_AbortInstallRequest, FcSwUpdRoot> {
      Msg_AbortInstallRequest(const std::string modId) :
      _inModId(modId)
      {}

      virtual tVoid vTrace();
      std::string _inModId;
   };


}


#endif
