#ifndef FCSWUPD_MAIN_H
#define FCSWUPD_MAIN_H

#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"
#include "util/swu_localtime.hpp"
#include "configurator/fcswupd_configurator.h"
#include "ctrl/fcswupd_ctrl.h"
#include "fcswupd_releaseFilterIf.h"
#include "main/fcswupd_xmlFilterIf.h"
#include "main/fcswupd_campaignmanager.h"

namespace swu {
class LocalTime;
}

namespace fcswupdate {

class ReleaseFilterIf;
class ParserIf;
class Msg_NotifyCtrlResult;

struct Msg_CvmEventStatus;

struct Msg_CvmEventStatus;


void FcSwUpd_tracePtr(std::string str, void *val);

struct Msg_ResetFcSwUpdCore: public swu::Msg< Msg_ResetFcSwUpdCore, FcSwUpdRoot > {
   Msg_ResetFcSwUpdCore() {};
   virtual tVoid vTrace();

};

struct Msg_ResetFactorySettings: public swu::Msg< Msg_ResetFactorySettings, FcSwUpdRoot > {
	Msg_ResetFactorySettings() {};
	virtual tVoid vTrace();

};

struct Msg_FinalizeTimeout: public swu::Msg< Msg_FinalizeTimeout, FcSwUpdRoot > {
   virtual tVoid vTrace() {};
};

struct Msg_FcSwUpdRecoveryIdleStateTimer;

class Configurator;



struct Msg_DistTotal: public swu::Msg< Msg_DistTotal, FcSwUpdRoot > {
   virtual tVoid vTrace() {};
   tU32 distTotal;
};

class DistTotalizerIf {
public:
   virtual tUInt getDistTotal() { return 0;};
};

class Gen3If {
//Coverity fix for 170933.
public:
   virtual ~Gen3If()
   {
   }
};

class ScomoSrvIf {
public:
   virtual  bool sendPhaseResult(tBool bStatus) { return false; }
};


class LocalTimeIf {
public:
   virtual  bool getLocalTime(swu::LocalTime &lc);
};

class TestPluginIf {
public:
   virtual tUInt getDummyValue()=0;
   virtual ~TestPluginIf() {  //Coverity fix for 98892
   }
};

class TestDynPluginIf {
public:
   virtual tUInt getDummyValue()=0;
   virtual ~TestDynPluginIf() { //Coverity fix for 98897
   }
};
class TestDynPlugin2If {
public:
   virtual tUInt getDummyValue()=0;
   virtual ~TestDynPlugin2If() {  //Coverity fix for 98893
   }
};
class TestDynPlugin3If {
public:
   virtual tUInt getDummyValue()=0;
   virtual ~TestDynPlugin3If() { //Coverity fix for 98891
   }
};


class FcSwUpdCore:  public swu::Member<FcSwUpdRoot>, public swu::Singleton<FcSwUpdCore> {
   friend class swu::Singleton<FcSwUpdCore>;

public:
template<class IFBASE>
class IfAccess:public swu::Singleton<IfAccess<IFBASE> > {
   friend class swu::Singleton< IfAccess<IFBASE> >;
   friend class FcSwUpdCore;
private:

   IfAccess() {
      FcSwUpd_tracePtr("IfAccess CTOR:", (void *)this);
   }
   virtual ~IfAccess() {
      FcSwUpd_tracePtr("IfAccess DTOR:", this);
      delete _iface;
   }

   void reg(IFBASE *iface) {
      FcSwUpd_tracePtr("IfAccess reg this:", this);
      FcSwUpd_tracePtr("IfAccess reg iface:", iface);
      FcSwUpd_tracePtr("IfAccess reg _iface:", _iface);
      //      delete _iface;
      _iface=iface;
   }

   void dereg(IFBASE *iface) {
      FcSwUpd_tracePtr("IfAccess dereg:", this);
      FcSwUpd_tracePtr("IfAccess dereg iface:", iface);
      FcSwUpd_tracePtr("IfAccess dereg _iface:", _iface);
      if (_iface==iface) {
         FcSwUpd_tracePtr("IfAccess dereg found:", this);
         _iface=0;
      }
   }

   IFBASE *get() {
      FcSwUpd_tracePtr("IfAccess get:", this);
      FcSwUpd_tracePtr("IfAccess get _iface:", _iface);
      return _iface;
   }

private:
   static IFBASE *_iface;
};

public:
   template<class IFBASE> 
   static IFBASE *getIf() {
      IFBASE *res=IfAccess<IFBASE>::instance()->get();
      FcSwUpd_tracePtr("getIf:res=", res);
      return res;
   }

   template<class IFBASE> 
   static IFBASE *getIfOrDefault() {
      static IFBASE defaultIf;
      IFBASE *res =getIf<IFBASE>();
      if (! res) {
         FcSwUpd_tracePtr("getIfOrDefault return default:", 0);
         res = &defaultIf;
      }
      FcSwUpd_tracePtr("getIfOrDefault:res=", res);
         
      return res;
   }

   template<class IFBASE, class IFACE> 
   static void regIf(IFACE const *iface) {
      IFBASE *ifBase=const_cast<IFACE *>(iface);
      FcSwUpd_tracePtr("FcSwUpdCore::regIf:", ifBase);
      IfAccess<IFBASE>::instance()->reg(ifBase);
   } 

   template<class IFBASE, class IFACE> 
   static void deregIf(IFACE *iface) {
      IFBASE *ifBase=iface;
      FcSwUpd_tracePtr("FcSwUpdCore::regIf:", (void *)ifBase);
      IfAccess<IFBASE>::instance()->dereg(ifBase);
   } 

   FcSwUpdCore();
   virtual ~FcSwUpdCore();
   virtual tVoid vInit();
   virtual tVoid vDeInit();
   // only messgage from hmi-if that we have to handle here:
   virtual const char *getName() {
      return "FcSwUpdCore";
   }
   virtual void traceState();

   tBool bIsIdle();
   tVoid vEnterUpdate(tenSwUpdateMode enMode, Configurator *configurator);

   ParserIf *createParser(trSourceInfo const &sourceInfo);

   void addReleaseFilter(ReleaseFilterIf *filter, bool first = false);
   void removeReleaseFilter(std::string filterName);
   void activateReleaseFilter(std::string filterName, bool doActivate);
   void addBxmlFilter(ReleaseFilterIf *filter, bool first = false);
   void removeBxmlFilter(std::string filterName);
   void getReleaseList(std::list < TiXmlElement > &relList, trSourceInfo const &sourceInfo, tenSwUpdateError *errorCode = (tenSwUpdateError *) NULL);
   TiXmlDocument *getReleaseXml(TiXmlElement const &overallSection, tenSwUpdateError &errorCode, size_t id = 0);

   void testFn();

   // handle internal loopback-msg   
   tVoid vProcess(Msg_FinalizeTimeout *pMsg);
   tVoid vProcess(Msg_ResetFcSwUpdCore *pMsg);
   tVoid vProcess(Msg_ResetFactorySettings *pMsg);
   tVoid vProcess(Msg_NotifyCtrlResult *pMsg);

   tVoid vProcess(Msg_FcSwUpdRecoveryIdleStateTimer *pMsg);

   void requestRebootForRecovery();

   //House Keeping
   void startFinalizeTimer(tU32 u32delay) {
      _finalizeTimer.start(this, u32delay);
   }
   void stopFinalizeTimer() {
      _finalizeTimer.stop();
   }
   void setReadyAction(CtrlReadyAction readyAction){
      _readyAction = readyAction;
   }
   void displayReadyMsg();

   // ttfis-cmds
   void etgTest();
   void resetUpdate();
   void simGlobalLogFailure();
   void simGlobalLogInterface();
   void simSegmentationFault();
   void simResetFactorySettings();   
   void simTestBxmlFilter(const char *path_xml);
   void simTestXmlFilter(const char *path_xml);
   void simStoreHistory(const char *path, bool sinceReset);
   void simSwitchBootSectors();
   void simWriteMagicToActiveSector(tU32 address, tU32 value);
   void simUsedBootChain();
   void simActivateRecoveryMode();
   void simActivateApplicationMode();
   void simDumpBootChainConfig();

   // handle spm-property
   tVoid vProcess(Msg_CvmEventStatus *pMsg);

   void vPreparePersistentFile(std::string defaultFile, std::string persistentFile) const;
   
   SWU_MOCK_VIRTUAL tenSwUpdateMode enGetUpdateMode() const {
      return CampaignManager::instance()->enGetUpdateMode();
   }

   // only for testing:
   tU32 getDistTotal();
   // only for testing:
   swu::LocalTime getLocalTime();

   
   // just as entry for ttfis-command
   bool loadPlugin(char const *pluginName);
   // just as entry for ttfis-command
   void activatePlugins();

   // just as entry for ttfis-command
   tUInt getTestPluginIfDummyVal();
   tUInt getTestDynPluginIfDummyVal();
   tUInt getTestDynPlugin2IfDummyVal();
   tUInt getTestDynPlugin3IfDummyVal();



private:    
#ifndef __SW_UPDATE_UNIT_TESTING__
   swu::SwUpdTimer< FcSwUpdCore, Msg_FinalizeTimeout > _finalizeTimer;
#endif
   CtrlReadyAction _readyAction;
   swu::MemberList<FcSwUpdRoot> _memberList;   

   ReleaseFilterChain _releaseFilters;
   ReleaseFilterChain _bxmlFilters;
   XMLFilterChain     _srcXmlFilters;
};

template <typename IFBASE> IFBASE* FcSwUpdCore::IfAccess<IFBASE>::_iface = 0;

struct Msg_NotifySwUpdateState;
struct Msg_NotifySystemDataChanged;
struct Msg_NotifyPrjState;

// this class has to be implemented project-specific
class FcSwUpdProjectSpecific : public swu::Member<FcSwUpdRoot> {
public:
   virtual tVoid vOnFcSwUpdState(tenSwUpdateState enState)=0;
   virtual tVoid vOnSystemDataChanged()=0;
   virtual tVoid vSetPrjState(tenPrjState enPrjState)=0;

   virtual ParserIf *createPrjParser(trSourceInfo sourceInfo) = 0;

   virtual CtrlAdapter *pCreateCtrlAdapter(Ctrl *pCtrl, tenSwUpdateMode enMode)=0;

   virtual tVoid vInit(); // final
   virtual tVoid vDeInit(); // final
   virtual tVoid vInitPrj()=0;
   virtual tVoid vDeInitPrj()=0;
   virtual tVoid vEnterRecoveryDownload()=0;

   tVoid vProcess(Msg_NotifyPrjState const *pMsg);
   tVoid vProcess(Msg_NotifySwUpdateState const *pMsg);
   tVoid vProcess(Msg_NotifySystemDataChanged const *pMsg);
};

extern FcSwUpdProjectSpecific *poGetProjectSpecific();

}

#endif
