#include <stdio.h>
#include <dlfcn.h>
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "main/fcswupd_component.h"
#include "tinyxml/tinyxml.h"
#include "util/swu_filesystem.h"
#include "util/swu_member.hpp"
#include "util/swu_xmlDoc.h"
#include "util/swu_configFactory.hpp"
#include "config/fcswupd_config.hpp"
#include "util/swu_util.hpp"
#include "util/swu_preInit.h"
#include "util/swu_plugin.h"
#include "util/fcswupd_globalLog.h"
#include "main/fcswupd_dataStore.h"
#include "main/fcswupd_parserIf.h"
#include "main/fcswupd_systemData.h"
#include "main/fcswupd_spmIf.h"
#include "main/fcswupd_diagLog.h"
#include "main/fcswupd_systemModes.h"
#include "main/fcswupd_ttfisCmd.hpp"
#include "main/fcswupd_history.h"
#include "main/fcswupd_releaseFilterIf.h"
#include "main/fcswupd_xmlFilterIf.h"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_propProgress.h"
#include "main/fcswupd_bxmlCheck.h"
#include "main/fcswupd_srvGeneric.h"
#include "main/fcswupd_resourcemanager.h"
#include "main/fcswupd_specialRelease.h"
#include "main/fcswupd_tftpIf.h"
#include "main/fcswupd_isoMounter.h"
#include "main/fcswupd_hmisettings.h"
#include "ctrl/fcswupd_ctrl.h"
#include "configurator/fcswupd_configurator.h"
#include <iostream>
#include <fstream>
#include "configurator/fcswupd_configuratorEngineering.h"
#include "configurator/fcswupd_configuratorHmiGeneric.h"
#include "parser_bosch/fcswupd_parserBosch.h"
#include "parser_cms/fcswupd_parserCMS.h"
#include "util/swu_crypto.hpp"
#include <signal.h>

#include "fcswupd_mainMessages.hpp"
#include "fcswupd_main.h"
#include "util/fcswupd_trace.hpp"
#include "util/swu_execCommand.h"
#include "util/swu_globallog.h"
#include "util/swu_bootChainAccess.hpp"

#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdCore::instance()->

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_main.cpp.trc.h"
#endif

namespace fcswupdate {


static class PreInitMain:public swu::PreInit<FcSwUpdRoot> {
public:
   // method will be called during initialization of fcswupd,
   // grep for PreInitManager
   virtual void execute() {
      ETG_TRACE_USR4(("PreInitMain:test"));
   }
} _preInitMain;


tVoid Msg_ResetFcSwUpdCore::vTrace() {
   ETG_TRACE_USR2(("Msg_ResetFcSwUpdCore"));
}

tVoid Msg_ResetFactorySettings::vTrace() {
   ETG_TRACE_USR2(("Msg_ResetFactorySettings"));
}

tVoid FcSwUpdProjectSpecific::vInit() {
   ETG_TRACE_USR2(("FcSwUpdProjectSpecific::vInit"));
   Msg_NotifySwUpdateState::vSubscribe(this);
 //  Msg_NotifyConfigAvail::vSubscribe(this);
   Msg_NotifyPrjState::vSubscribe(this);
   Msg_NotifySystemDataChanged::vSubscribe(this);
   vInitPrj();
}

tVoid FcSwUpdProjectSpecific::vDeInit() {
   ETG_TRACE_USR1(("FcSwUpdProjectSpecific::vDeInit"));
   vDeInitPrj();
   Msg_NotifySwUpdateState::vUnSubscribe(this);
//   Msg_NotifyConfigAvail::vUnSubscribe(this);
   Msg_NotifySystemDataChanged::vUnSubscribe(this);
}

tVoid FcSwUpdProjectSpecific::vProcess(Msg_NotifySwUpdateState const *pMsg) {
   vOnFcSwUpdState(pMsg->enState);
}

tVoid FcSwUpdProjectSpecific::vProcess(Msg_NotifySystemDataChanged const *pMsg) {
   (void) pMsg;
   vOnSystemDataChanged();
}

tVoid FcSwUpdProjectSpecific::vProcess(Msg_NotifyPrjState const *pMsg) {
   vSetPrjState(pMsg->_enState);
}

void SigChldHandler(int Sig)
{
  return;
}

FcSwUpdCore::FcSwUpdCore() {
   ETG_TRACE_USR2(("FcSwUpdCore(%p)::FcSwUpdCore CTOR", this));
   signal(SIGCHLD, SigChldHandler);
}

FcSwUpdCore::~FcSwUpdCore() {
   ETG_TRACE_USR2(("FcSwUpdCore()::FcSwUpdCore DTOR"));

}

void FcSwUpdCore::traceState() {      
   _memberList.traceState(getName());
}
 
tVoid FcSwUpdCore::vDeInit() {
   ETG_I_UNREGISTER_FILE();
}

tVoid FcSwUpdCore::vInit() {
   ETG_TRACE_USR2(("FcSwUpdCore(%p)::vInit START", this));
   ETG_I_REGISTER_FILE();
   
   if (!swu::makeDirectoryRecursive(FCSWUPD_TMP_ROOT, 0755)) {
      ETG_TRACE_ERR(("FcSwUpdCore::vInit: could not create directory: %s", FCSWUPD_TMP_ROOT));
      SWU_ASSERT_ALWAYS();
      return;
   }

   bool persistent_dir_exists;
   if (!Config::getUsePersistentPart()) {
      if (swu::exists("/var/opt/bosch/persistent/fcswupdate", persistent_dir_exists)) {
         if (persistent_dir_exists) {
            if (swu::isDirectory("/var/opt/bosch/persistent/fcswupdate", persistent_dir_exists)) {
               if (persistent_dir_exists) {
                  if (!swu::removeDirectoryRecursive("/var/opt/bosch/persistent/fcswupdate")) {

                     ETG_TRACE_ERR(("Could not remove /var/opt/bosch/persistent/fcswupdate"));
                  }
               } else {
                  unlink("/var/opt/bosch/persistent/fcswupdate");
               }
            } else {
               ETG_TRACE_ERR(("Could not check if /var/opt/bosch/persistent/fcswupdate is a directory"));
            }
         }
      } else {
         ETG_TRACE_ERR(("Could not check if /var/opt/bosch/persistent/fcswupdate exists"));
      }
   }


   if (Config::getUsePersistentPart()) {
      ETG_TRACE_USR4(("FC_SW_UPDATE will use persistent partition"));
      if (!swu::exists(Config::getPersitentDirName())) {
         ETG_TRACE_USR4(("FC_SW_UPDATE will use persistent partition"));
         ETG_TRACE_USR1(("FcSwUpdCore::vInit create persistent defaults"));
         SWU_ASSERT_RETURN(swu::makeDirectoryRecursive(Config::getPersitentDirName().c_str(), 0700));
      }

   } else {
      ETG_TRACE_USR4(("FC_SW_UPDATE will NOT use persistent partition"));
   }

#if 0
   swu::TestFilesystem *tf = swu::TestFilesystem::instance();
   tf->vInit();
#endif

   ETG_TRACE_USR2(("FcSwUpdCore::vInit: create members ..."));
   _memberList.addMember(DataStore::instance())->vInit();
   ETG_TRACE_USR1(("FcSwUpdCore::vInit: create Config ..."));
   _memberList.addMember(Config::instance());
   ETG_TRACE_USR1(("FcSwUpdCore::vInit: create Config done"));
   //   _memberList.addMember(History::instance());
#if 0
   _memberList.addMember(DpIf::instance());
#endif
   _memberList.addMember(SystemData::instance());
   _memberList.addMember(SystemModes::instance());

   std::string prjCfgFile="/opt/bosch/swupdate/fcswupdate/prjConfig.xml";
   ETG_TRACE_COMP(("ConfigPrj::check for cfg-file:%s", prjCfgFile.c_str()));
   if (swu::exists(prjCfgFile)) {
      ETG_TRACE_COMP(("ConfigPrj::found cfg-file:%s", prjCfgFile.c_str()));
      swu::setConfigXml(prjCfgFile, Config::instance(), DataStore::instance());
   }
   
   _memberList.addMember(poGetProjectSpecific());
   
#ifndef VARIANT_S_FTR_ENABLE_G4G
   if(SpmIf::instance()->getV850Mode()!=SpmIf::V850_MODE_APPLICATION)
   {
      // This code handles the special case that the V850 is not able to switch to application mode.
      // When we get here, the startrecoverydnl.sh was not able to repair the V850 for some reason.
      // In this case it is not possible to update anything that depends on the V850.
      // For that reason we fake the installed CompatIndex to force the SWUpdate to perform a compatibility update.
      // This means that everything will be skipped except iMX bootloader and V850 preparation and the target will be rebooted.
      // We hope, that this will fix the V850, so a regular full update can be performed afterwards.
      swu::print2errmem("Enforcing compatibility update because the V850 is not in application mode");
      ETG_TRACE_COMP(("Enforcing compatibility update because the V850 is not in application mode"));
      swu::printToDownloadPipe("Enforcing compatibility update because the V850 is not in application mode");
      // CHECKME: Using 0 might not be a good idea because it could be considered a special case for historical reasons.
      //          Currently it seems as if this is not the case.
      Config::instance()->cfg_SwuCompatIndex.set(0);
   }
#endif
   _memberList.addMember(DiagLog::instance());
   _memberList.addMember(SpmIf::instance());
   _memberList.addMember(PropDevMgr::instance());
   _memberList.addMember(SpecialRelease::instance());
   _memberList.addMember(IsoMounter::instance());
   _memberList.addMember(TftpIf::instance());
   _memberList.addMember(PropProgress::instance());
   _memberList.addMember(TtfiCmd::instance());
   _memberList.addMember(hmisettings::instance());
   _memberList.addMember(ResourceManager::instance());
   _memberList.addMember(CampaignManager::instance());
   std::set<std::string> libs;
   /*
     load all dynamic plugins that are indicated as soft-links in directory autoLoadPlugins
    */
   swu::PluginManager<FcSwUpdRoot>::instance()->loadDynPlugins("/opt/bosch/swupdate/fcswupdate/autoLoadPlugins", "lib*", true);

   /* now PluginManager has registere all plugins (static one from static-initializers, 
    dynamic ones by the code above */
   swu::PluginManager<FcSwUpdRoot>::instance()->execute(&_memberList);
   

   /* add filters before initialization of member-list, since vInit of some members will already
      create a parser and hence a fully configured filter-chain is needed.
    */

   _srcXmlFilters.add( new XMLFilterMatch("FCIDS", Config::instance()->cfg_FcIdStr.get()));

   _bxmlFilters.add( new ReleaseFilterConvertScomoIndex);
   _bxmlFilters.add( new BxmlFilterBaseNodes);
   _bxmlFilters.add( new BxmlFilterMatch("FCIDS", Config::instance()->cfg_FcIdStr.get()));
   _bxmlFilters.add( new BxmlFilterMatch("BOARDIDS", Config::instance()->cfg_BoardId.get()));
   _bxmlFilters.add( new BxmlFilterMatch("CMVARIANTID", Config::instance()->cfg_CmVariantId.get()));
   _bxmlFilters.add( new SxmTypeFilter());
   _bxmlFilters.add( new UpdateXmlFilter);
   _bxmlFilters.add( new BxmlFilterExtraArgs());

   _releaseFilters.add( new ReleaseFilterMandatoryNodes());
#ifndef VARIANT_S_FTR_ENABLE_G4G
      _releaseFilters.add( new ReleaseFilterCheckSRK());
#endif
   _releaseFilters.add( new ReleaseFilterCheckFcids());
   _releaseFilters.add( new ReleaseFilterCheckPrjId());
   _releaseFilters.add( new ReleaseFilterFileExistence());
   _releaseFilters.add( new ReleaseFilterDnlSize());
   _releaseFilters.add(new ReleaseFilterCompat);
   _releaseFilters.add(new ReleaseFilterRename("_X"));
   _releaseFilters.add(new ReleaseFilterDefault);
   _releaseFilters.add(new BXmlMoveElemFromParentToChild("UPDATE_TIME", XmlItemAccess::enType_Module));

#if 0
   FILE *console=fopen("/dev/console", "w");
   if (console) {
      fprintf(console, "XXX hello /dev/console from fc_swupdate\n");
      fclose(console);
   }

   console=fopen("/dev/ttymxc3", "w");
   if (console) {
      fprintf(console, "XXX hello /dev/ttymxc3 from fc_swupdate\n");
      fclose(console);
   }
#endif

   ETG_TRACE_USR1(("FcSwUpdCore::vInit: subscriptions ..."));      
   Msg_ResetFcSwUpdCore::vSubscribe(this);
   Msg_ResetFactorySettings::vSubscribe(this);
   Msg_NotifyCtrlResult::vSubscribe(this);

   ETG_TRACE_USR1(("FcSwUpdCore::vInit: init members ..."));
   _memberList.vInit();


   if (CampaignManager::instance()->bReEnterStateRunning()) {
      ETG_TRACE_USR2(("FcSwUpdCore::vInit: ReEntered state running"));

   }
   else if (Config::instance()->cfg_EnterEngineering.readAsBool()) {
      // Here we should be in Engineering Mode, booted into DLInitRamFS
      Configurator *configurator = OSAL_NEW(ConfiguratorEngineering);
      if (configurator) {
         // todo: by now we simply forget a possibly running update
         Msg_ResetFcSwUpdCore msg;
         notify(msg);         
         vEnterUpdate(tenSwUpdateMode_Engineering, configurator);
      }
   } else if (Config::instance()->cfg_EnterRecovery.readAsBool()) {
      if (Config::instance()->cfg_ForceShutdownRequested.readAsBool()) {
         Config::instance()->cfg_DoShutdownAfterUpdate.setFromBool(true);
      }
      // Here we should be in Recovery Mode, booted into DLInitRamFS
      ETG_TRACE_USR1(("FcSwUpdProjectSpecific::call vEnterRecoveryDownload"));
      // todo: by now we simply forget a possibly running update
      Msg_ResetFcSwUpdCore msg;
      notify(msg);
      // ... and start the recovery-update
      poGetProjectSpecific()->vEnterRecoveryDownload();
      ETG_TRACE_USR1(("FcSwUpdCore::vInit: Idle State Timer ..."));

      _readyAction.enAction=enCtrlReadyAction_reboot;
      _readyAction.enInterval=enCtrlReadInterval_Minutes;
      _readyAction.u32NumIntervals=(Config::instance()->cfg_RecoveryMaxIdleTimeMs.get() / _readyAction.getIntervalMs());
      _readyAction.line1="Update Media is not Detected";
      _readyAction.line2=std::string("System will ")  + " " + _readyAction.actionToString() +" in another _INTERVALS_LEFT_ minutes";
      displayReadyMsg();
      _finalizeTimer.start(this, _readyAction.getIntervalMs());



      // FIXME: Not sure if this is the right place to do it
      // In FullOp this is done by the LCM. Since there is no LCM in Recovery, it is done by the fcswupdate
   }
   else {
      ETG_TRACE_USR1(("FcSwUpdProjectSpecific::enter Idle"));
      CampaignManager::instance()->vEnterStateIdle();
   }

   if (etg_bIsTraceActive(TR_CLASS_FCSWUPDATE_MAIN, 5)) {
      ETG_TRACE_USR1(("FcSwUpdCore::vInit: traceState ..."));
      //      _memberList.traceState(getName());
   }
   ETG_TRACE_COMP(("FcSwUpdCore::vInit END idle=%d", bIsIdle()));

   
}

tVoid FcSwUpdCore::vPreparePersistentFile(std::string defaultFile, std::string persistentFile) const {
   ETG_TRACE_USR1(("vPreparePersistentFile) %100s --> %s START", defaultFile.c_str(), persistentFile.c_str()));
   if (!swu::exists(persistentFile)) {

      ETG_TRACE_USR1(("vPrepareDefaults! %100s --> %s", defaultFile.c_str(), persistentFile.c_str()));
      SWU_ASSERT_RETURN(swu::copyFile(defaultFile, persistentFile));
      bool result;
      SWU_ASSERT_RETURN(swu::isFile(persistentFile, result) && result);
      swu::RobustFile rf(persistentFile);
      rf.init();
      rf.sync();
   }

}


tVoid FcSwUpdCore::vEnterUpdate(tenSwUpdateMode enMode, Configurator *configurator) {
   // todo: check state and create matching configurator
   ETG_TRACE_USR1(("FcSwUpdCore:vEnterUpdate"));
   CampaignManager::instance()->vEnterStateConfig(enMode, configurator);
}

ParserIf *FcSwUpdCore::createParser(trSourceInfo const &sourceInfo) {
   ParserIf * parser = 0;
   tenSwUpdateMode enUpdateMode = CampaignManager::instance()->enGetUpdateMode();
   ParserConfig parserConfig;

   if (enUpdateMode == tenSwUpdateMode_Engineering) {
      ETG_TRACE_USR4(("FcSwUpdCore::createParser: Mode_Engineering"));
      ETG_TRACE_USR4(("FcSwUpdCore::createParser: Bosch parser"));
      parser = new BoschParser();
   } else if (sourceInfo.enSourceType == tenSourceType_SCOMO_INDEX) {
      /*
        todo: this has to come from project-specific hook.
      */
      ETG_TRACE_USR4(("FcSwUpdCore::createParser: force Bosch parser for tenSourceType_SCOMO_INDEX"));
      parser = new BoschParser();
   } else {
      ETG_TRACE_USR4(("FcSwUpdCore::createParser: NOT Mode_Engineering"));
      swu::tenParserType parserType = static_cast<swu::tenParserType>(Config::instance()->cfg_ParserType.get());
      switch( parserType ) {
         case swu::ParserTypeBosch:
            ETG_TRACE_USR4(("FcSwUpdCore::createParser: Bosch parser"));
            parser = new BoschParser();
            break;
         case swu::ParserTypeCMS:
            ETG_TRACE_USR4(("FcSwUpdCore::createParser: CMS parser"));
            parser = new CMSParser();
            break;
      }
      parserConfig.useEncryption=Config::instance()->cfg_ParserUseEncryption.get();
   }
   if (!parser) {
      ETG_TRACE_ERR(("FcSwUpdCore::createParser: Creation failed."));
      return 0;
   }
   parser->configure(parserConfig);
   return parser;
}

void FcSwUpdCore::getReleaseList(std::list < TiXmlElement > &relList,
                                 trSourceInfo const &sourceInfo,
                                 tenSwUpdateError *errorCode) {
   tenSwUpdateError dummy;
   if (!errorCode) {
      errorCode = &dummy;
   }

   ParserIf *prjParser = poGetProjectSpecific()->createPrjParser(sourceInfo);
   if(prjParser != NULL) {      
      prjParser->getReleaseList(sourceInfo, errorCode);
      delete prjParser;

      if(*errorCode != tenSwUpdateError_OK) {
         return;
      }
   }
   
 
   //jha1kor
   ParserIf *parser = this->createParser(sourceInfo);
   parser->setSrcFilters(&_srcXmlFilters);
   parser->setPreFilters(&_bxmlFilters);
   parser->setPostFilters(&_releaseFilters);

   relList = parser->getReleaseList(sourceInfo, errorCode);
   delete parser;
}


void FcSwUpdCore::addReleaseFilter(ReleaseFilterIf *filter, bool first) {
   _releaseFilters.add(filter, first);
}

void FcSwUpdCore::removeReleaseFilter(std::string filterName) {
   _releaseFilters.remove(filterName);
}

void FcSwUpdCore::activateReleaseFilter(std::string filterName, bool doActivate) {
   _releaseFilters.activate(filterName, doActivate);
}

void FcSwUpdCore::addBxmlFilter(ReleaseFilterIf *filter, bool first) {
   _bxmlFilters.add(filter, first);
}

void FcSwUpdCore::removeBxmlFilter(std::string filterName) {
   _bxmlFilters.remove(filterName);
}


TiXmlDocument *FcSwUpdCore::getReleaseXml(TiXmlElement const &overallSection,
         tenSwUpdateError &errorCode, size_t id) {
   (void) id;
   TiXmlDocument *xmlRes = 0;
   //jha1kor
   std::string mediumPath = swu::getTextFromChildOrEmpty(&overallSection, "MEDIUM_DRIVE");
   trSourceInfo sourceInfo=PropDevMgr::instance()->getSourceInfo(mediumPath);

   ParserIf *parser = this->createParser(sourceInfo);
   parser->setSrcFilters(&_srcXmlFilters);
   parser->setPreFilters(&_bxmlFilters);
   parser->setPostFilters(&_releaseFilters);
   if (!parser->setOverallSection(overallSection)) {
      ETG_TRACE_ERR(("FcSwUpdCore::getReleaseXml no overallSection"));
      errorCode = parser->getParserError();
      delete parser;
      return xmlRes;
   }

   xmlRes = parser->getReleaseXml();
   errorCode=parser->getParserError();
   ETG_TRACE_USR4(("FcSwUpdCore::getReleaseXml errorCode =%u", errorCode));
   delete parser;
   if (!xmlRes) {
      ETG_TRACE_USR1(("FcSwUpdCore::getReleaseXml NO Release XML found, errorCode =%u", errorCode));
      return xmlRes;
   }


   ETG_TRACE_USR4(("FcSwUpdCore::getReleaseXml DONE"));
   return xmlRes;
}


tBool FcSwUpdCore::bIsIdle() {
   return CampaignManager::instance()->bIsIdle();
}

tVoid FcSwUpdCore::vProcess(Msg_CvmEventStatus *pMsg) {
   ETG_TRACE_COMP(("FcSwUpdCore:vProcess(Msg_CvmEventStatus)"));
   (void) pMsg;
   // todo: handling of under-voltage
}


tVoid FcSwUpdCore::vProcess(Msg_FinalizeTimeout *pMsg) {
   (void) pMsg;
   ETG_TRACE_COMP(
            ("FcSwUpdCore:vProcess(Msg_FinalizeTimeout) readyAction=%u", ETG_CENUM(
                              tenCtrlReadyAction, _readyAction.enAction)));

   (void) pMsg;
   if (_readyAction.u32NumIntervals) {
      _readyAction.u32NumIntervals--;
   }
   if (_readyAction.u32NumIntervals) {
      displayReadyMsg();
      // just update display
      _finalizeTimer.start(this, _readyAction.getIntervalMs());
   }
   else {
      if (_readyAction.clearOnDone) {
         _readyAction.line1="";
         _readyAction.line2="";
         displayReadyMsg();
      }

      switch (_readyAction.enAction) {
         case enCtrlReadyAction_reboot:
            SpmIf::instance()->reboot();
            break;
         case enCtrlReadyAction_shutdown:
            SpmIf::instance()->shutdown();
            break;
         case enCtrlReadyAction_idle:
            SpmIf::instance()->resetV850IfNeeded();
            if (!Config::instance()->cfg_EnterEngineering.readAsBool()) {
               CampaignManager::instance()->vEnterStateIdle();
            }
            break;
         case enCtrlReadyAction_enterPreResult:{
            CampaignManager::instance()->vEnterStatePreResult();
            break;
         }
      }
   }
}

tVoid FcSwUpdCore::vProcess(Msg_NotifyCtrlResult *pMsg) {
   tenSwUpdateMode enUpdateMode = CampaignManager::instance()->enGetUpdateMode();
   // maybe better put this to ctrl-adapter, but this handling should be generic for every recovery-ctrl-adapter
   if(pMsg->_result)
   {
      if(enUpdateMode!=tenSwUpdateMode_Hmi)
      {
         // In FullOp this is done by the LCM. Since there is no LCM in any other mode, it is done by the fcswupdate
         SpmIf::instance()->clearResetCounter();
      }


      //todo: rename tenSwUpdateMode_Emergency to tenSwUpdateMode_Recovery
      if(enUpdateMode==tenSwUpdateMode_Emergency)
      {
         // marker for full-operation
         Config::instance()->cfg_RevoveryPassed.setFromBool(true);
         // remove the persistent marker
         Config::instance()->cfg_ForceShutdownRequested.setFromBool(false);
         ::sync();
      }
      //todo: rename tenSwUpdateMode_Emergency to tenSwUpdateMode_Developer
      else if(enUpdateMode==tenSwUpdateMode_Engineering)
      {
         // If this is an TFTP update notify the DLTool that the update succeeded
         if(Config::instance()->cfg_EnterEngineering.readAsBool())
         {
            std::string tftpServerIp;
            if (Config::instance()->cfg_TftpServerIpAdr.get(tftpServerIp))
            {
               ETG_TRACE_USR1(("FcSwUpdCore::vProcess(Msg_CtrlReady) notifying DLTool about success"));
//               std::string cmd="tftp -g -r TftpJobEnd -l /tmp/TftpJobEnd " + tftpServerIp + " 2>&1 > /dev/null";
               std::string cmd="swu_common_tftp_client_out.out -f TftpJobEnd -i " + tftpServerIp + " 2>&1 > /dev/null";
               system(cmd.c_str());
            }
         }
      }
   }
   else
   {
      // If this is an TFTP update notify the DLTool that the update failed
      if(Config::instance()->cfg_EnterEngineering.readAsBool())
      {
         std::string tftpServerIp;
         if (Config::instance()->cfg_TftpServerIpAdr.get(tftpServerIp))
         {
            ETG_TRACE_USR1(("FcSwUpdCore::vProcess(Msg_CtrlReady) notifying DLTool about failure"));
            std::string cmd="swu_common_tftp_client_out.out -e \"Failed to update the device\" -i " + tftpServerIp + " 2>&1 > /dev/null";
            system(cmd.c_str());
         }
      }
   }

   bool success = (pMsg->_result);
   if (enUpdateMode == tenSwUpdateMode_Emergency) {
      Config::instance()->cfg_RevoveryPassed.setFromBool(success);
      // remove the persistent marker
   }   // Merge error ???
}

tVoid FcSwUpdCore::vProcess(Msg_ResetFcSwUpdCore *pMsg) {
   ETG_TRACE_COMP(("FcSwUpdCore:vProcess(Msg_ResetFcSwUpdCore)"));
   (void) pMsg;
   bool file_exists;
   if (!swu::exists(Config::getProgressFileName().c_str(), file_exists)) {
      SWU_ASSERT_RETURN_ALWAYS();
   }

   if (file_exists) {
      swu::RobustFile rf(Config::getProgressFileName().c_str());
      rf.init();
      rf.remove();
   }

   SpmIf::instance()->requestSystemModeDl(false);

   CampaignManager::instance()->vEnterStateIdle();
}

tVoid FcSwUpdCore::vProcess(Msg_ResetFactorySettings *pMsg) {
   ETG_TRACE_COMP(("FcSwUpdCore:vProcess(Msg_ResetFactorySettings)"));
   (void) pMsg;

   swu::ScopedPointer<History> h(History::instance());
   h->vInit();
   if( h->getNumReleases() > 0 ){
		h->clear();
   }
}


ETG_I_CMD_DEFINE((resetUpdate, "clearProgress"))
ETG_I_CMD_DEFINE((resetUpdate, "resetUpdate"))
void FcSwUpdCore::resetUpdate() {
   ETG_TRACE_COMP(("FcSwUpdCore::resetUpdate"));
   Msg_ResetFcSwUpdCore msg;
   notify(msg);
}

ETG_I_CMD_DEFINE((simResetFactorySettings, "simResetFactorySettings"))
void FcSwUpdCore::simResetFactorySettings()
{
   ETG_TRACE_COMP(("FcSwUpdCore::ResetFactorySettings"));
   Msg_ResetFactorySettings msg;
   notify(msg);
}


ETG_I_CMD_DEFINE((simStoreHistory, "simStoreHistoryAll %80s", ETG_I_STRING, ETG_I_CONST_ARG(0)))
ETG_I_CMD_DEFINE((simStoreHistory, "simStoreHistorySinceReset %80s", ETG_I_STRING, ETG_I_CONST_ARG(1)))
void FcSwUpdCore::simStoreHistory(const char *path, bool sinceReset)
{
   ETG_TRACE_COMP(("FcSwUpdCore::simStoreHistory START (path %s)", path));
   ETG_TRACE_USR4(("FcSwUpdCore::simStoreHistory (sinceReset %u)", (int)sinceReset));

   std::string fullPath(path);
   if (!swu::isAbsolutePath(fullPath)) { // Write to media root (if any)
      std::map< std::string, trSourceInfo > &mapSources = PropDevMgr::instance()->access()._mapSources;
      std::map< std::string, trSourceInfo >::iterator iter = mapSources.begin();
      for ( ; iter != mapSources.end(); ++iter) {
         trSourceInfo &medium = iter->second;
         if (medium.enSourceType == tenSourceType_USB || medium.enSourceType == tenSourceType_SD) {
            break;
         }
      }

      if (iter != mapSources.end()) {
         trSourceInfo &info = iter->second;
         std::string realPath = swu::realPath(info.path);
         ETG_TRACE_COMP(("  MountPoint=%s", info.path.c_str()));
         ETG_TRACE_COMP(("    path=%s", realPath.c_str()));
         ETG_TRACE_COMP(("    name=%s", info.name.c_str()));
         ETG_TRACE_COMP(("    sourceType=%u", ETG_CENUM(tenSourceType, info.enSourceType)));

         std::string cmd = "mount -o rw,remount " + realPath;
         if (swu::execCommand(cmd.c_str())) {
            ETG_TRACE_ERR(("  cmd failed:%s", cmd.c_str()));
            return;
         }

         fullPath = realPath + "/" + fullPath;
      } else {
         ETG_TRACE_ERR(("  No removable media found"));
         return;
      }
   }

   swu::ScopedPointer<History> h(History::instance());
   h->vInit();
   bool status = h->store(fullPath.c_str(), sinceReset);
   ETG_TRACE_USR4(("simStoreHistory::status = %u", (int)status));
}

ETG_I_CMD_DEFINE((simSwitchBootSectors, "simSwitchBootSectors"))
void FcSwUpdCore::simSwitchBootSectors() {
   ETG_TRACE_COMP(("simSwitchBootSectors - START"));
   swu::BootChainAccess<swu::rcarBootChain>::switchBootSectors();  
   ETG_TRACE_COMP(("simSwitchBootSectors - END"));
}

ETG_I_CMD_DEFINE((simWriteMagicToActiveSector, "simWriteMagicToActiveSector %u %u", tU32, tU32))
void FcSwUpdCore::simWriteMagicToActiveSector(tU32 address, tU32 value) {
   ETG_TRACE_COMP(("simWriteMagicToActiveSector - START"));
   swu::BootChainAccess<swu::rcarBootChain>::writeMagicToActiveSector(address, value);  
   ETG_TRACE_COMP(("simWriteMagicToActiveSector - END"));
}


ETG_I_CMD_DEFINE((simUsedBootChain, "simUsedBootChain"))
void FcSwUpdCore::simUsedBootChain() {
   ETG_TRACE_COMP(("simUsedBootChain - START"));
   tU32 activeChain;
   swu::BootChainAccess<swu::rcarBootChain>::usedBootChain(activeChain);  
   ETG_TRACE_COMP(("simUsedBootChain - END:chain:%u", activeChain));
}

ETG_I_CMD_DEFINE((simActivateRecoveryMode, "simActivateRecoveryMode"))
void FcSwUpdCore::simActivateRecoveryMode() {
   ETG_TRACE_COMP(("simActivateRecoveryMode - START"));
   swu::BootChainAccess<swu::rcarBootChain>::activateRecoveryMode(); 
   ETG_TRACE_COMP(("simActivateRecoveryMode - END"));
}

ETG_I_CMD_DEFINE((simActivateApplicationMode, "simActivateApplicationMode"))
void FcSwUpdCore::simActivateApplicationMode() {
   ETG_TRACE_COMP(("simActivateApplicationMode - START"));
   swu::BootChainAccess<swu::rcarBootChain>::activateApplicationMode(); 
   ETG_TRACE_COMP(("simActivateApplicationMode - END"));
}



ETG_I_CMD_DEFINE((simDumpBootChainConfig, "simDumpBootChainConfig"))
void FcSwUpdCore::simDumpBootChainConfig() {
   ETG_TRACE_COMP(("simDumpBootChainConfig - START"));
   swu::BootChainAccess<swu::rcarBootChain>::dumpBootChainConfig(); 
   ETG_TRACE_COMP(("simDumpBootChainConfig - END"));
}



ETG_I_CMD_DEFINE((simTestBxmlFilter, "simTestBxmlFilter %80s", ETG_I_STRING))
void FcSwUpdCore::simTestBxmlFilter(const char *path_xml)
{
   ETG_TRACE_COMP(("FcSwUpdCore::simTestBxmlFilter START"));

   TiXmlDocument *doc = new TiXmlDocument(path_xml);
   if (!doc->LoadFile())
   {
      const char *errorDesc = doc->ErrorDesc();
      int row = doc->ErrorRow();
      int col = doc->ErrorCol();
      ETG_TRACE_ERR(("simTestBxmlFilter: Could not load bosch.xml from %s", path_xml));
      ETG_TRACE_ERR(("Reason: %s", errorDesc));
      ETG_TRACE_ERR(("Error at row: %d", row));
      ETG_TRACE_ERR(("Error at col: %d", col));
   }
   else
   {
      ReleaseFilterChain filters;
      filters.add(new BxmlFilterBaseNodes);
      filters.add(new BxmlFilterMatch("FCIDS", Config::instance()->cfg_FcIdStr.get()));
      filters.add(new BxmlFilterMatch("BOARDIDS", Config::instance()->cfg_BoardId.get()));
      filters.add(new SxmTypeFilter());
      filters.add(new UpdateXmlFilter);
      filters.add(new BxmlFilterExtraArgs()/*, true*/);
      filters.add(new ReleaseFilterCheckSRK);
      ReleaseFilterContext context;

      tenSwUpdateError errorCode = filters.apply(doc, context);
      ETG_TRACE_USR4(("ReleaseFilterChain::apply errorCode = %u", errorCode));

      if (!doc->SaveFile("/tmp/BxmlFilterResult.xml"))
         ETG_TRACE_ERR(("simTestBxmlFilter: Could not save filtered file"));
   }

   delete doc;

   ETG_TRACE_COMP(("FcSwUpdCore::simTestBxmlFilter END"));
}

ETG_I_CMD_DEFINE((simTestXmlFilter, "simTestXmlFilter %80s", ETG_I_STRING))
void FcSwUpdCore::simTestXmlFilter(const char *path_xml)
{
   ETG_TRACE_COMP(("FcSwUpdCore::simTestXmlFilter START"));

   XMLFilterChain filters;
   filters.add(new XMLFilterMatch("FCIDS", Config::instance()->cfg_FcIdStr.get()));
   ReleaseFilterContext context;
   
   tenSwUpdateError errorCode = filters.apply(path_xml, context);
   ETG_TRACE_USR4(("ReleaseFilterChain::apply errorCode = %u", errorCode));     

   ETG_TRACE_COMP(("FcSwUpdCore::simTestXmlFilter END"));
}



ETG_I_CMD_DEFINE((simSegmentationFault, "simSegmentationFault"))
void FcSwUpdCore::simSegmentationFault() {
   ETG_TRACE_COMP(("FcSwUpdCore::simSegmentationFault"));
   swu::forceSegmentationFault();
}

ETG_I_CMD_DEFINE((simGlobalLogFailure, "simGlobalLogFailure"))
void FcSwUpdCore::simGlobalLogFailure() {
   ETG_TRACE_COMP(("FcSwUpdCore::simGlobalLogFailure"));
   swu::LOG_FAILURE("Test Failure Log");
}

ETG_I_CMD_DEFINE((simGlobalLogInterface, "simGlobalLogInterface"))
void FcSwUpdCore::simGlobalLogInterface() {
   ETG_TRACE_COMP(("FcSwUpdCore::simGlobalLogInterface"));

   swu::LOG_INTERFACE("Test Interface Log");

   std::string text = "test";
   tU16 u16text = 100;
   swu::LOG_INTERFACE("stringFormatTest:%s intFormatTest:%u", text.c_str(), u16text);   
   swu::LOG_INTERFACE("intFormatTest:%u", u16text);
}


void FcSwUpdCore::requestRebootForRecovery() {
   ETG_TRACE_COMP(("FcSwUpdCore::requestRebootForRecovery START"));
   // ToDo(efs1hi): We need to ensure that we come back in Recovery after Reboot. Therefore we need to set the Magics.
   //               The question is, if this is necessary or of this is always done by the scripts...
   Config::instance()->cfg_EnterRecovery.setFromBool(true, true);
   ETG_TRACE_COMP(("FcSwUpdCore::requestRebootForRecovery: reboot!"));
   SpmIf::instance()->reboot();
}


void FcSwUpdCore::displayReadyMsg() {
   ETG_TRACE_USR4(("FcSwUpdCore::displayReadyMsg(): START"));

   ProgressInformation &progress=PropProgress::instance()->access().progress;
   progress.line1=_readyAction.line1;
   progress.line2=_readyAction.line2;
   std::string intervalsLeft=swu::intToString(_readyAction.u32NumIntervals);
   swu::replaceSubString(progress.line1, "_INTERVALS_LEFT_",intervalsLeft);
   swu::replaceSubString(progress.line2, "_INTERVALS_LEFT_",intervalsLeft);
   ETG_TRACE_USR1(("%s", progress.line1.c_str()));
   ETG_TRACE_USR1(("%s", progress.line2.c_str()));
   PropProgress::instance()->iNotify(this);
   ETG_TRACE_USR4(("FcSwUpdCore::displayReadyMsg(): END"));
}







ETG_I_CMD_DEFINE((getDistTotal, "getDistTotal"))
tU32 FcSwUpdCore::getDistTotal() {
   ETG_TRACE_USR1(("FcSwUpdCore::getDistTotal: START"));
   tU32 distTotal=getIfOrDefault<DistTotalizerIf>()->getDistTotal();
   ETG_TRACE_USR1(("FcSwUpdCore::getDistTotal: END distTotal=%u", distTotal));
   return distTotal;
}

ETG_I_CMD_DEFINE((getLocalTime, "getLocalTime"))
swu::LocalTime FcSwUpdCore::getLocalTime() {
   ETG_TRACE_USR1(("FcSwUpdCore::getLocalTime: START"));
   swu::LocalTime localTime;
   getIfOrDefault<LocalTimeIf>()->getLocalTime(localTime);
   ETG_TRACE_USR1(("FcSwUpdCore::getLocalTime: END localTime=%s", localTime.toString().c_str()));
   return localTime;
}

bool LocalTimeIf::getLocalTime(swu::LocalTime &lc) { 
   lc=swu::LocalTime(); 
   return true;
};


ETG_I_CMD_DEFINE((getTestPluginIfDummyVal, "getTestPluginIfDummyVal"))
tUInt FcSwUpdCore::getTestPluginIfDummyVal() {
   ETG_TRACE_USR1(("FcSwUpdCore::getTestPluginIfDummyVal: START"));
   tUInt dummyVal=0;
   TestPluginIf *testPluginIf=getIf<TestPluginIf>();
   if (testPluginIf) {
      dummyVal=testPluginIf->getDummyValue();
      ETG_TRACE_USR1(("FcSwUpdCore::getTestPluginIfDummyVal: dummyVal=%i", dummyVal));
   }
   else {
      ETG_TRACE_USR1(("FcSwUpdCore::getTestPluginIfDummyVal: could not get Interface"));
   }
   return dummyVal;
}

ETG_I_CMD_DEFINE((getTestDynPluginIfDummyVal, "getTestDynPluginIfDummyVal"))
tUInt FcSwUpdCore::getTestDynPluginIfDummyVal() {
   ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPluginIfDummyVal: START"));
   tUInt dummyVal=0;
   TestDynPluginIf *testPluginIf=getIf<TestDynPluginIf>();
   if (testPluginIf) {
      dummyVal=testPluginIf->getDummyValue();
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPluginIfDummyVal: dummyVal=%i", dummyVal));
   }
   else {
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPluginIfDummyVal: could not get Interface"));
   }
   return dummyVal;
}

ETG_I_CMD_DEFINE((getTestDynPlugin2IfDummyVal, "getTestDynPlugin2IfDummyVal"))
tUInt FcSwUpdCore::getTestDynPlugin2IfDummyVal() {
   ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin2IfDummyVal: START"));
   tUInt dummyVal=0;
   TestDynPlugin2If *testPluginIf=getIf<TestDynPlugin2If>();
   if (testPluginIf) {
      dummyVal=testPluginIf->getDummyValue();
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin2IfDummyVal: dummyVal=%i", dummyVal));
   }
   else {
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin2IfDummyVal: could not get Interface"));
   }
   return dummyVal;
}

ETG_I_CMD_DEFINE((getTestDynPlugin3IfDummyVal, "getTestDynPlugin3IfDummyVal"))
tUInt FcSwUpdCore::getTestDynPlugin3IfDummyVal() {
   ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin3IfDummyVal: START"));
   tUInt dummyVal=0;
   TestDynPlugin3If *testPluginIf=getIf<TestDynPlugin3If>();
   if (testPluginIf) {
      dummyVal=testPluginIf->getDummyValue();
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin3IfDummyVal: dummyVal=%i", dummyVal));
   }
   else {
      ETG_TRACE_USR1(("FcSwUpdCore::getTestDynPlugin3IfDummyVal: could not get Interface"));
   }
   return dummyVal;
}


ETG_I_CMD_DEFINE((activatePlugins, "activatePlugins"))
void FcSwUpdCore::activatePlugins() {
   swu::PluginManager<FcSwUpdRoot>::instance()->execute(&_memberList);
}


// e.g. libfcswupdate_plugin_dyn_test_so.so
ETG_I_CMD_DEFINE((loadPlugin, "loadPlugin %s", ETG_I_STRING))
bool FcSwUpdCore::loadPlugin(char const *pluginName) {
   SWU_ASSERT_RETURN_FALSE(pluginName);
   return swu::PluginManager<FcSwUpdRoot>::instance()->loadDynPlugin(std::string(pluginName));
}



void FcSwUpd_tracePtr(std::string str, void *val) {
   // ETG_TRACE_USR1(("XXX: %100s%u", str.c_str(), (tU32)val));
 
}

}
