#include "util/swu_execCommand.h"
#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include <fstream>
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_isoMounter.h"

#define FCSWUPD_UPDATE_FILENAME "update.iso"
#define MOUNT_OUT "/tmp/robust_mount_out"
#define UMOUNT_OUT "/tmp/robust_umount_out"
#define ISO_MOUNTS_BASE "/tmp/fcswupdate/isoMounts"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_isoMounter.cpp.trc.h"
#endif 

namespace fcswupdate {

IsoMounter::IsoMounter():
   _numIsoMountAttemps(0) {
}

IsoMounter::~IsoMounter() {
   vDeInit();
}


void IsoMounter::vInit() {
   Config *cfg=Config::instance();
   ETG_TRACE_COMP(("IsoMounter::vInit"));
   if (!cfg->cfg_UpdateIsoFileName.get().empty()) {
      ETG_TRACE_COMP(("IsoMounter::vInit(): vSubscribe"));
      Msg_NotifyDevManagerChanged::vSubscribe(this, true);
   }
}




void IsoMounter::vDeInit() {
   ETG_TRACE_COMP(("IsoMounter::vDeInit"));
   Msg_NotifyDevManagerChanged::vUnSubscribe(this);
   for (std::map<std::string, swu::IsoContainer *>::iterator iter=_mapIsoContainers.begin();
        iter!=_mapIsoContainers.end();
        ++iter) {
      delete iter->second;
   }
}








void IsoMounter::traceState() {
   ETG_TRACE_COMP(("   _numIsoMountAttemps=%u", _numIsoMountAttemps));
}




bool IsoMounter::addIsoMount(trSourceInfo const & sourceInfo, trSourceInfo & isoSourceInfo, std::string const &updateIsoPathAndName) {
   // we found a new iso-mount
   // use same source-type as source of normal mount
   isoSourceInfo.enSourceType=sourceInfo.enSourceType;
   isoSourceInfo.owner=getName();
   isoSourceInfo.path=std::string(ISO_MOUNTS_BASE) + "/" + swu::intToString(_numIsoMountAttemps);
   isoSourceInfo.name=sourceInfo.name;
   isoSourceInfo.bHasCustomerUpdate=false;
   isoSourceInfo.bDeleted=false;
   isoSourceInfo.bNew=true;
   // we found an unmounted iso-container
   swu::IsoContainer *isoContainer=new swu::IsoContainer(isoSourceInfo.path, updateIsoPathAndName);
   if (!isoContainer->mount()) {
      delete isoContainer;
      swu::removeDirectoryRecursive(isoSourceInfo.path);
      return false;
   }
   _numIsoMountAttemps++;
   _mapIsoContainers[isoSourceInfo.path]=isoContainer;
   return true;

}


void IsoMounter::removeIsoMount(trSourceInfo & isoSourceInfo) {
   swu::IsoContainer *isoContainer=0;
   if (_mapIsoContainers.find(isoSourceInfo.path) == _mapIsoContainers.end()) {
      ETG_TRACE_ERR(("IsoMounter::removeIsoMount() not registered: %s", isoSourceInfo.path.c_str()));
   }
   isoContainer=_mapIsoContainers[isoSourceInfo.path];

   delete isoContainer;
   _mapIsoContainers.erase(isoSourceInfo.path);

   swu::removeDirectoryRecursive(isoSourceInfo.path);
}


/*
  we are the first who is notified.
  only when something has changed, also a change in the iso-mounts is possible.
  So we don't have to notify explicitely.
*/
tVoid IsoMounter::vProcess(Msg_NotifyDevManagerChanged *pMsg) {
   ETG_TRACE_COMP(("IsoMounter::vProcess(Msg_NotifyDevManagerChanged) START"));

   Config *cfg=Config::instance();
   std::string updateIsoFileName=cfg->cfg_UpdateIsoFileName.get();

   // iterate all sources
   std::map<std::string, trSourceInfo> &sourcesList=PropDevMgr::instance()->access()._mapSources;
   for (std::map<std::string, trSourceInfo>::iterator iterSrc= sourcesList.begin();
        iterSrc!=sourcesList.end(); /* no increment here! */) {
      trSourceInfo source=iterSrc->second;      
      //      std::string updateFolder=source.path + "/" + cfg->cfg_AlternativeUpdatePath.get() + "/";
      //      std::string updateIsoPathAndName=swu::realpath(updateFolder + updateIsoFileName);
      
      std::string updateIsoPathAndName=source.path + "/" + cfg->cfg_AlternativeUpdatePath.get() + "/" + updateIsoFileName;
      ETG_TRACE_COMP(("IsoMounter::check updateIsoPathAndName=%s", updateIsoPathAndName.c_str()));

      if (source.enSourceType!=tenSourceType_USB && source.enSourceType!=tenSourceType_SD) {
         ETG_TRACE_COMP(("IsoMounter::wrong source-type=%u", source.enSourceType));
         // we are only interested in USB-sources
         ++iterSrc;
         continue;
      }
      ETG_TRACE_COMP(("IsoMounter::check owner: me=%50s got=%s", 
                      getName(), source.owner.c_str()));
      if (source.owner==getName()) {
         ETG_TRACE_COMP(("IsoMounter::owner == me"));

         // this is an already existing iso-mount
         if (!swu::exists(updateIsoPathAndName)) {
            ETG_TRACE_COMP(("IsoMounter::not lost: updateIsoPathAndName=%s", 
                            updateIsoPathAndName.c_str()));
            // iso-file is no longer ther
            removeIsoMount(source);
            sourcesList.erase(iterSrc++);
            continue;
         }
         ETG_TRACE_COMP(("IsoMounter::still existing: updateIsoPathAndName=%s", 
                         updateIsoPathAndName.c_str()));
         ++iterSrc;
         continue;
      }
      if (!swu::exists(updateIsoPathAndName)) {
         ETG_TRACE_COMP(("IsoMounter::not found: updateIsoPathAndName=%s", 
                         updateIsoPathAndName.c_str()));
         // no iso-file found in this folder
         source.bNew=false;
         ++iterSrc;
         continue;
      }

      trSourceInfo isoSourceInfo;
      if (addIsoMount(source, isoSourceInfo, updateIsoPathAndName)) {
         ETG_TRACE_COMP(("IsoMounter::adding: isoSourceInfo.path=%s", 
                         isoSourceInfo.path.c_str()));

         //remove the old sources
         //configurator overrides the error.
         sourcesList.erase(iterSrc++);

         // add the new mount to sources-list
         sourcesList[isoSourceInfo.path]=isoSourceInfo;
         continue;
      }
   }
   

}

}

