/*
 * fcswupd_hmisettings.h
 *
 *  Created on: May 31, 2016
 *      Author: vri7cob
 */

#ifndef FCSWUPD_HMISETTINGS_H_
#define FCSWUPD_HMISETTINGS_H_

#include "util/swu_singleton.hpp"
#include "util/swu_msg.hpp"
#include "util/swu_asfUtil.hpp"
#include "util/swu_memberList.hpp"
#include "util/fcswupd_types.hpp"
#include "tinyxml/tinyxml.h"


//Variant

#define NISSAN_VARIANT_OEM 		    0x06
#define RENAULT_VARIANT_OEM 		0x08
#define SUZUKI_VARIANT_OEM			0x0C
#define PSA_VARIANT_OEM			    0x0E
#define INFINITI_VARIANT_OEM	    0x16

//Orientation
#define LANDSCAPE_ORIENTATION 		0x00
#define PORTRAIT_ORIENTATION  		0x01

//Font File Location in Normal Mode
#define SOURCE_FONTFILE_LOCATION			"/opt/bosch/base/bin/font_resources/"

namespace fcswupdate {

class hmisettings :
  public swu::Singleton<hmisettings>,
  public swu::Member<FcSwUpdRoot>
{
  friend class swu::Singleton<hmisettings>;
 public:
  hmisettings();
  virtual tVoid vInit();
  virtual tVoid vDeInit();

  virtual ~hmisettings();
  virtual void traceState() { };
  virtual const char *getName() { return "hmisettings"; }

  //hmisettings
  tVoid vUpdateLanguageName(std::string strLangName);
  tVoid vStoreHMISettings();
  tVoid vSetProgressBarPath(std::string pbarpath);

  //simulate
  void simDohmiSettingsFilepersist();

 private:
  tVoid vPrepareHMISettings();
  tBool vCopyFontFile(std::string strLangName);
  tVoid vUpdateDefaultSettings();
  tVoid vUpdateTargetSettings();

  bool  bDohmiSettingsFilepersist();
  tVoid vDeleteAndCreateHMIDir();

  static const ::std::string TTF_SUFFIX() { return "ttf"; }
  static const ::std::string OTF_SUFFIX() { return "otf"; }
  static const ::std::string XML_SUFFIX() { return "xml"; }

 private:
   TiXmlDocument 	_settingsdoc;
   TiXmlElement*	_psettingsroot;
   TiXmlElement* 	_pLangSettings;

};

} /* namespace fcswupdate */
#endif /* FCSWUPD_HMISETTINGS_H_ */
