#include "util/swu_util.hpp"
#include "main/fcswupd_component.h"
#include "main/fcswupd_main.h"
#include "main/fcswupd_diagLog.h"


#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_diagLog.cpp.trc.h"
#endif


namespace fcswupdate {
  
bool DiagLogItem::operator<(DiagLogItem const &r) const {
   return _itc < r._itc;
}


DiagLogItem::~DiagLogItem() {
   if (_itc) {
      DiagLog::instance()->unregisterItem(this);
   }
   _name=0;
}


bool  DiagLogItem::init(char const *name, tUInt itc, tenResultCode enResCode) {
   _name=name;
   bool res=setItc(itc);
   if (res && (enResCode != DiagLogItem::enResultCode_Invalid)){
      vSetResult(enResCode);
   } 
   return res;
}

// store test-result without informing diaglog
bool  DiagLogItem::setItc(tUInt itc) {
   if (!itc) {
      return false;
   }
   _itc=itc;
   return DiagLog::instance()->registerItem(this);
   
   return true;
}


// store test-result without informing diaglog
void  DiagLogItem::vSetResult(DiagLogItem::tenResultCode enResultCode, tBool bForced) {
   _resultCode=enResultCode;
   if (bForced) {
      _resultCodeSent=DiagLogItem::enResultCode_Invalid;
   }
}

// send test-result if result-code has changed or forced is set.
void  DiagLogItem::vSendResult(DiagLogItem::tenResultCode enResultCode, tBool bForced) {
   vSetResult(enResultCode, bForced);
   if (!_itc) {
      return;
   }
   if (_resultCode!=_resultCodeSent) {
      DiagLog::instance()->vSendTestResults();
   }
}


tVoid DiagLog::vInit() {
   Msg_SaveTestResultResult::vSubscribe(this);
   Msg_SendNextTestResultStatus::vSubscribe(this);
}


void DiagLog::traceState() {
   ETG_TRACE_COMP(("  _mapTroubleCodes:"));
   for (std::map<tUInt, DiagLogItem *>::iterator iter =_mapItems.begin();
        iter != _mapItems.end(); ++iter) {
      tUInt itc= iter->first;
      DiagLogItem *item=iter->second;
      ETG_TRACE_COMP(("name=%10s result=%u",
                      item->_name,
                      ETG_CENUM(DiagLogItem::tenResultCode, item->_resultCode)));
   }
}


tVoid DiagLog::vProcess(Msg_SaveTestResultResult *pMsg) {
   ::boost::shared_ptr<FCSWUPD_NS_DIAGLOG::SaveTestResultResult> pMRes = pMsg->payload;
   ETG_TRACE_COMP(("vProcess(Msg_SaveTestResultResult): result=%d",
                   pMRes->getStatus()));
}

tVoid DiagLog::vProcess(Msg_SendNextTestResultStatus *pMsg) {
   ::boost::shared_ptr<FCSWUPD_NS_DIAGLOG::SendNextTestResultStatus> pStatus = pMsg->payload;
    ETG_TRACE_COMP(("vProcess(Msg_SendNextTestResultStatus): result=%d", pStatus->getStatus()));
   if (pStatus->getStatus()) {
      vSendTestResults(TRUE);
   }

}
// send test-results (pending changes or all if bForced is set)
tVoid DiagLog::vSendTestResults(bool bForced) {
   FcSwUpdateComponent *component = FcSwUpdateComponent::instance();
   ETG_TRACE_COMP(("DiagLog::vSendTestResults bForced=%d", bForced));
   // todo: fill test-results (trouble-codes)
   ::midw_diaglog_fi_types::T_TestResultList testResultList;
   for (std::map<tUInt,DiagLogItem *>::iterator iter =_mapItems.begin();
        iter != _mapItems.end(); ++iter) {
      tUInt itc=iter->first;
      DiagLogItem *item=iter->second;
   	  ETG_TRACE_COMP(("DiagLog::vSendTestResults itc=%d resultCode=%d resultCodeSent=%d", 
   			                    item->_itc, item->_resultCode, item->_resultCodeSent));
      if (bForced || 
          (item->_resultCode != item->_resultCodeSent)) {
         ::midw_diaglog_fi_types::T_TestResult oTestResult;
         SWU_ASSERT_RETURN(item->_itc);
         if (item->_itc) {
            oTestResult.setTroubleCode(item->_itc);
            oTestResult.setResult((::midw_diaglog_fi_types::T_e8_TestResult)item->_resultCode);
            item->_resultCodeSent=item->_resultCode;
			testResultList.push_back(oTestResult);
         }
      }
   }
   SEND_REQ_TO_PROXY(FcSwUpdateComponent, getDiagLogProxy, sendSaveTestResultStart,testResultList);
}


bool DiagLog::registerItem(DiagLogItem *item) {
   tUInt itc=item->_itc;
   SWU_ASSERT_RETURN_FALSE(itc);
   std::map<tUInt,DiagLogItem *>::iterator iter= _mapItems.find(itc);
   if (iter==_mapItems.end()) {
      _mapItems[itc]=item;
      return true;
   }
   return false;
}

void DiagLog::unregisterItem(DiagLogItem *item) {
   tUInt itc=item->_itc;
   SWU_ASSERT_RETURN(itc);
   std::map<tUInt,DiagLogItem *>::iterator iter= _mapItems.find(itc);
   if (iter!=_mapItems.end()) {
      _mapItems.erase(iter);
   }
}


}


#if 0
// broken code copied from fcswupd_prj.cpp
// todo: reactivate
// todo: deactivate internally when not in normal mode
#include "main/fcswupd_diagLog.h"
#include "../../../di_middleware_server/components/vd_diaglog/common/framework/vd_diaglog_itc_definition_common.h"


DiagLogItem _diagLog_ReprogrammingFlashingFail;
DiagLogItem _diagLog_ReprogrammingChecksumFail;
DiagLogItem _diagLog_LicDigSigMismatch;
DiagLogItem _diagLog_MsgDigSigMismatch;
DiagLogItem _diagLog_CompatibleMismatch;
DiagLogItem _diagLog_FilesNotAvailable;


_diagLog_ReprogrammingFlashingFail.vSetResult(DiagLogItem::enResultCode_Passed);
_diagLog_ReprogrammingChecksumFail.vSetResult(DiagLogItem::enResultCode_Passed);
_diagLog_LicDigSigMismatch.vSetResult(DiagLogItem::enResultCode_Passed);
_diagLog_MsgDigSigMismatch.vSetResult(DiagLogItem::enResultCode_Passed);
_diagLog_CompatibleMismatch.vSetResult(DiagLogItem::enResultCode_Passed);
_diagLog_FilesNotAvailable.vSetResult(DiagLogItem::enResultCode_Passed);

tVoid FcSwUpdProject::vProcess(Msg_NotifyCtrlError *pMsg) {
   ETG_TRACE_COMP(("FcSwUpdProject::vProcess(Msg_NotifyCtrlError)"));
   std::list< uint32_t > const &errors=pMsg->_errors;

   if (errors.empty()) {
   		// todo: check which item has to be reset to passed
		// diaglog_itemXXX.vSendResult(DiagLogItem::enResultCode_Passed);
      	ETG_TRACE_COMP(("FcSwUpdProject::vProcess(Msg_NotifyCtrlError): error list empty"));
	  	return;
   }

   // we are only interested in the first error in the list.
   tU32 u32FirstError= errors.front(); // todo: check correct method to get first element from list
   ETG_TRACE_COMP(("  u32FirstError=%u", u32FirstError));
   FCSWUPD_NS_FCSWUPD_T::trErrorIds errorProperty = FcSwUpdSrv::instance()->getUpdateErrors();
   FCSWUPD_NS_FCSWUPD_T::tenErrorId enFirstError  = SrvGeneric::instance()->convCoreErrorCodeToPrj(u32FirstError);
   ETG_TRACE_COMP(("  enFirstError =%u", enFirstError));

   // map the error code to DTC:
   switch (enFirstError) {

			// Update OK
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_OK:
   				 ETG_TRACE_COMP(("  Set all DTCs to PASSED"));
				 _diagLog_ReprogrammingFlashingFail.vSendResult(DiagLogItem::enResultCode_Passed);
				 _diagLog_ReprogrammingChecksumFail.vSendResult(DiagLogItem::enResultCode_Passed);
				 _diagLog_LicDigSigMismatch.vSendResult        (DiagLogItem::enResultCode_Passed);
				 _diagLog_MsgDigSigMismatch.vSendResult        (DiagLogItem::enResultCode_Passed);
				 _diagLog_CompatibleMismatch.vSendResult       (DiagLogItem::enResultCode_Passed);
				 _diagLog_FilesNotAvailable.vSendResult        (DiagLogItem::enResultCode_Passed);
				 break;

			// Licence Digital Signature Mismatch
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_SECTION_SIGNATURE_NOT_FOUND:
   				 ETG_TRACE_COMP(("  Set DTC LicDigSigMismatch to FAILED"));
				 _diagLog_LicDigSigMismatch.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			// Message Digital Signature Mismatch
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_CHECKSUM:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_SIGNATURE_CHECK_FAILED:
   				 ETG_TRACE_COMP(("  Set DTC MsgDigSigMismatch to FAILED"));
				 _diagLog_MsgDigSigMismatch.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			// Compatibility Mismatch
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_REGION_CONFLICT:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_VARIANT_CONFLICT:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_VERSION:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_DEVICE_INCOMPATIBLE_DM_VERSION:
   				 ETG_TRACE_COMP(("  Set DTC CompatibleMismatch to FAILED"));
				 _diagLog_CompatibleMismatch.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			// Files Not Available
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_NOT_FOUND:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_METAINFO_SECTION_NOT_FOUND:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_MEDIA_UNAVAILABLE:
   				 ETG_TRACE_COMP(("  Set DTC FilesNotAvailable to FAILED"));
				 _diagLog_FilesNotAvailable.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			// Reprogramming Flash Failed
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_DOWNLOAD_MRG_BUSY:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_NOT_ENOUGH_MEMORY:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_READ:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_DEVICE_NOT_READY:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_DEVICE_NOT_SUPPORTED:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_INVALID_SECTORHEADER:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_SIZE:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_FLASHING:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_ERG_WRITE:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_ERG_READ:
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_UNKNOWN:
   				 ETG_TRACE_COMP(("  Set DTC ReprogrammingFlashingFail to FAILED"));
				 _diagLog_ReprogrammingFlashingFail.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			// Reprogramming Checksum Failed
			case FCSWUPD_NS_FCSWUPD_T::tenErrorId__SWL_ERROR_IMAGE_CHECKSUM:
   				 ETG_TRACE_COMP(("  Set DTC ReprogrammingChecksumFail to FAILED"));
				 _diagLog_ReprogrammingChecksumFail.vSendResult(DiagLogItem::enResultCode_Failed);
				 break;

			default:
				 ETG_TRACE_COMP(("FcSwUpdProject::vProcess(Msg_NotifyCtrlError): ignore u32FirstError= %u", u32FirstError));
				 break;

   }
   ETG_TRACE_COMP(("FcSwUpdProject::vProcess(Msg_NotifyCtrlError) leave"));
}

#endif
