/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     SWUpdateCoreComponent.h
 *\brief    hand crafted code
 *
 *\author   CM-AI/PJ-VW
 *          peter.hassmann@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef FcSwUpdateComponent_h
#define FcSwUpdateComponent_h


#include "fcswupd_component_inc.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"


#include "Midw_DiagLog_FIProxy.h"
#include "midw_diaglog_fi_typesConst.h"

#include "fcswupdatesrv/FcSwUpdateSrvStub.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceProxy.h"
#include "fcswupdateloopbacksrv/FcSwUpdateLoopBackSrvStub.h"
#include "fcswupdateloopbacksrv/FcSwUpdateLoopBackSrvProxy.h"
#include <algorithm>



#include "asf/core/ApplicationIF.h"

#include "util/swu_singleton.hpp"
#include "util/swu_msg.hpp"
#include "util/swu_asfUtil.hpp"
#include "main/fcswupd_main.h"
#include "util/fcswupd_types.hpp"
namespace fcswupdate {
using namespace ::asf::core;

#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
#define SEND_REQ_TO_PROXY(USER, PROXY_GETTER,SEND_METHOD, ...) {	\
      swu::traceInfo("Sending: " #SEND_METHOD);                         \
      USER *component = USER::instance(); \
      component->PROXY_GETTER()->SEND_METHOD(*component, ##__VA_ARGS__); \
      }     
#define SEND_RELUPREG_TO_PROXY(USER, PROXY_GETTER, SEND_METHOD) {	\
      swu::traceInfo("Sending: " #SEND_METHOD);                                \
      USER *component = USER::instance(); \
         component->PROXY_GETTER()->SEND_METHOD(); \
	 }
#else
#define SEND_REQ_TO_PROXY(USER, PROXY_GETTER,SEND_METHOD, ...) {	\
      swu::traceInfo("Sending: " #SEND_METHOD);                                \
      USER *component = USER::instance(); \
      if (component->PROXY_GETTER()->isAvailable()) {                   \
         component->PROXY_GETTER()->SEND_METHOD(*component, ##__VA_ARGS__); \
      } else  {                                                         \
         swu::traceError("Proxy not available for " #SEND_METHOD);           \
      }                                                                 \
   }

#define SEND_RELUPREG_TO_PROXY(USER, PROXY_GETTER, SEND_METHOD) {        \
      swu::traceInfo("Sending: " #SEND_METHOD);                                \
      USER *component = USER::instance(); \
      if (component->PROXY_GETTER()->isAvailable()) {                   \
         component->PROXY_GETTER()->SEND_METHOD(); \
      } else  {                                                         \
         swu::traceError("Proxy not available for " #SEND_METHOD);           \
      }                                                                 \
   }

#endif
#ifdef __SW_UPDATE_UNIT_TESTING__
#undef SEND_REQ_TO_PROXY
#define SEND_REQ_TO_PROXY(USER, PROXY_GETTER,SEND_METHOD, ...)
#endif



#define AUTO_PROPERTY(PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL) \
   AUTO_PROPERTY_BASE(FcSwUpdateComponent, FcSwUpdateComponent, PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL)


#define AUTO_PROPERTY_LOCAL(PROXY_USER, PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL) \
   AUTO_PROPERTY_BASE(FcSwUpdateComponent, PROXY_USER, PROXY_GETTER, PROPERTY, LINE, REGISTER, DEREGISTER, DEREGISTERALL)

#define AUTO_PROPERTY_CCA_LOCAL(PROXY_USER, PROXY_GETTER, PROPERTY,LINE) AUTO_PROPERTY_LOCAL(PROXY_USER, PROXY_GETTER, PROPERTY, LINE, UpReg, RelUpReg, RelUpRegAll)
#define AUTO_PROPERTY_CMS_LOCAL(PROXY_USER, PROXY_GETTER, PROPERTY,LINE) AUTO_PROPERTY_LOCAL(PROXY_USER, PROXY_GETTER, PROPERTY, LINE, Register, Deregister, DeregisterAll)


#define AUTO_PROPERTY_CMS(PROXY_GETTER, PROPERTY,LINE) AUTO_PROPERTY(PROXY_GETTER, PROPERTY, LINE, Register, Deregister, DeregisterAll)
#define AUTO_PROPERTY_CCA(PROXY_GETTER, PROPERTY,LINE) AUTO_PROPERTY(PROXY_GETTER, PROPERTY, LINE, UpReg, RelUpReg, RelUpRegAll)
#define AUTO_PROPERTY_CORE(PROPERTY) AUTO_PROPERTY_CMS(getSwUpdCoreProxy, PROPERTY, __LINE__)

#define AUTO_PROPERTY_DIAGLOG(PROPERTY) AUTO_PROPERTY_CCA(getDiagLogProxy, PROPERTY, __LINE__)

#define DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SPM, CFC_SPM_FIProxy, SystemStateStatus) \
   DISPATCHABLE_MSG_DECL_PROXY(FcSwUpdRoot, FCSWUPD_NS_SPM, CFC_SPM_FIProxy, SystemStateStatus );


/* messages from diaglog */
/* method-results */
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SaveTestResultResult);
/* properties */
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SendNextTestResultStatus);

/* messages from sw-update-core */
/* method-results */
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, EnterUpdateSessionResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ExitUpdateSessionResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ConfigUpdateSessionResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, AbortInstallResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallResponseSignal);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, RequestRecoveryDownloadResponse);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, SetIsoPathResponse);

/* properties */
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayTextUpdate);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ProgressUpdate);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UpdateStatesUpdate);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UsbFoundUpdate);
DISPATCHABLE_MSG_DECL_PROXY_FCSWUPD(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayBgImageUpdate);




class FcSwUpdateComponent :
      public swu::Singleton<FcSwUpdateComponent>,
      public ::asf::core::BaseComponent, 
      public swu::Member<FcSwUpdRoot>,

      // notification of srv-availabilty of other services
      public ::asf::core::ServiceAvailableIF,
      // loopback-server
      public FCSWUPD_NS_FCSWUPD_LB::FcSwUpdateLoopBackSrvStub,
    
      // mutliple client-handlers start from here

      // needed interfaces of diaglog
      // methods
      public FCSWUPD_NS_DIAGLOG::SaveTestResultCallbackIF,
      // properties
      public FCSWUPD_NS_DIAGLOG::SendNextTestResultCallbackIF,

      // needed interfaces of swUpdCore, we are client (proxy)
      // methods
      public FCSWUPD_NS_SWUCORE::EnterUpdateSessionCallbackIF,
      public FCSWUPD_NS_SWUCORE::ExitUpdateSessionCallbackIF,
      public FCSWUPD_NS_SWUCORE::ConfigUpdateSessionCallbackIF,
      public FCSWUPD_NS_SWUCORE::AbortInstallCallbackIF,
      public FCSWUPD_NS_SWUCORE::StartInstallCallbackIF,
	  public FCSWUPD_NS_SWUCORE::StartInstallResponseCallbackIF,
      public FCSWUPD_NS_SWUCORE::RequestRecoveryDownloadCallbackIF,
      public FCSWUPD_NS_SWUCORE::SetIsoPathCallbackIF,
      // properties
#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
      public FCSWUPD_NS_SWUCORE::ProgressCallbackIF,
      public FCSWUPD_NS_SWUCORE::UsbFoundCallbackIF,
      public FCSWUPD_NS_SWUCORE::DisplayTextCallbackIF,
      public FCSWUPD_NS_SWUCORE::UpdateStatesCallbackIF,
      public FCSWUPD_NS_SWUCORE::DisplayBgImageCallbackIF
#else
      public FCSWUPD_NS_SWUCORE::ProgressRegisterCallbackIF,
      public FCSWUPD_NS_SWUCORE::UsbFoundRegisterCallbackIF,
      public FCSWUPD_NS_SWUCORE::DisplayTextRegisterCallbackIF,
      public FCSWUPD_NS_SWUCORE::UpdateStatesRegisterCallbackIF,
      public FCSWUPD_NS_SWUCORE::DisplayBgImageRegisterCallbackIF
#endif

{
   friend class swu::Singleton<FcSwUpdateComponent>;
   template<class COMP, class PROXY>
   friend class swu::NotifyAvail;

public:


   FcSwUpdateComponent();
   void vInit();
   // input from our CSM-loopback-service
   virtual void onReceiveLoopbackMessageRequest (const ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD_LB::ReceiveLoopbackMessageRequest >& request);

   virtual const char *getName() {
      return "FcSwUpdateComponent";
   }
   virtual void traceState(); 

   virtual ~FcSwUpdateComponent();

   // ServiceAvailableIF
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);



   // interface to swUpdateCore
   // methods
   //    virtual void onEnterUpdateSessionResponse(const ::boost::shared_ptr< SWUCoreServiceProxy >& proxy, const ::boost::shared_ptr< EnterUpdateSessionResponse >& response) {};
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, EnterUpdateSessionResponse);
   // virtual void onEnterUpdateSessionError(const ::boost::shared_ptr< SWUCoreServiceProxy >& proxy, const ::boost::shared_ptr< EnterUpdateSessionError >& error) {};
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, EnterUpdateSessionError);

   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ExitUpdateSessionResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ExitUpdateSessionError);
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ConfigUpdateSessionResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ConfigUpdateSessionError);
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, AbortInstallResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, AbortInstallError);
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallError);
   
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallResponseSignal);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, StartInstallResponseError);
   
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, RequestRecoveryDownloadResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, RequestRecoveryDownloadError);
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, SetIsoPathResponse);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, SetIsoPathError);
    
   // properties
   // virtual void onDisplayTextUpdate(const ::boost::shared_ptr< SWUCoreServiceProxy >& proxy, const ::boost::shared_ptr< DisplayTextUpdate >& notify) {};
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayTextUpdate);

     AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayBgImageUpdate);

   // virtual void onDisplayTextRegisterError(const ::boost::shared_ptr< SWUCoreServiceProxy >& proxy, const ::boost::shared_ptr< DisplayTextRegisterError >& error) {};
#ifndef VARIANT_S_FTR_ENABLE_SWU_DBUS
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayTextRegisterError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ProgressRegisterError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UpdateStatesRegisterError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UsbFoundRegisterError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayBgImageRegisterError);
#else
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayTextError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ProgressError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UpdateStatesError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UsbFoundError);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, DisplayBgImageError);
#endif

   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, ProgressUpdate);
   
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UpdateStatesUpdate);
   
    
   AUTO_DISPATCH_RES(FCSWUPD_NS_SWUCORE, SWUCoreServiceProxy, UsbFoundUpdate);
   


   /* messages from diaglog */
   /* methods */
   AUTO_DISPATCH_RES(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SaveTestResultResult);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SaveTestResultError);
   /* properties */
   AUTO_DISPATCH_RES(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SendNextTestResultStatus);
   AUTO_DISPATCH_ERROR(FCSWUPD_NS_DIAGLOG, Midw_DiagLog_FIProxy, SendNextTestResultError);

   void bSendLoobBackMsg(swu::MsgCompBase<FcSwUpdRoot> *pMsg);

   ::boost::shared_ptr< FCSWUPD_NS_FCSWUPD_LB::FcSwUpdateLoopBackSrvProxy >getLoopBackProxy() {
      return _loopBackProxy.getProxy();
   }


   ::boost::shared_ptr< FCSWUPD_NS_DIAGLOG::Midw_DiagLog_FIProxy >getDiagLogProxy() {
      return _diaglogProxy.getProxy();
   }

   ::boost::shared_ptr< FCSWUPD_NS_DIAGLOG::Midw_DiagLog_FIProxy >getProxy(FCSWUPD_NS_DIAGLOG::Midw_DiagLog_FIProxy *) {
      return _diaglogProxy.getProxy();
   }

   ::boost::shared_ptr< FCSWUPD_NS_SWUCORE::SWUCoreServiceProxy >getSwUpdCoreProxy() {
      return _swUpdCoreProxy.getProxy();
   }


   // simulate input from diaglog
   void simDiagLogSendNextTestResultStatus();

   // simulate input from fcSwUpdateCore
   void simSwUpdCoreEnterUpdateSessionResponse(bool bOk);
   void simSwUpdCoreExitUpdateSessionResponse(bool bOk);
   void simSwUpdCoreStartInstallResponse(tUInt ok);

   void testLuaScript(char const *toolsPath);

   swu::ProxyList _proxyList;
   static std::list<swu::AutoProperty *> _autoPropertyList;

private:

   AUTO_PROPERTY_DIAGLOG(SendNextTestResult);
   swu::NotifyAvail<FcSwUpdateComponent, FCSWUPD_NS_DIAGLOG::Midw_DiagLog_FIProxy> notifyAvailDiaglog;

   AUTO_PROPERTY_CORE(DisplayText);
   AUTO_PROPERTY_CORE(Progress);
   AUTO_PROPERTY_CORE(UpdateStates);
   AUTO_PROPERTY_CORE(UsbFound);
   AUTO_PROPERTY_CORE(DisplayBgImage);


   swu::ProxyAccess<FcSwUpdateComponent, FCSWUPD_NS_DIAGLOG::Midw_DiagLog_FIProxy> _diaglogProxy;
   swu::ProxyAccess<FcSwUpdateComponent, FCSWUPD_NS_SWUCORE::SWUCoreServiceProxy> _swUpdCoreProxy;
   swu::ProxyAccess<FcSwUpdateComponent, FCSWUPD_NS_FCSWUPD_LB::FcSwUpdateLoopBackSrvProxy> _loopBackProxy;

   swu::MemberList<FcSwUpdRoot> _memberList;

   DECLARE_CLASS_LOGGER ();

};
  
}

#endif
