#ifndef FCSWUPD_DEVICE_POLLING_H
#define FCSWUPD_DEVICE_POLLING_H

#include "main/fcswupd_component.h"
#include "util/swu_singleton.hpp"
#include "util/swu_memberList.hpp"


namespace fcswupdate {





class AutoMount: 
      public swu::Member<FcSwUpdRoot>,
      public swu::Singleton<AutoMount>
 {
      
    struct Msg_AutoMountTimerCallback{};
   friend class swu::Singleton<AutoMount>;
 private:
    AutoMount();

public:
   virtual ~AutoMount();
   virtual char const *getName() {
      return "AutoMount";
   }

   virtual void traceState();

   virtual void vInit();
   virtual void vDeInit();




   void vProcess(Msg_AutoMountTimerCallback *pMsg);


   const std::map< std::string, trSourceInfo > &getSources();


private:
    swu::SwUpdTimer<AutoMount, Msg_AutoMountTimerCallback> _timer;
    bool _initialized;
};

}



#endif
