#include "sstream"
#include <iostream>
#include <fstream>
#include <set>
#include "config/fcswupd_config.hpp"
#include "util/swu_execCommand.h"
#include "util/swu_types.h"
#include "util/swu_util.hpp"
#include "util/swu_filesystem.h"
#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_autoMount.h"
#include "config/fcswupd_config.hpp"

#define ETG_I_FILE_PREFIX fcswupdate::PrmIf::instance()->

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_AUTOMOUT_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#include "trcGenProj/Header/fcswupd_autoMount.cpp.trc.h"
#endif


#define FCSWUPD_MOUNT_POINT_BASE "/tmp/mounts/"
#define FCSWUPD_MOUNTS_CHANGED_MARKER_FILE  FCSWUPD_MOUNT_POINT_BASE"/changed.txt"
#define FCSWUPD_MOUNTS_FILE  FCSWUPD_MOUNT_POINT_BASE"/mounts.txt"
#define FCSWUPD_AUTO_MOUNT_POLL_INTERVAL_MS 3000

#define FCSWUPD_AUTO_MOUNT_UTIL_SCRIPT "/usr/bin/autoMountUtil.sh"

// Provide search pattern for ls in autoMountUtil.sh in order to search for SDCARD
// and exclude internal EMMC
#define FCSWUPD_AUTO_MOUNT_UTIL_GEN3_EXCLUDE_EMMC "/dev/mmcblk[^1]*"
#define FCSWUPD_AUTO_MOUNT_UTIL_GEN4_EXCLUDE_EMMC "/dev/mmcblk[^2]*"

namespace fcswupdate {

void AutoMount::traceState() {
}

AutoMount::AutoMount():
   _initialized(false) {
   ETG_I_REGISTER_FILE();
}

AutoMount::~AutoMount() {
   ETG_I_UNREGISTER_FILE();
   vDeInit();
}

tVoid AutoMount::vInit()
{
   if (!_initialized) {
      ETG_TRACE_USR1(("AutoMount::vInit()"));
      _timer.start(this, FCSWUPD_AUTO_MOUNT_POLL_INTERVAL_MS);
   }
}

tVoid AutoMount::vDeInit()
{
   if (_initialized) {
      ETG_TRACE_USR1(("AutoMount::vDeInit()"));
      _timer.stop();
      _initialized=false;
   }
}


void AutoMount::vProcess(AutoMount::Msg_AutoMountTimerCallback *pMsg)
{
   (void)pMsg;
   // This variable needs to be initialized here and currently not possible to initialize in constructor.
   // Initialization in constructor is leading to reset of value.
   std::string mountUtilCommand;

   ETG_TRACE_USR1(("AutoMount::vProcess(Msg_AutoMountTimerCallback): START"));

#ifndef VARIANT_S_FTR_ENABLE_G4G
      mountUtilCommand = std::string(FCSWUPD_AUTO_MOUNT_UTIL_SCRIPT) + std::string(" ") + std::string(FCSWUPD_AUTO_MOUNT_UTIL_GEN3_EXCLUDE_EMMC);
#else
      mountUtilCommand = std::string(FCSWUPD_AUTO_MOUNT_UTIL_SCRIPT) + std::string(" ") + std::string(FCSWUPD_AUTO_MOUNT_UTIL_GEN4_EXCLUDE_EMMC);
#endif
   swu::execCommand(mountUtilCommand);
   if(swu::exists(FCSWUPD_MOUNTS_CHANGED_MARKER_FILE )) {
      ETG_TRACE_USR1(("AutoMount: detected change"));
      unlink(FCSWUPD_MOUNTS_CHANGED_MARKER_FILE);
   } else {
      ETG_TRACE_USR1(("AutoMount: unchanged"));
      _timer.start(this, FCSWUPD_AUTO_MOUNT_POLL_INTERVAL_MS);
      return;

   }

   std::ifstream inFile;
   inFile.open(FCSWUPD_MOUNTS_FILE);
   if(!(inFile.is_open())) {
      ETG_TRACE_USR4(("AutoMount:Unable to open %s", FCSWUPD_MOUNTS_FILE));
      _timer.start(this, FCSWUPD_AUTO_MOUNT_POLL_INTERVAL_MS);
      return;
   }

   // read lines, each line contains a mount-point
   std::set<std::string> mounts;
   std::string line;
   while(!inFile.eof()) {
      getline(inFile,line);
      swu::trimString(line);
      if (line.size()) {
         ETG_TRACE_USR4(("AutoMount: inserted %s", line.c_str()));
         mounts.insert(line);
      }
   }

   ETG_TRACE_USR1(("AutoMount:inFile done"));

   PropDevMgr *property=PropDevMgr::instance();
   std::map< std::string, trSourceInfo > &mapSources=property->access()._mapSources;

   // delete all sources that we mounted previously, i.e. all USB sources
   for (std::map< std::string, trSourceInfo >::iterator it=mapSources.begin();
        it!=mapSources.end(); /* no increment */)
   {
      trSourceInfo &info = it->second;
      if (info.owner == getName()) {
         mapSources.erase(it++);
      }
      else {
         ++it;
      }
   }

   ETG_TRACE_USR1(("AutoMount:mapSources cleared"));

   // populute mapSources with new info
   for (std::set<std::string>::iterator mountsIter=mounts.begin();
        mountsIter!=mounts.end();
        ++mountsIter) {
      std::string const &mountPoint=*mountsIter;
      //bool bMounted = true;
      trSourceInfo &medium = mapSources[mountPoint];
      ETG_TRACE_USR1(("AutoMount:adding mount:%s", mountPoint.c_str()));

      medium.bDeleted=false;
      medium.path = mountPoint;
      medium.bMounted = true;
      medium.enSourceType = tenSourceType_USB;
      medium.owner = getName();
    }

   ETG_TRACE_USR1(("AutoMount:adding mounts done"));


   property->iNotify(this);
   _timer.start(this, FCSWUPD_AUTO_MOUNT_POLL_INTERVAL_MS);

   ETG_TRACE_USR1(("AutoMount::vProcess(Msg_AutoMountTimerCallback): END"));
}







}
