/*
 * fcswupd_ctrlRecovery.cpp
 *
 *  Created on: Mar 13, 2014
 *      Author: efs1hi
 */

#include "ctrl/fcswupd_ctrlRecoveryGeneric.hpp"

#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_CTRL
#include "trcGenProj/Header/fcswupd_ctrlRecoveryGeneric.cpp.trc.h"
#endif

namespace fcswupdate {


// configuration that is fetched on start of update and stored persistently in progress-section if needed
void CtrlRecoveryGeneric::modifyConfig(CtrlPersistentConfig &ctrlConfig) {
 
   Config *cfg=Config::instance();
   ctrlConfig.forceShutdown.set(cfg->cfg_DoShutdownAfterUpdate.readAsBool());   
   ctrlConfig.maxModTries.set(cfg->cfg_CtrlMaxModRetries.get());
   ctrlConfig.waitForStickRemovedOnSuccess.set(true);

}

void CtrlRecoveryGeneric::modifyConfig(CtrlStaticConfig &ctrlConfig) {
   ctrlConfig.interactOnError = true;
}


void CtrlRecoveryGeneric::modifyCtrlResultAction(bool updateSuccess, CtrlReadyAction *readyAction) {
   // todo: put magic numbers into fcswupd_configPrj.h

   //to delete all locks on next power cycle, only if it's not scomo ota update.
   Config *cfg=Config::instance();
   if(cfg->cfg_HandleCentralLock.get() && (_pCtrl->getInitialMode() != tenSwUpdateMode_Scomo)) {
      cfg->cfg_SpmMarkerForLock.set(1);
   }

   if (updateSuccess) {
      readyAction->enAction=enCtrlReadyAction_reboot;
   }
   else {
      // let system wait for 5 minutes before shutting down
      readyAction->enMode=enCtrlReadyMode_failed;
      readyAction->enAction=enCtrlReadyAction_shutdown;
      readyAction->enInterval=enCtrlReadInterval_Seconds;
      if(_pCtrl->wasStickRemoved()) {
         readyAction->u32NumIntervals=SWUPD_RECOVERY_SHUTDOWN_NOW_SEC;
      } else {
         readyAction->u32NumIntervals=SWUPD_RECOVERY_FAILED_FINALIZE_TIMER_SEC;
      }
      readyAction->line1="Please wait for the system to shutdown";
      readyAction->line1="System will shutdown in another _INTERVALS_LEFT_ seconds";
   }
}

tenErrorHandling CtrlRecoveryGeneric::enOnCtrlError(std::list< uint32_t > const &errors) {
   ETG_TRACE_USR4(("CtrlRecoveryGeneric::enOnCtrlError - START"));

   tenErrorHandling errHandling = tenErrorHandling_invalid;
   if(_pCtrl->wasStickRemoved() && Config::instance()->cfg_CtrlRetryOnRemovedStick.get()) {
      setHmiState(tenPrjState_MediumRemoved);
      errHandling = tenErrorHandling_retry;
   } else {
      setHmiState(tenPrjState_Error);
      errHandling = tenErrorHandling_abort;
   }

   ETG_TRACE_USR4(("CtrlRecoveryGeneric::enOnCtrlError - END"));
   return errHandling;
}



}
