/*
 * fcswupd_ctrlEngineering.h
 *
 *  Created on: Oct 15, 2013
 *      Author: efs1hi
 */

#ifndef FCSWUPD_CTRL_ENGINEERING_H_
#define FCSWUPD_CTRL_ENGINEERING_H_

#include "ctrl/fcswupd_ctrl.h"
#include "util/fcswupd_trace.hpp"

namespace fcswupdate {

/**
 * This Control Adapter is for the Recovery/Emergency update
 */
class CtrlEngineering: public CtrlAdapter {
public:
   CtrlEngineering(Ctrl *pCtrl):
      CtrlAdapter(pCtrl) {
   }

   virtual ~CtrlEngineering() { }

   virtual const char *getName() {
      return "CtrlEngineering";
   }

   virtual void traceState() { }

  
   // todo: rework Ctrl-Ready action, add ctrtResult action or combine both.
   // optimal case would be that only the result-action is needed.
   virtual void modifyCtrlResultAction(bool updateSuccess, CtrlReadyAction *readyAction);

   virtual tVoid vOnCtrlResult(bool success); 

   virtual tenSwUpdateMode enSwUpdateMode() {
      return tenSwUpdateMode_Emergency;
   }

   virtual update_decision_setting_type getDefaultDecision() {
      return update_decision_setting_type__force;
   }


};

}

#endif
