#ifndef FCSWUPD_CONFIGIRATOR_UTIL_H
#define FCSWUPD_CONFIGIRATOR_UTIL_H

#include "tinyxml/tinyxml.h"
#include "util/swu_xmlDoc.h"
#include "util/swu_util.hpp"
#include "util/swu_constants.hpp"
#include "util/fcswupd_bxml.h"
//#include "main/fcswupd_prjVagMib.h"

namespace fcswupdate {


class ConfiguratorUtil {
private:
   ConfiguratorUtil & operator=(const ConfiguratorUtil &);
   ConfiguratorUtil(const ConfiguratorUtil &);

public:
   typedef FcSwUpdRoot compType;
   ConfiguratorUtil();
   ~ConfiguratorUtil();

   typedef enum  {
      enConfigOption_NewOnly,
      enConfigOption_DifferentOnly,
      enConfigOption_Any,
      enConfigOption_UserDefined,
      enConfigOption_NewAndSameOnly,
      enConfigOption_MetaInfo,
      enConfigOption_NotDefined
    } tenConfigOption;

   tVoid vSetHmiState(tenPrjState enHmiState);


   bool setDoc(TiXmlDocument *doc);
   TiXmlElement * getRoot() {
      return _root;
   }

   TiXmlElement * getReleaseCopy() {
      return _releaseCopy;

   }
   TiXmlElement * getRelease() {
      return _release;
   }

   TiXmlElement * getOverall() {
      return _overall;
   }

   TiXmlElement * getDecisions() {
      return _decisions;
   }


   const char   * getHardwareId();
   TiXmlDocument *getDocAccess() {
      return _doc;
   }

   void setDefaultDecision(tenConfigOption defaultDecision);
   bool configOptionToSting(tenConfigOption configOption, std::string &configString);
   tenConfigOption decisionFromString(std::string decision);

   TiXmlDocument *pullDocAndClear() {
      TiXmlDocument *doc=_doc;
      _doc=0;
      clear();
      return doc;
   }

   void clear() {
      freePtr(&_doc);
      freePtr(&_releaseCopy);
      _root=0;
      _release=0;
      _overall=0;
      _decisions=0;
   }


   void logXmlElem(TiXmlElement *xmlElem, std::string fileName);
   void logXmlDoc(TiXmlDocument *xmlDoc, std::string fileName);

private:
   template<class C>
   void freePtr(C **ppC) {
      if (*ppC) {
         delete *ppC;
         *ppC=0;
      }
   }

   TiXmlDocument *_doc;
   TiXmlElement *_root;
   TiXmlElement *_release;
   TiXmlElement *_releaseCopy;
   TiXmlElement *_overall;
   TiXmlElement *_decisions;
};

}
#endif
