#include "tinyxml/tinyxml.h"
#include "util/swu_util.hpp"
#include "util/swu_member.hpp"
#include "fcswupdatesrv/FcSwUpdateSrvConst.h"
#include "config/fcswupd_config.hpp"
#include "main/fcswupd_component.h"
#include "fcswupd_configuratorUtil.h"
#include "main/fcswupd_propDevMgr.h"


#include "util/fcswupd_trace.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_CONFIGURATOR
#include "trcGenProj/Header/fcswupd_configuratorUtil.cpp.trc.h"
#endif

namespace fcswupdate {

ConfiguratorUtil::ConfiguratorUtil():
   _doc(0),
   _root(0),
   _release(0),
   _releaseCopy(0),
   _overall(0),
   _decisions(0)
{}

ConfiguratorUtil::~ConfiguratorUtil()
{
   if (_doc) {
      delete _doc;
      _doc=0;
   }
   if (_releaseCopy) {
      delete _releaseCopy;
      _releaseCopy=0;
   }

   _root = 0;
   _release = 0;
   _overall = 0;
   _decisions = 0;
}


tVoid ConfiguratorUtil::vSetHmiState(tenPrjState enState) {
   ETG_TRACE_USR1(("setHmiState(%u)", 
                   ETG_CENUM(tenPrjState, enState)));
   if (enState==tenPrjState_Config && _overall) {
      Config::instance()->cfg_CurrentMediaType.set((tU32)swu::getUIntFromChild(_overall, "SOURCE_TYPE"));
   }
   else {
      Config::instance()->cfg_CurrentMediaType.set((tU32)tenSourceType_other);
   }
   Msg_NotifyPrjState msg(enState);
   msg.iNotifyByNonMember(this);
}

bool ConfiguratorUtil::setDoc(TiXmlDocument *doc) {
	clear();
    if (!doc) {
       ETG_TRACE_ERR(("ConfiguratorUtil::setDoc: doc=null"));
       return false;
    }

    logXmlDoc(doc, "ConfiguratorSetDocXmlDoc.xml");

	_doc = doc;
	_root = _doc->RootElement();
	SWU_ASSERT_RETURN_FALSE( _root);
	_release = _root->FirstChildElement("RELEASE");
	SWU_ASSERT_RETURN_FALSE( _release);
	_releaseCopy = new TiXmlElement("");
	SWU_ASSERT_RETURN_FALSE( _releaseCopy);
	*_releaseCopy = *_release;
	_overall = _root->FirstChildElement("OVERALL");
	SWU_ASSERT_RETURN_FALSE( _overall);
	TiXmlElement decisions("DECISIONS");
	_root->InsertAfterChild(_overall, decisions);
	_decisions = _root->FirstChildElement("DECISIONS");
	SWU_ASSERT_RETURN_FALSE( _decisions);

	return true;
}

const char   * ConfiguratorUtil::getHardwareId() {
   BXmlAccess relAccess(_release);
   return relAccess.getTextFromDevice("HWID");
}

ConfiguratorUtil::tenConfigOption ConfiguratorUtil::decisionFromString(std::string decision) {
   if (decision == swu::Constants::XML::update_decision__diff) {
      return enConfigOption_DifferentOnly;
   }
   if (decision == swu::Constants::XML::update_decision__update) {
      return enConfigOption_NewOnly;
   }
   if (decision == swu::Constants::XML::update_decision__updateNewOrSame) {
      return enConfigOption_NewAndSameOnly;
   }
   if (decision == swu::Constants::XML::update_decision__force) { // force is now pointing to any
      return enConfigOption_Any;
   }
   return enConfigOption_NotDefined;
}

bool ConfiguratorUtil::configOptionToSting(tenConfigOption configOption, std::string &configString) {
   configString="";
   bool res = true;
   switch (configOption) {
      case enConfigOption_NewOnly:
         configString=swu::Constants::XML::update_decision__update;
		  ETG_TRACE_USR1(("set Decision string enConfigOption_NewOnly %s",configString.c_str()));	  
         break;		 
      case 	enConfigOption_NewAndSameOnly:
		configString=swu::Constants::XML::update_decision__updateNewOrSame;
		 ETG_TRACE_USR1(("set Decision string enConfigOption_NewAndSameOnly %s",configString.c_str()));	 
		 break;		 
      case enConfigOption_DifferentOnly:
         configString=swu::Constants::XML::update_decision__diff;
		 ETG_TRACE_USR1(("set Decision string enConfigOption_DifferentOnly %s",configString.c_str()));	  
         break;
      case enConfigOption_Any:
         configString=swu::Constants::XML::update_decision__force;
		 ETG_TRACE_USR1(("set Decision string enConfigOption_Any %s",configString.c_str()));	  
         break;
      default:
         configString=swu::Constants::XML::update_decision__invalid;
		 ETG_TRACE_USR1(("set Decision string update_decision__invalid %s",configString.c_str()));	  
         res=false;
         break;
}
	return res;
}
void ConfiguratorUtil::setDefaultDecision(tenConfigOption defaultDecision) {
   SWU_ASSERT_RETURN(_decisions);
   std::string configString;
   ETG_TRACE_USR1(("DEFUALT Decision string %d",defaultDecision));
   if (configOptionToSting(defaultDecision, configString)) {
      swu::setTextChild(_decisions, "DEFAULT_MODE", configString);
	  ETG_TRACE_USR1(("set Decision string %s",configString.c_str()));	  
   }
}


void ConfiguratorUtil::logXmlDoc(TiXmlDocument *xmlDoc, std::string fileName) {
   ETG_TRACE_USR1(("ConfiguratorUtil::logXmlDoc(%s)", fileName.c_str()));
   xmlDoc->SaveFile((Config::instance()->getLogDirName() + "/" + fileName).c_str());
}

void ConfiguratorUtil::logXmlElem(TiXmlElement *xmlElem, std::string fileName) {
   TiXmlDocument xmlDoc;
   xmlDoc.InsertEndChild(*xmlElem);
   ETG_TRACE_USR1(("ConfiguratorUtil::logXmlDoc(%s)", fileName.c_str()));
   xmlDoc.SaveFile((Config::instance()->getLogDirName() + "/" + fileName).c_str());
}




}	// namespace
