#ifndef FCSWUPD_CONFIGIRATOR_HMI_H
#define FCSWUPD_CONFIGIRATOR_HMI_H

#include "util/swu_xmlDoc.h"
#include "tinyxml/tinyxml.h"
#include "util/swu_util.hpp"
#include "util/swu_member.hpp"
#include "util/fcswupd_bxml.h"
#include "main/fcswupd_systemData.h"
#include "configurator/fcswupd_configuratorUtil.h"
#include "configurator/fcswupd_configurator.h"
#include "main/fcswupd_resourcemanager.h"

namespace fcswupdate {


class XmlItemAccess;
class Msg_NotifyDevManagerChanged;
class Msg_ApplyDocRequest;
class Msg_UpdateEndRequest;
class Msg_UpdateSelectReleaseByFileRequest;
class Msg_UpdateSetReleaseFilterRequest;
class Msg_SetUpdateOptionsRequest;
class Msg_NotifyConfiguratorError;
struct Msg_ResourceManagerChanged;

class ConfiguratorHmiGeneric: public Configurator {
public:
   struct Msg_TiggerDevMgrTimer {
   };

   typedef enum  {
      enState_Initial,
      enState_WaitMediaInfo,
      enState_ConfigEmpty,
      enState_ConfigFound,
      enState_ConfigDone,
      enState_Terminated,
   } tenState; 
	
  typedef enum {
      enItemState_targetOnly,
      enItemState_stickOnly,
      enItemState_both,
    } tenItemState;
	
    struct RelInfo {
      RelInfo():overallSection(""){};
      TiXmlElement overallSection;
      trSourceInfo rSourceInfo;	  
      bool operator<(RelInfo const &r) const;	
   };

   struct ConfigScope:public Scope {
      ConfigScope(std::string itemName_, Scope::tenScope enScope_=enScope_No):Scope(itemName_, enScope_) 
      {};

      ConfigScope( XmlItemAccess item, ConfiguratorUtil::tenConfigOption enConfigOption, std::map<std::string, bool> const &decisions);
      void addChild(ConfigScope const &child); 
   };
   
   ConfiguratorHmiGeneric();

   virtual ~ConfiguratorHmiGeneric();

   virtual const char *getName() {
      return "ConfiguratorHmiGeneric";
   }
    virtual void traceState();

    virtual tVoid vInit();
    virtual tVoid vDeInit();

	
   // message from device-manager
    tVoid vProcess (Msg_NotifyDevManagerChanged *pMsg);
    // messages from HMI
    tVoid vProcess (Msg_UpdateSetReleaseFilterRequest *pMsg);
    tVoid vProcess (Msg_SetUpdateOptionsRequest *pMsg);
    tVoid vProcess (Msg_UpdateSelectReleaseByFileRequest *pMsg);
    tVoid vProcess (Msg_ApplyDocRequest *pMsg);
   // as configurator HMI
    tVoid vProcess (Msg_UpdateEndRequest *pMsg);
   tVoid vProcess(Msg_ResourceManagerChanged *msg);

   // timer
    tVoid vProcess (Msg_TiggerDevMgrTimer *pMsg);

    // parsing ITCs to Diagnosis
    tVoid vNotifyConfiguratorError(tenSwUpdateError errorCode);

   virtual TiXmlDocument *getXmlDoc();

protected:

private:
   swu::SwUpdTimer< ConfiguratorHmiGeneric, Msg_TiggerDevMgrTimer > _tiggerDevMgrTimer;

    tVoid vEnterState(tenState newState);
   tVoid evaluateScope();
   tVoid buildDeviceList();
   tVoid vSendReleaseDoc();
   tVoid vSendPreReleaseDoc(bool bvalidRelease);
   tVoid handleResource(bool bAcquireResource = false);
   tVoid sendEmpyReleaseDoc();
   tU32 getUpdateTimeFromScripts(TiXmlElement* elem);

   bool isIncompactMediumCanProceed(std::string path, tenSwUpdateError& status);

   void rebootToRecoveryMode();
   bool overallAllowsForceDnl(TiXmlElement *overallSection);
   bool overallAllowsAnyRelease(TiXmlElement *overallSection);
   void sendUpdateSelectReleaseByFileResponse(tenSwUpdateError error);

   tenSwUpdateError findReleaseXml();

   bool filterPassed(RelInfo  const &checkRelInfo, tenSwUpdateError& status);
   ConfiguratorUtil::tenConfigOption getOverallReleaseFilter(TiXmlElement const &overallSection);
	
   ConfiguratorUtil::tenConfigOption getConfigOptionFromMetaInfo(XmlItemAccess subModuleAccess);
   bool doUpdate(XmlItemAccess &item, ConfiguratorUtil::tenConfigOption enConfigOption);
   bool overallAllowsMisCmcRelease(const TiXmlElement *overallSection);
   bool checkMisPendingMarker();
   //tenSwUpdateError findRelease(std::string const &mnfFilePath, std::string const &mnfFileName);

    // ------------------------------------------------------------
    // this section intialised by constructor
    tenState       _enState;		// when a method is called our last state is to be checked.

   ConfiguratorUtil _util;
   
	// usb_path for server file storage
	std::string _srvStoragePath;
    
	// needed to re-enter selectSource
    std::map<std::string, trSourceInfo> _sourcesList;
   ConfiguratorUtil::tenConfigOption _enFilterOption;
   ConfiguratorUtil::tenConfigOption _enUpdateOption;
   trSourceInfo _stSelectedSourceInfo;
    std::map<std::string, bool> _decisions;
    ScopeList<ConfigScope> _scopes;
    FCSWUPD_NS_FCSWUPD_T::tenUpdateDirection _eUpdateDirection;
   std::string _mnfPathAndName;
   typedef enum {
      enConfigTrigger_DevManagerChanged,
      enConfigTrigger_SetReleaseFilter,
      enConfigTrigger_SetUdateOptions,
      enConfigTrigger_Invalid
   } tenConfigTrigger;
   tenConfigTrigger _enConfigTrigger;

   //after finding the correct release.
   bool isOtaUpdate() {
      if(_stSelectedSourceInfo.enSourceType == tenSourceType_SCOMO || 
         _stSelectedSourceInfo.enSourceType == tenSourceType_SCOMO_INDEX) {
         return true;
      } else {
         return false;
      }
   }

};


}  // namespace fcswupdate
#endif
