#ifndef FCSWUPD_CONFIG_HPP
#define FCSWUPD_CONFIG_HPP
#include <set>
#include <string>
#include "util/swu_configBase.hpp"
#include "util/swu_singleton.hpp"
#include "util/swu_boardId.h"

#include "util/fcswupd_trace.hpp"
#include "config/fcswupd_config.h"

#ifdef __SW_UPDATE_UNIT_TESTING__
#include "util/utest/mocks/Mockswu_configItem.h"
#endif

namespace fcswupdate {

#define SECURE_BOOT_MODE_ENABLED_BIT    0x02
#define SECURE_BOOT_REVOCATION_BITS     0x07

#define GET_CFG(a, b) Config::instance()->cfg_#a.get(b))

class EnterFullOperationItemDescription: public swu::ItemDescription<tU32> {
public:
   virtual bool read(tU32 &value);

   virtual bool write(tU32 const &value) {
      return false;
   }

};

template<class CFG>
class ConfigItemBoardId : public swu::ItemDescription<std::string>
{
public:
   virtual bool read(std::string& value)
   {
	  tU32 u32BoardId = (tU32)swu::BoardId().get();
	  char bidStr[4];
	  sprintf(bidStr, "%.4X", u32BoardId);
	  value = bidStr;
	  return true;
   }

   virtual bool write(std::string const &value) { return false; }

};

class AdrVersionItemDescription: public swu::ItemDescription<std::string> {
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value) {
      return false;
   }

};


class ConfigItemFcidStr: public swu::ItemDescription<std::string> {
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value);

};


class ConfigItemPrjIdStr: public swu::ItemDescription<std::string>
{
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value);
};


class RunningCustomerVersion: public swu::ItemDescription<std::string> {
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value) {
      return false;
   }

};


class RunningFinalName: public swu::ItemDescription<std::string> {
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value) {
      return false;
   }
};


class RunningSwVersionDisplay: public swu::ItemDescription<std::string> {
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value) {
      return false;
   }

};


class ConfigItemSecureBootModeEnable: public swu::ItemDescription<tU32>
{
public:
   virtual bool read(tU32 &value);

   virtual bool write(tU32 const &value)
   {
      return false;
   }
};


class ConfigItemSRKHash: public swu::ItemDescription<std::string>
{
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value)
   {
      return false;
   }
};


class ConfigItemSRKRevocation: public swu::ItemDescription<tU32>
{
public:

   virtual bool read(tU32 &value);

   virtual bool write(tU32 const &value)
   {
      return false;
   }
};

class ConfigItemTeseoVersion: public swu::ItemDescription<std::string>
{
public:

   virtual bool read(std::string &value);

   virtual bool write(std::string const &value)
   {
      return false;
   }
};

class RunningOverallCISSWVer: public swu::ItemDescription<std::string> {
public:
   virtual bool read(std::string &value);

   virtual bool write(std::string const &value) {
      return false;
   }

};

class Config:
      public swu::ConfigBase,
      public swu::Singleton<Config> {
public:
   friend class swu::Singleton<Config>;

   virtual ~Config();

   virtual char const *getName() {
      return "Config";
   }

   virtual void traceState();

   static std::string const &getLogDirName();
   static std::string const &getPersitentDirName();
   static std::string const &getProgressFileName();
   static std::string const &getUpdateTxtPersistentPrefix();

   static std::string const &getPersistentHistoryFileName();
   static std::string const &getStaticHistoryFileName();

   static std::string const &getPersistentDataStoreFileName();
   static std::string const &getNonPersistentDataStoreFileName();
   static std::string const &getStaticDataStoreFileName();

   static std::string const &getStaticUpdateKeyFileName();
   static std::string const &getHMISettingsPath();
   static std::string const &getHMISettingsFile();


   static std::string const &getRegBasePath();
   static std::string const &getRegVersionsPath();
   static std::string const &getRegKeyAdrSwVersion();
   static std::string const &getRegKeyAdrSwVersionBosch();

   bool getUseSpmUpdateMode();
   void setUseSpmUpdateMode(bool bUseSpmUpdateMode);

   static bool getSkipPropertyDeregister();
   static void setSkipPropertyDeregister(bool bSkipPropertyDeregister);

   static tUInt getRebootWaitTimeMs();
   static void setRebootWaitTimeMs(tUInt rebootWaitTimeMs);

   static tUInt getSpmWaitTimeMs();
   static void setSpmWaitTimeMs(tUInt spmWaitTimeMs);

   static tUInt getSpmWaitAvailTimeMs();
   static void setSpmWaitAvailTimeMs(tUInt spmWaitAvailTimeMs);

   bool getIgnoreCkSumAndSig();
   void setIgnoreCkSumAndSig(bool doIgnore);

   static bool getUsePersistentPart();
   static void setUsePersistentPart(bool doUse);

   static tUInt getInstallTimeoutMs();
   static tUInt getAbortInstallTimeoutMs();

   bool getSimKds();
   void setSimKds(bool doSimulate);

   bool getImxBootRfsFailure();
   void setImxBootRfsFailure(bool bUseImxBootRfsFailure);

   // gen3armmake, gen3x86make, gen4rcar, gen4lsim: conversion to 'tU16 {aka short unsigned int}' from 'tU32 {aka unsigned int}'
   // The values of key, size are stored as tU16 so their type is changed from tU32 to uint_least16_t
   void setKdsString(uint_least16_t key, uint_least16_t size, const char *val);


   std::string getCompId(swu::ConfigItem<std::string> &configItem) {
      std::string res=configItem.get() + cfg_ScomoCompIdAppend.get();
      return res;
   }
//   bool getConfigVal(tU32 id, VALTYPE &val, bool force=false) {
//   bool setConfigVal(tU32 id, VALTYPE val, bool doSync=true) {

   swu::ConfigItem<std::string> cfg_SwuTmpDir;
   swu::ConfigItem<tU32> cfg_SwuStarting;
   swu::ConfigItem<tU32> cfg_SwuStarted;

   //For Aborting the SWU
   swu::ConfigItem<uint_least32_t> cfg_SwuAbortLuaMarker;
   swu::ConfigItem<tU32> cfg_bootChainMarkerForFcOta;

   swu::ConfigItem<std::vector<tU8> > cfg_SwUpdVariantInfo;
#if 0
   swu::ConfigItem<std::vector<tU8> > cfg_SwUpdFcIdHex;
   swu::ConfigItem<tU32> cfg_SwUpdFcIdHex2;
#endif
   swu::ConfigItem<std::string> cfg_CustomerSubProject;
   swu::ConfigItem<std::string> cfg_SupportedUSBFormats;
   swu::ConfigItem<std::string> cfg_VehicleId; 
   swu::ConfigItem<tU32> cfg_FcId;
   swu::ConfigItem<std::string> cfg_FcIdStr;
   swu::ConfigItem<tU32> cfg_PrjId;
   swu::ConfigItem<std::string> cfg_PrjIdStr;
   swu::ConfigItem<std::string> cfg_BoardId;

   swu::ConfigItem<tU32> cfg_VariantId;
   swu::ConfigItem<tU32> cfg_RegionId;
   swu::ConfigItem<std::string> cfg_HwId;
   swu::ConfigItem<std::string> cfg_CmVariantId;
   swu::ConfigItem<std::vector<tU8> > cfg_CmVariant;
   swu::ConfigItem<tU32> cfg_CmVariantWithDab;
   swu::ConfigItem<tU32> cfg_CmVariantWithCd;
   swu::ConfigItem<tU32> cfg_CmVariantDisplayType;
   swu::ConfigItem<tU32> cfg_CmVariantOem;
   swu::ConfigItem<tU32> cfg_CmVariantDtbId;
   swu::ConfigItem<std::vector<tU8> > cfg_CustomerVariant;
   swu::ConfigItem<std::vector<tU8> > cfg_EcuPartNr;
   swu::ConfigItem<std::vector<tU8> > cfg_CmNaviUnit;
   swu::ConfigItem<std::string> cfg_EcuCmVariantId;

   // demo-items for internal tests
   swu::ConfigItem<tU32> cfg_DemoU32Item1;
   swu::ConfigItem<tU32> cfg_DemoU32Item2;
   swu::ConfigItem<tU32> cfg_DemoU32Item3;
   swu::ConfigItem<std::string> cfg_DemoStringItem1;
   swu::ConfigItem<std::string> cfg_DemoStringItem2;
   swu::ConfigItem<std::vector<tU8> > cfg_DemoVectorItem1;
   swu::ConfigItem<std::vector<tU8> > cfg_DemoVectorItem2;


   // REGISTRY_VERSION_ID:
   swu::ConfigItem<std::string> cfg_RunningSwTrain;
   // REGISTRY_LABEL_ID
   swu::ConfigItem<std::string> cfg_RunningSwLabel;
   // installe customer-version, "unknown" if not set:
   swu::ConfigItem<std::string> cfg_RunningCustomerVersion;
   // depending on cfg_UseReleaseNameFromRunningSwLabel either cfg_RunningSwTrain or  cfg_RunningSwLabel
   swu::ConfigItem<std::string> cfg_RunningFinalName;
   // customer version if defined, otherwise cfg_RunningFinalName:
   swu::ConfigItem<std::string> cfg_RunningSwVersionDisplay;

   swu::ConfigItem<tU32> cfg_UseOwnAutomountInRecovery;


   swu::ConfigItem<std::vector<tU8> > cfg_InitialProgrammingDate;

   swu::ConfigItem<std::string> cfg_RunningBuildTime;
   // decides if  cfg_RunningSwTrain or cfg_RunningSwLabel shall be used.
   swu::ConfigItem<tU32> cfg_UseReleaseNameFromRunningSwLabel;
   
   swu::ConfigItem<tU32> cfg_AllowRebootDuringInstall;
   swu::ConfigItem<tU32> cfg_DoIgnoreNormalModeHMIInteractions;
   
   swu::ConfigItem<tU32> cfg_DoSimKds;
   swu::ConfigItem<tU32> cfg_DoIgnoreCkSumAndSig;

   swu::ConfigItem<std::string> cfg_ManifestFileType;
   swu::ConfigItem<std::string> cfg_ManifestSubDir;
   swu::ConfigItem<std::string> cfg_ParserTftpFilesDeveloperMode;
   swu::ConfigItem<tU32> cfg_ParserUseEncryption;
   swu::ConfigItem<tU32> cfg_ParserType;
   swu::ConfigItem<tU32> cfg_CmsParserAllowEmptyCACert;
   swu::ConfigItem<tU32> cfg_CertificateAndKeySource;

   swu::ConfigItem<std::string> cfg_LastAuthenticTimeFormat;
   swu::ConfigItem<std::string> cfg_LastAuthenticTime;

   swu::ConfigItem<std::string> cfg_ScomoIVIInstallerType;
   
   swu::ConfigItem<std::string> cfg_ScomoCompIdAppend;

   swu::ConfigItem<std::string> cfg_ScomoFirmwareCompId;
   swu::ConfigItem<std::string> cfg_ScomoWelcomeSequenceCompId;
   swu::ConfigItem<std::string> cfg_ScomoVisualsCompId;
   swu::ConfigItem<std::string> cfg_ScomoSpecialVisualsCompId;
   swu::ConfigItem<std::string> cfg_ScomoExtraDataCompId;
   swu::ConfigItem<std::string> cfg_ScomoSNMCompId;
   swu::ConfigItem<std::string> cfg_ScomoRadioLogoCompId;
   swu::ConfigItem<std::string> cfg_ScomoCarVisualsCompId;
   swu::ConfigItem<std::string> cfg_AlternativeUpdatePath;
   swu::ConfigItem<std::string> cfg_UpdateIsoFileName;
   swu::ConfigItem<tU32> cfg_NotifyHmiResultOnSuccess;
   swu::ConfigItem<tU32> cfg_NotifyCtrlError;
   swu::ConfigItem<tU32> cfg_NotifyMediumRemoval;
   swu::ConfigItem<tU32> cfg_ConfiguratorHmiNotifyVersionConflictDetails;
   swu::ConfigItem<tU32> cfg_ConfiguratorHmiNotifyMetaInfoNotFound;
   swu::ConfigItem<tU32> cfg_ConfiguratorHmiNotifyMetaInfoNotFoundInAlternatePath;
   swu::ConfigItem<tU32> cfg_ConfiguratorHmiNeedsFlashingBasedOnTrain;
   swu::ConfigItem<tU32> cfg_ConfiguratorHmiDefaultToErrNoReleaseFound;
   swu::ConfigItem<tU32> cfg_ConfiguratorAcceptAllowForceDnlForAnyRelease;
   swu::ConfigItem<tU32> cfg_ConfiguratorAllianceAllowDowngrade;
   swu::ConfigItem<tU32> cfg_ConfiguratorDeveloperForceV850Compat;
   swu::ConfigItem<std::string> cfg_UpdateStartTime;
   swu::ConfigItem<tU32> cfg_UpdateStartDistanceTotalizer;
   swu::ConfigItem<tU32> cfg_EnterRecovery;
   swu::ConfigItem<tU32> cfg_EnterEngineering;
   swu::ConfigItem<tU32> cfg_EnterFullOperation;
   swu::ConfigItem<tU32> cfg_EnterPimpedRecovery;

   swu::ConfigItem<std::string> cfg_TftpServerIpAdr;
   swu::ConfigItem<std::string> cfg_TftpRootPath;
   swu::ConfigItem<std::string> cfg_TftpLocalPath;

   swu::ConfigItem<std::string> cfg_RegionIdCustomer;
   swu::ConfigItem<std::string> cfg_TargetIdCustomer;
   swu::ConfigItem<std::string> cfg_RfsVariantId;

   
   swu::ConfigItem<tU32> cfg_MultiLanguageSupportStatus;
   swu::ConfigItem<std::string> cfg_MultiLangLocInNormalMode;
   swu::ConfigItem<std::string> cfg_ImageLocInNormalMode;

   swu::ConfigItem<tU32> cfg_UseSpmUpdateMode;
   swu::ConfigItem<tU32> cfg_EnableReEnterStateRunning;
   swu::ConfigItem<tU32> cfg_V850RebootNeeded;
   swu::ConfigItem<tU32> cfg_DoShutdownAfterUpdate;
   swu::ConfigItem<tU32> cfg_SwuCompatIndex;
   swu::ConfigItem<tU32> cfg_TestCompatUpdate;
   swu::ConfigItem<tU32> cfg_WriteFcIdAfterUpdate;
   swu::ConfigItem<tU32> cfg_VerifyAllianceXML;
   swu::ConfigItem<tU32> cfg_WriteFcIdBeforeUpdate;

   swu::ConfigItem<tU32> cfg_IncludeInitialReleaseInHistoryList;
   swu::ConfigItem<tU32> cfg_IncludeInitialReleaseInScopedHistoryList;

   swu::ConfigItem<tU32> cfg_HmiCfgAutoSelectSource;
   swu::ConfigItem<tU32> cfg_HmiCfgAutoSelectRelease;
   swu::ConfigItem<tU32> cfg_HmiCfgDefaultReleaseFilter;
   swu::ConfigItem<tU32> cfg_HmiCfgDefaultUpdateOption;
   swu::ConfigItem<tU32> cfg_HmiCfgXMLOverridesHMIReleaseFilter;
   swu::ConfigItem<tU32> cfg_PostImageInstallationRunning;
   swu::ConfigItem<tU32> cfg_AutoHandlePostImgDone;
   swu::ConfigItem<tU32> cfg_AutoHandlePostImgPending;
   swu::ConfigItem<tU32> cfg_SilentUpdate;
   swu::ConfigItem<tU32> cfg_HandleCentralLock;
   swu::ConfigItem<tU32> cfg_SpmMarkerForLock;

   swu::ConfigItem<tU32> cfg_CtrlForceRecovery;
   swu::ConfigItem<tU32> cfg_ApplyXMLFilterChain;

   swu::ConfigItem<tU32> cfg_HandleRecoveryMagicsInFcSwUpd;
   swu::ConfigItem<tU32> cfg_CtrlRetryOnRemovedStick;
   swu::ConfigItem<tU32> cfg_AddReleaseToHistory;
   swu::ConfigItem<tU32> cfg_CtrlLogXmlToStdOut;
   swu::ConfigItem<tU32> cfg_CtrlCreateWithPersistentProgress;
   swu::ConfigItem<tU32> cfg_NotifyOtaResultAfterPowerCycle;
   swu::ConfigItem<tU32> cfg_ClearOutdatedOtaUpdate;
   swu::ConfigItem<tU32> cfg_MarkerOtaFgUpdateFailed;
   swu::ConfigItem<tU32> cfg_MarkerUsbUpdateDone;

   // don't wait for removal of stick when update has started in HMI-mode and update has successfully ended
   // in recovery mode.
   swu::ConfigItem<tU32> cfg_CtrlAutoReEnterHmiMode;
   swu::ConfigItem<tU32> cfg_CtrlFullOpResultSupervisionSec;
   swu::ConfigItem<tU32> cfg_CtrlRecoveryResultSupervisionSec;

   swu::ConfigItem<tU32> cfg_RecoveryCfgDefaultReleaseFilter;
   swu::ConfigItem<tU32> cfg_RecoveryCfgUseXMLReleaseFilter;
   
   swu::ConfigItem<tU32> cfg_HmiCtrlAutoRebootOnUpdateFailure;
   swu::ConfigItem<tU32> cfg_HmiCtrlFullOpIfSuccessRebootOnStickRemoval;
   swu::ConfigItem<tU32> cfg_HmiCfgNeedsSecureBootErrors;
   swu::ConfigItem<tU32> cfg_HmiCfgReportMissingCMSAsSignatureError;
   swu::ConfigItem<tU32> cfg_CurrentMediaType;

   swu::ConfigItem<tU32> cfg_ForceShutdownRequested;
   swu::ConfigItem<tU32> cfg_UseBoschXmlDecisionsSection;

   swu::ConfigItem<tU32> cfg_RevoveryPassed;

   swu::ConfigItem<tU32> cfg_UseScomo;
   swu::ConfigItem<tU32> cfg_ScomoPhaseHandlingMode;
   swu::ConfigItem<tU32> cfg_ScomoPhase;
   swu::ConfigItem<std::string> cfg_OtaDataPath;  
   swu::ConfigItem<std::string> cfg_OtaUnpackedDir;   
   swu::ConfigItem<tU32> cfg_OtaMaxNumTries;
   swu::ConfigItem<tU32> cfg_OtaNumTries;
   swu::ConfigItem<std::string> cfg_OtaProxyPort;
   swu::ConfigItem<tU32> cfg_OtaEnableScomo;
   swu::ConfigItem<std::string> cfg_ScomoFirmwareMountCfg;

   swu::ConfigItem<std::string>cfg_DefaultToolsContainerPathAndName;

   swu::ConfigItem<std::string> cfg_SpecialReleasePathAndName;

   swu::ConfigItem<tU32> cfg_UseEstimatedTimePerPhaseOnly;
   swu::ConfigItem<tU32> cfg_CtrlMaxModRetries;

   swu::ConfigItem<std::string> cfg_AdrSwVersionLong;
   swu::ConfigItem<std::string> cfg_AdrSwVersion;
   swu::ConfigItem<std::string> cfg_AdrSwVersionBosch;

   swu::ConfigItem<std::string> cfg_V850AppVersion;
   swu::ConfigItem<std::string> cfg_V850BlVersion;

   swu::ConfigItem<tU32> cfg_TeseoVersionU32;
   swu::ConfigItem<std::string> cfg_TeseoVersion;

   swu::ConfigItem<std::string> cfg_SxmVersion;
   swu::ConfigItem<std::string> cfg_SxmHwType;

   swu::ConfigItem<std::string> cfg_DtvVersion;

   swu::ConfigItem<std::vector<tU8> > cfg_PdConfigVersion;
   swu::ConfigItem<std::vector<tU8> > cfg_CdDefConfigVersion;
   swu::ConfigItem<std::vector<tU8> > cfg_CdConfigVersion;


   swu::ConfigItem<tU32>  cfg_RecoveryMaxIdleTimeMs;
   swu::ConfigItem<tU32>  cfg_RecoveryOtaMaxIdleTimeMs;
   swu::ConfigItem<tU32>  cfg_ImxBootRfsFailure;

   swu::ConfigItem<tU32> cfg_SecureBootModeEnabled;
   swu::ConfigItem<std::string> cfg_SRKHash;
   swu::ConfigItem<tU32> cfg_SRKRevocation;
   swu::ConfigItem<tU32> cfg_AllowMisCmcRelease;
   swu::ConfigItem<tU32> cfg_InitialProgrammingDateRequested;
   swu::ConfigItem<std::string> cfg_RunningOverallCISSWVer;

protected:
   Config();
   
};

}
#endif
