/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
***************************************************************************/
/*!
*\file     SWUCoreComponent.h
*\brief    hand crafted code
*
*\author   CM-AI/PJ-G33
*          berthold.klodwig@de.bosch.com
*
*\par Copyright:
*(c) 2012-2013 Robert Bosch Car Multimedia GmbH
***************************************************************************/

#ifndef SWUCORECOMPONENT_H_
#define SWUCORECOMPONENT_H_


#include "asf/core/ApplicationIF.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "ai_sw_update/common/core/imp/SWUCoreServiceStub.h"

#include "core/imp/LuaInterpreter.h"
#include "util/swu_isoContainer.h"
#include "platform/imp/wdgHandler.h"

#include "base/imp/swupd_trace.h"

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {

using namespace ai_sw_update::common::core::imp::SWUCoreService;

class SWUCoreComponentStub
: public SWUCoreServiceStub
{
public:
  SWUCoreComponentStub();
    virtual ~SWUCoreComponentStub();

    virtual void onEnterUpdateSessionRequest (const ::boost::shared_ptr< SWUCoreService::EnterUpdateSessionRequest >& request);
    virtual void onExitUpdateSessionRequest (const ::boost::shared_ptr< SWUCoreService::ExitUpdateSessionRequest >& request);
    virtual void onAbortInstallRequest (const ::boost::shared_ptr< SWUCoreService::AbortInstallRequest >& request);
    virtual void onRequestRecoveryDownloadRequest (const ::boost::shared_ptr< SWUCoreService::RequestRecoveryDownloadRequest >& request);
    virtual void onSetIsoPathRequest (const ::boost::shared_ptr< SWUCoreService::SetIsoPathRequest >& request);
    virtual void onStartInstallRequest (const ::boost::shared_ptr< SWUCoreService::StartInstallRequest >& request);
    virtual void onConfigUpdateSessionRequest (const ::boost::shared_ptr< SWUCoreService::ConfigUpdateSessionRequest >& request);
    virtual void ondisplayText(std::string str1, std::string str2, std::string str3);
    
    virtual void onbgImageDetails(std::string str1, std::string str2);

private:
    tenInstallResult mapCoreInstallResultToAsf(int iCoreInstallResult);

    LuaInterpreter _LuaInterpreter;
   swu::IsoContainer _isoContainer;
    trCkSum _lastContainerCkSum;
   bool _isoContainerValid;
    bool _last_mod_succeded;

    DECLARE_CLASS_LOGGER ();
};


class SWUCoreComponent
: public ::asf::core::BaseComponent
{
public:
  SWUCoreComponent();
  virtual ~SWUCoreComponent();

  static void vLegacyTraceCahnnelCB(void* par);

  // call component stub, display text functionlity derived from SWUCoreServiceStub 
  void dispatchText(std::string const &str1, std::string const & str2,std::string const & str3){
        _componentStub.ondisplayText(str1,str2,str3);
  }

  
  // call component stub, capture image details derived from SWUCoreServiceStub
  void bgImageDetails(std::string const &str1, std::string const & str2){
        _componentStub.onbgImageDetails(str1,str2);
  }
  // a way to get the handle of component
  static SWUCoreComponent *getInstance(){
        return _instance;
  }

private:
  static SWUCoreComponent * _instance;
  ai_sw_update::common::core::imp::SWUCoreComponentStub _componentStub;
};


} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update


#endif // SWUCORECOMPONENT_H_
